<?php

/**
 * @desc
 */
$reports["_ROAD_TO_SALES"] = [
    "ClassName" => "RoadToSales",
    "Category" => "_PERFORMANCE",
    "canAggregate" => false,
    "icon" => "images/icons/32x32/roadtosales.png",
    "Options" => "daterangeField,profileselector,limit,roadto",
    "Filename" => "road_to_sales",
    "Distribution" => "Premium",
    "Order" => 9,
    "ReportVersion" => 1.0,
    "MinimumVersion" => 3.0,
    "EmailAlerts" => false,
    "Update" => false
];

class RoadToSales extends Report
{

    function Settings()
    {
        $this->help = _ROAD_TO_SALES_DESC;
    }

    function DisplayReport()
    {
        global $db, $databasedriver, $mini, $cachename;
        $this->displayReportButtons = false;
        $this->remove_outputmodes = ["all"];
        $reportData = [];

        $this->columnDefinitions[] = ["Label" => _PAGE, "actionmenu" => 'page', "displayMaxChars" => 40];
        $this->columnDefinitions[] = ["Label" => _USERS];
        $this->columnDefinitions[] = ["Label" => _USERS_PERC];
        $this->setupColumnDefinitions();

        if (empty($this->roadto)) {
            if ($this->profile->targetfiles) {
                $targets = explode(",", $this->profile->targetfiles);
                $this->roadto = $targets[0];
            } else {
                $this->ReportHeader();
                echoNotice(
                    _REPORT_NEEDS_KPI . "<br/><br/><a href='profile.php?conf={$this->profile->profilename}#_KPI' class='btn btn-default'>" . _EDIT_PROFILE . ": " . _KPI . "</a>",
                    "margin:10px;"
                );
                return false;
            }
        }
        $query = $db->Execute(
            "select visitorid,timestamp from {$this->profile->tablename} as a,{$this->profile->tablename_urls} as u where timestamp >=" . $db->quote(
                $this->from
            ) . " and timestamp <=" . $db->quote($this->to) . " and a.url=u.id and u.url=" . $db->quote(
                $this->roadto
            ) . " group by visitorid"
        );
        $i = 1;
        $qpart = "0";
        $notqpart = "0";
        while ($data = $query->FetchRow()) {
            if ($i == 1) {
                $qpart = "(visitorid='" . $data["visitorid"] . "' and timestamp < " . $data["timestamp"] . ") ";
                $notqpart = "visitorid!='" . $data["visitorid"] . "' ";
            } else {
                $qpart .= "or (visitorid='" . $data["visitorid"] . "' and timestamp < " . $data["timestamp"] . ") ";
                $notqpart .= "and visitorid!='" . $data["visitorid"] . "' ";
            }
            $i++;
        }
        $totbuy = $i - 1;

        $query = $db->Execute(
            "select count(distinct visitorid) as uniq from {$this->profile->tablename} " . ($databasedriver == "mysql" ? "force index (timestamp)" : "") . " where timestamp >=" . $db->quote(
                $this->from
            ) . " and timestamp <=" . $db->quote($this->to) . " and ($notqpart)"
        );
        $data = $query->FetchRow();
        $tot = $data["uniq"];

        $ltot = "($tot)";
        $ltotbuy = "($totbuy)";

        $this->displayReportButtons = false;
        $this->ReportHeader();
        $mini = 1;
        $this->displayHeader = false;
        $this->displayTotalRow = false;
        $cachename = 1; // this is just to make sure each table in this reports gets a unique id
        echo "<div class='sales-report-container'>";
        ////// Top Pages as % of Converted Users REPORT
        echo "<div class='sales-report'>";
        echo "<div class='sales-report-header'>" . _TOP_PAGES_AS_PERC_OF_CONV_USERS . " $ltotbuy</div>";
        $query = $db->Execute(
            "select u.url as url,count(distinct visitorid) as users,((count(distinct visitorid)*1.00)/$totbuy*100) as visitors from {$this->profile->tablename} as a,{$this->profile->tablename_urls} as u where timestamp >=" . $db->quote(
                $this->from
            ) . " and timestamp <=" . $db->quote($this->to) . " and ($qpart) and a.url=u.id and u.url!=" . $db->quote(
                $this->roadto
            ) . " and status='200' group by a.url order by visitors desc limit " . $this->limit
        );
        $i = 0;
        while ($data = $query->FetchRow()) {
            $reportData[$i][0] = $data["url"];
            $reportData[$i][1] = $data["users"];
            $reportData[$i][2] = $data["visitors"];
            $i++;
        }

        $this->Table($reportData);
        echo "</div>";

        $cachename++;
        ////// Top Pages of Non-Converted Users REPORT
        echo "<div class='sales-report-right'>";
        echo "<div class='sales-report-header'>" . _TOP_PAGES_NON_CONV_USERS . " $ltot</div>";
        $reportData = [];
        $query = $db->Execute(
            "select u.url,count(distinct visitorid) as users,((count(distinct visitorid)*1.00)/$tot*100) as visitors from {$this->profile->tablename} as a,{$this->profile->tablename_urls} as u where timestamp >=" . $db->quote(
                $this->from
            ) . " and timestamp <=" . $db->quote(
                $this->to
            ) . " and ($notqpart) and status='200' and a.url=u.id group by a.url order by visitors desc limit " . $this->limit
        );
        $i = 0;
        while ($data = $query->FetchRow()) {
            $reportData[$i][0] = $data["url"];
            $reportData[$i][1] = $data["users"];
            $reportData[$i][2] = $data["visitors"];
            $i++;
        }
        $this->Table($reportData);
        echo "</div>";

        echo "<div class='clear'></div>";

        $cachename++;
        ////// Top Keywords as % of Converted Users REPORT
        echo "<div class='sales-report'>";
        echo "<div class='sales-report-header'>" . _TOP_KEYWORDS_AS_PERC_OF_CONV_USERS . " $ltotbuy</div>";
        $reportData = [];

        $this->columnDefinitions = [];
        $this->columnDefinitions[] = ["Label" => _KEYWORDS, "actionmenu" => 'keyword', "displayMaxChars" => 40];
        $this->columnDefinitions[] = ["Label" => _USERS];
        $this->columnDefinitions[] = ["Label" => _USERS_PERC];
        $this->setupColumnDefinitions();

        $query = $db->Execute(
            "select k.keywords,count(distinct visitorid) as users,((count(distinct visitorid)*1.00)/$totbuy*100) as visitors, url from {$this->profile->tablename} as a,{$this->profile->tablename_keywords} as k where timestamp >=" . $db->quote(
                $this->from
            ) . " and timestamp <=" . $db->quote(
                $this->to
            ) . " and a.keywords=k.id and k.keywords!='' and ($qpart) group by a.keywords order by visitors desc limit " . $this->limit
        );
        $i = 0;
        while ($data = $query->FetchRow()) {
            $reportData[$i][0] = $data["keywords"];
            $reportData[$i][1] = $data["users"];
            $reportData[$i][2] = $data["visitors"];
            $i++;
        }
        $this->Table($reportData);
        echo "</div>";

        $cachename++;
        ////// Top Keywords of Non-Converted Users REPORT
        echo "<div class='sales-report-right'>";
        echo "<div class='sales-report-header'>" . _TOP_KEYWORDS_NON_CONV_USERS . " $ltot</div>";
        $reportData = [];
        $query = $db->Execute(
            "select k.keywords,count(distinct visitorid) as users,((count(distinct visitorid)*1.00)/$tot*100) as visitors from {$this->profile->tablename} as a,{$this->profile->tablename_keywords} as k where timestamp >=" . $db->quote(
                $this->from
            ) . " and timestamp <=" . $db->quote(
                $this->to
            ) . " and a.keywords=k.id and k.keywords!='' and ($notqpart) group by a.keywords order by visitors desc limit " . $this->limit
        );
        $i = 0;
        while ($data = $query->FetchRow()) {
            $reportData[$i][0] = $data["keywords"];
            $reportData[$i][1] = $data["users"];
            $reportData[$i][2] = $data["visitors"];
            $i++;
        }
        $this->Table($reportData);
        echo "</div>";

        echo "<div class='clear'></div>";

        $cachename++;
        ////// Traffic Sources as % of Converted Users REPORT
        echo "<div class='sales-report'>";
        echo "<div class='sales-report-header'>" . _TRAFFIC_SOURCES_AS_PERC_OF_CONV_USERS . " $ltotbuy</div>";
        $reportData = [];

        $this->columnDefinitions = [];
        $this->columnDefinitions[] = ["Label" => _REFERRER, "displayMaxChars" => 40, "actionmenu" => 'referrer'];
        $this->columnDefinitions[] = ["Label" => _USERS];
        $this->columnDefinitions[] = ["Label" => _USERS_PERC];
        $this->setupColumnDefinitions();

        $query = $db->Execute(
            "select r.referrer,count(distinct visitorid) as users,((count(distinct visitorid)*1.00)/$totbuy*100) as visitors from {$this->profile->tablename} as a,{$this->profile->tablename_referrers} as r where timestamp >=" . $db->quote(
                $this->from
            ) . " and timestamp <=" . $db->quote(
                $this->to
            ) . " and a.referrer=r.id and r.referrer!='-' and r.referrer NOT like " . $db->quote(
                "%{$this->profile->confdomain}%"
            ) . " and ($qpart) group by a.referrer order by visitors desc limit " . $this->limit
        );
        $i = 0;
        while ($data = $query->FetchRow()) {
            $reportData[$i][0] = $data["referrer"];
            $reportData[$i][1] = $data["users"];
            $reportData[$i][2] = $data["visitors"];
            $i++;
        }
        $this->Table($reportData);
        echo "</div>";

        $cachename++;
        ////// Traffic Sources of Non-Converted Users REPORT
        echo "<div class='sales-report-right'>";
        echo "<div class='sales-report-header'>" . _TRAFFIC_SOURCES_NON_CONV_USERS . " $ltot</div>";
        $reportData = [];
        $query = $db->Execute(
            "select r.referrer,count(distinct visitorid) as users,((count(distinct visitorid)*1.00)/$tot*100) as visitors from {$this->profile->tablename} as a,{$this->profile->tablename_referrers} as r where timestamp >=" . $db->quote(
                $this->from
            ) . " and timestamp <=" . $db->quote(
                $this->to
            ) . " and a.referrer=r.id and r.referrer!='-' and r.referrer NOT like " . $db->quote(
                "%{$this->profile->confdomain}%"
            ) . " and ($notqpart) group by a.referrer order by visitors desc limit " . $this->limit
        );
        $i = 0;
        while ($data = $query->FetchRow()) {
            $reportData[$i][0] = $data["referrer"];
            $reportData[$i][1] = $data["users"];
            $reportData[$i][2] = $data["visitors"];
            $i++;
        }
        $this->Table($reportData);
        echo "</div>";

        echo "<div class='clear'></div>";

        echo "</div>";
    }

    function UpdateStats($from = '', $to = '', $print = 2)
    {
        return false;
    }
}

