<?php

/**
 * @desc This report displays the used operating systems
 */
$reports["_MOBILE_OS"] = [
    "ClassName" => "MobileOperatingSystems",
    "Category" => "_CLIENT_SYSTEM",
    "icon" => "images/icons/32x32/operatingsystems.png",
    "Options" => "daterangeField,profileselector,displaymode,trafficsource",
    "Filename" => "mobile_os",
    "Distribution" => "Premium",
    "Order" => 9,
    "ReportVersion" => 1.0,
    "MinimumVersion" => 3.0,
    "EmailAlerts" => true,
    "Update" => false
];

class MobileOperatingSystems extends Report
{

    function Settings()
    {
        $this->DefaultDisplay = "pie";
        $this->DisplayModes = "table,pie";
        $this->columnDefinitions[] = ["Label" => "_OPERATING_SYSTEM"];
        $this->columnDefinitions[] = ["Label" => "_VISITS"];
        $this->sort_order = SORT_DESC;
        $this->sort_key = 1;
    }

    function GetReportData()
    {
        global $reports;
        $r = new $reports["_MOBILE_OS_VERSIONS"]["ClassName"]();
        $r->sort_order = SORT_DESC;
        $r->sort_key = 1;
        $r->key_col = 3;
        $data = $r->GetReportData();

        $newdata = [];
        $newdata = $this->DataGroupBy($data, 3);

        $data = [];
        $i = 0;

        foreach ($newdata as $dat) {
            $data[$i][0] = $dat[3];
            $data[$i][1] = $dat[1];
            $i++;
        }
        return $data;
    }

    function UpdateStats($from = '', $to = '', $print = 2)
    {
        return false;
    }
}


