<?php

const _MINI_TOTAL_VISITS = _TOTAL_VISITS;

$reports["_MINI_TOTAL_VISITS"] = [
    "ClassName" => "MiniTotalVisits",
    "Category" => "_KEY_METRIC",
    "icon" => "images/icons/32x32/visitorsperday.png",
    "Options" => "daterangeField,profileselector",
    "Filename" => "metric_total_visits",
    "Distribution" => "Standard",
    "Order" => 1,
    "ReportVersion" => 6.0,
    "MinimumVersion" => 6.0,
    "Update" => false
];

class MiniTotalVisits extends Report
{

    function GetReportData()
    {
        global $reports;

        $r = new $reports['_VISITORS_PER_DAY']['ClassName']();
        $r->IgnReIm = 1;
        $r->from = $this->from;
        $r->to = $this->to;
        $data = $r->GetReportData();

        $visits = 0;

        foreach ($data as $row => $col) {
            $visits += $col[4];
        }

        $daterange = date(implode($this->profile->dateFormat), $this->from) . " - " . date(
                implode($this->profile->dateFormat),
                $this->to
            );

        return [
            _VISITS                # Label
        ,
            number_format($visits) # Number to display
        ,
            '_VISITORS_PER_DAY'    # Report label to load
        ,
            'ion-person-add'        # Background icon Class
        ,
            'bg-green'
        ,
            "<strong>" . $daterange . "</strong><br/>" . _MINI_TOTAL_VISITS_DESC
        ];
    }
}

