<?php

const _MINI_CONVERSION_RATE = _CONVERSION_RATE;

$reports["_MINI_CONVERSION_RATE"] = [
    "ClassName" => "MiniConversionRate",
    "Category" => "_KEY_METRIC",
    "icon" => "images/icons/32x32/visitorsperday.png",
    "Options" => "daterangeField,profileselector",
    "Filename" => "metric_conversion_rate",
    "Distribution" => "Standard",
    "Order" => 4,
    "ReportVersion" => 6.0,
    "MinimumVersion" => 6.0,
    "Update" => false
];

class MiniConversionRate extends Report
{

    function Settings()
    {
        $this->datafiles = false;
        $this->IgnReIm = 1;
    }

    function DefineQuery()
    {
        global $db;

        $query = subsetDataToSourceID(
            "select count(distinct visitorid) from {$this->profile->tablename} where timestamp >=" . $db->quote(
                $this->from
            ) . " and timestamp <=" . $db->quote($this->to) . "",
            $this->trafficsource
        );

        $prequery = $db->Execute($query);
        $ptot = $prequery->FetchRow();
        $query = "select count(*) as hits,count(distinct visitorid),((count(distinct visitorid)*1.00)/{$ptot[0]})*100 as ctr from {$this->profile->tablename_conversions} as a where timestamp >=" . $db->quote(
                $this->from
            ) . " and timestamp <=" . $db->quote($this->to);

        return $query;
    }

    function GetReportData()
    {
        global $reports;

        if (count($this->profile->targets) > 0) {
            $data = $this->GetDataFromDb();

            $total = 0;
            $i = 0;

            if (!is_array($data)) {
                if ($data !== false) {
                    while ($row = $data->FetchRow()) {
                        $total += number_format($row[2], 2);
                        $i++;
                    }
                }
            } else {
                foreach ($data as $row) {
                    $total += number_format($row[2], 2);
                    $i++;
                }
            }

            # if there is no data set to zero
            if ($i == 0) {
                $avg = 0;
            } else {
                $avg = $total / $i;
            }
            $perc = number_format($avg, 2) . "%";
        } else {
            $perc = "N/A";
        }
        $daterange = date(implode($this->profile->dateFormat), $this->from) . " - " . date(
                implode($this->profile->dateFormat),
                $this->to
            );
        return [
            "KPI " . _CONVERSION_RATE# Label
        ,
            $perc                    # Number to display
        ,
            '_OVERALL_PERFORMANCE'    # Report label to load
        ,
            'ion-speedometer'        # Background icon Class
        ,
            'bg-light-blue'
        ,
            "<strong>" . $daterange . "</strong><br/>" . _MINI_CONVERSION_RATE_DESC
        ];
    }
}

