<?php

const _MINI_BOUNCE_RATE = _BOUNCE_RATE . "&nbsp;";

$reports["_MINI_BOUNCE_RATE"] = [
    "ClassName" => "MiniBounceRate",
    "Category" => "_KEY_METRIC",
    "icon" => "images/icons/32x32/visitorsperday.png",
    "Options" => "daterangeField,profileselector",
    "Filename" => "metric_bounce_rate",
    "Distribution" => "Standard",
    "Order" => 5,
    "ReportVersion" => 6.0,
    "MinimumVersion" => 6.0,
    "Update" => false
];

class MiniBounceRate extends Report
{

    function GetReportData()
    {
        global $reports;

        $r = new $reports['_BOUNCE_RATE_PER_DAY']['ClassName']();
        $r->IgnReIm = 1;
        $r->from = $this->from;
        $r->to = $this->to;
        $data = $r->GetReportData();

        $total = 0;
        $avg = 0;
        $i = 0;

        foreach ($data as $day => $vals) {
            $total += $vals[1];
            $i++;
        }

        if ($i == 0) {
            $avg = 0;
        } else {
            $avg = number_format(($total / $i), 2) . "%";
        }

        $daterange = date(implode($this->profile->dateFormat), $this->from) . " - " . date(
                implode($this->profile->dateFormat),
                $this->to
            );

        return [
            _MINI_BOUNCE_RATE_LABEL        # Label
        ,
            $avg                            # Number to display
        ,
            '_BOUNCE_RATE_PER_DAY'            # Report label to load
        ,
            'ion-android-share'            # Background icon Class
        ,
            'bg-red'
        ,
            "<strong>" . $daterange . "</strong><br/>" . _MINI_BOUNCE_RATE_DESC
        ];
    }
}

