<?php


$reports["_INTERCOM_SEGMENTS"] = [

    "ClassName" => "IntercomSegments",
    "Category" => "_INTERCOM",
    "Options" => "limit,displaymode",
    "Distribution" => "Premium",
    "EmailAlerts" => false,
    "Update" => false,
    "Filename" => "intercom_segments"


];


class IntercomSegments extends Report
{

    function Settings()
    {
        $this->DisplayModes = "table,pie";
        $this->DefaultDisplay = "pie";
        $this->columnDefinitions[] = ["Label" => "Segment"];
        $this->columnDefinitions[] = ["Label" => "Users"];
        $this->help = "This will show all segments for intercom.";
        $old_api_id = $this->profile->GetOtherSettings("IntercomApiId", "");
        $old_api_key = $this->profile->GetOtherSettings("IntercomApiKey", "");
        if (isset($this->ApiKey) && $this->ApiKey != $old_api_key) {
            $this->profile->SetOtherSettings("IntercomApiKey", $this->ApiKey);
        } else {
            $this->ApiKey = $old_api_key;
        }
        if (isset($this->ApiID) && $this->ApiID != $old_api_id) {
            $this->profile->SetOtherSettings("IntercomApiId", $this->ApiID);
        } else {
            $this->ApiID = $old_api_id;
        }
    }

    function DisplayCustomForm()
    {
        $form = "<div class='form-group'>" .
            "<label for='author'>API Key:</label>
                <input type='text' name='ApiKey'
                value='" . @$this->ApiKey . "' class='report_option_field form-control' /> " .
            "</div>" .
            "<div class='form-group'>" .
            "<label for='author'>API ID:</label>
                <input type='text' name='ApiID'
                value='" . @$this->ApiID . "' class='report_option_field form-control' />" .
            "</div>";

        return $form;
    }

    function GetReportData()
    {
        $r = $this->curl_download("https://api.intercom.io/counts?type=user&count=segment");
        $result = json_decode($r, true);


        if ($result['type'] == 'error.list') {
            foreach ($result['errors'] as $k => $v) {
                echoWarning("Intercom Error ({$v['code']}) : {$v['message']}");
            }
            return [];
        }

        if (empty($result)) {
            return [];
        }

        $data = [];
        foreach ($result['user']['segment'] as $key => $user) {
            foreach ($user as $k => $v) {
                $data[$key][0] = $k;
                $data[$key][1] = $v;
            }
        }

        return $data;
    }

    function curl_download($Url)
    {
        // OK cool - then let's create a new cURL resource handle
        $ch = curl_init();

        // Now set some options (most are optional)

        // Set URL to download
        curl_setopt($ch, CURLOPT_URL, $Url);


        curl_setopt($ch, CURLOPT_USERPWD, $this->ApiID . ":" . $this->ApiKey);
        // Include header in result? (0 = yes, 1 = no)
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Accept: application/json',
        ]);

        // Should cURL return or print out the data? (true = return, false = print)
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        // Timeout in seconds
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);

        // Download the given URL, and return output_add_rewrite_var(name, value)
        $output = curl_exec($ch);

        // Close the cURL resource, and free system resources
        curl_close($ch);


        return ($output);
    }

    function DisplayReport()
    {
        // is cURL installed yet?
        if (!function_exists('curl_init')) {
            echoWarning('Sorry cURL is not installed!');
            return false;
        }

        if (empty($this->ApiID) || empty($this->ApiKey)) {
            echoNotice(
                $this->SettingsButton(
                ) . "The ID field or the Key field is empty. <br><br> for more information: check <a href='https://developers.intercom.io/page/getting-started 'target='_blank'>the documentation</a>. "
            );
            return false;
        } else {
            parent::DisplayReport();
        }
    }
}

