<?php

/**
 * @desc This report displays the age of your facebook friends
 */
$reports["_FACEBOOK_API_CALLS"] = [
    "ClassName" => "FacebookAppAPICalls",
    "Category" => "_FACEBOOK",
    "icon" => "images/icons/32x32/fb_sharing.png",
    "Options" => "daterangeField,displaymode",
    "Filename" => "facebook_app_api_calls",
    "Distribution" => "Premium",
    "Order" => 12,
    "ReportVersion" => 4.0,
    "MinimumVersion" => 3.0,
    "EmailAlerts" => false,
    "Update" => false
];

class FacebookAppAPICalls extends FacebookCore
{

    function Settings()
    {
        parent::Settings();
        $this->DisplayModes = "table,barchart";
        $this->DefaultDisplay = "barchart";
        if (empty($this->displaymode)) {
            $this->displaymode = $this->DefaultDisplay;
        }
        $this->addlabel = _FACEBOOK_API_CALLS_ADDLABEL;
        $this->help = _FACEBOOK_API_CALLS_ADDLABEL;
        $this->metric = "calls";
        $this->metric_restriction = "app";
    }

    function DisplayTable()
    {
        ?>
        <script type="text/javascript">
            function lg_fb_<?php echo $this->graphID; ?>(container_id, result) {
                if (result.Status == undefined || result.Status != "Success") {
                    return;
                }

                const data = result.data;
                if (!data || data === undefined) {
                    console.log("No data");
                    return;
                }

                const dataSet = [];

                const columnSet = [
                    {title: "<?php echo _DATE; ?>"},
                    {title: "API Calls"}
                ];

                for (let i = 0; i < data.length; i++) {
                    const row = data[i];
                    const time = d3.time.format('<?php echo GetCustomDateFormat("D3"); ?>')(new Date(row.time));

                    dataSet.push([time, row.value.toString()]);

                }

                $("#" + container_id).dataTable({
                    data: dataSet,
                    columns: columnSet,
                    "iDisplayLength": dataSet.length,
                    "aaSorting": [],
                    "sDom": "t"
                });

            }
        </script><?php
    }

    function DisplayGraph()
    {
        ?>
        <script type="text/javascript">
            function lg_fb_<?php echo $this->graphID; ?>(container_id, result) {
                if (result.Status == undefined || result.Status != "Success") {
                    return;
                }

                const data = result.data;
                if (!data || data === undefined) {
                    console.log("No data");
                    return;
                }

                const lg_gr_data = [];
                const xticks = [];

                for (let i = 0; i < data.length; i++) {
                    const row = data[i];

                    xticks.push(d3.time.format('<?php echo GetCustomDateFormat("D3"); ?>')(new Date(row.time)));

                    if (lg_gr_data[0] == undefined) {
                        lg_gr_data[0] = {
                            key: "<?php echo _API_CALLS; ?>",
                            values: [
                                [i, parseInt(row.value)]
                            ]
                        };
                    } else {
                        lg_gr_data[0].values.push({x: i, y: parseInt(row.value)});
                    }
                }

                $("#" + container_id).attr("data-ticks", JSON.stringify(xticks));
                $("#" + container_id).attr("data-chart", JSON.stringify(lg_gr_data));

                lg.BarChart(container_id);
            }
        </script><?php
    }
}

?>