<?php

/**
 * @desc Definitions for this report: Top Pages Details
 *
 * Page: The requested page, excluding any parameters (e.g. ?variable=1)
 * Unique ID's: The total number of visitors (including human and bot/crawler)
 * Pageviews: The total number of pages requested (excluding any bots and crawlers).
 * Total requests: The total number of times this page was requested.
 * Crawled %: The percentage of requests that were generated by bots or crawlers (like the googlebot indexer).
 */

$reports["_EXIT_CLICKS"] = [
    "ClassName" => "ExitClicks",
    "Category" => "_NAVIGATION",
    "icon" => "images/icons/32x32/exit_clicks.png",
    "Options" => "daterangeField,profileselector,displaymode,trafficsource,search,limit,columnSelector",
    "Filename" => "exit_clicks",
    "Distribution" => "Premium",
    "Order" => 6,
    "ReportVersion" => 1.0,
    "MinimumVersion" => 3.0,
    "EmailAlerts" => true,
    "Update" => false,
    "canAggregate" => false
];

class ExitClicks extends Report
{

    function Settings()
    {
        $this->DefaultDisplay = "table";
        $this->DisplayModes = "table,pie";
        $this->datafiles = false;
        if (!empty($this->external_url)) {
            $this->columnDefinitions[] = ["Label" => "_PAGE", "actionmenu" => 'page'];
            $this->columnDefinitions[] = ["Label" => "_CLICKS", "dataType" => "String"];
            $this->columnDefinitions[] = ["Label" => "_VISITS", "dataType" => "String"];
        } else {
            $this->columnDefinitions[] = ["Label" => "Link URL"];
            $this->columnDefinitions[] = ["Label" => "_CLICKS", "dataType" => "String"];
            $this->columnDefinitions[] = ["Label" => "_VISITS", "dataType" => "String"];
        }
        $this->actionmenu_type = 'page';
        $this->displayTotalRow = false;
        $this->sort_order = SORT_DESC;
        $this->sort_key = 1;
        $this->help = _EXIT_CLICKS_DESC . "<br><a class='btn btn-default' href='profile.php?conf={$this->profile->profilename}#_EXIT_CLICKS'>" . _EDIT_PROFILE . ": " . _EXIT_CLICKS . "</a>";
    }

    function DefineQuery()
    {
        global $nc, $db;

        if (!empty($this->external_url)) {
            $this->addlabel .= _VIEWING_PAGES_LINK_TO . ": {$this->external_url}";
            $query = subsetDataToSourceID(
                "SELECT u.url, COUNT(*) AS clicks, COUNT(DISTINCT sessionid) AS visits, SUBSTRING(up.params,(LOCATE('exit_to_url', up.params) + LENGTH('exit_to_url'))) AS external, COUNT(DISTINCT visitorid) AS visitors FROM {$this->profile->tablename} AS a, {$this->profile->tablename_urlparams} AS up, {$this->profile->tablename_urls} AS u WHERE a.timestamp between " . $db->Quote(
                    $this->from
                ) . " and " . $db->Quote(
                    $this->to
                ) . " and a.params = up.id AND a.url = u.id AND up.params LIKE '%exit_to_url%' AND SUBSTRING(up.params,(LOCATE('exit_to_url', up.params) + LENGTH('exit_to_url'))) LIKE " . $db->Quote(
                    "%{$this->external_url}"
                ) . " {$searchst} GROUP BY u.url, external ORDER BY clicks DESC"
            );
        } else {
            $query = subsetDataToSourceID(
                "SELECT SUBSTRING(up.params,(LOCATE('exit_to_url', up.params) + LENGTH('exit_to_url'))) AS external, COUNT(*) AS clicks, COUNT(DISTINCT sessionid) AS visits, COUNT(DISTINCT visitorid) AS visitors FROM {$this->profile->tablename} AS a, {$this->profile->tablename_urlparams} AS up, {$this->profile->tablename_urls} AS u WHERE a.timestamp between " . $db->Quote(
                    $this->from
                ) . " and " . $db->Quote(
                    $this->to
                ) . " and a.params = up.id AND a.url = u.id AND up.params LIKE '%exit_to_url%' GROUP BY external ORDER BY clicks DESC"
            );
        }

        $this->applytrafficsource = false;

        return $query;
    }

    function DisplayReport()
    {
        $data = $this->GetReportData();

        if (empty($data)) {
            $this->reportHeader();
            echoNotice($this->SettingsButton() . _NO_DATA_TO_DISPLAY, "margin:15px;");

            return false;
        }

        if (empty($this->external_url)) {
            foreach ($data as $k => $v) {
                $val = str_replace("=", "", urldecode($v[0]));
                $v[0] = urlencode($val);

                $data[$k][0] = "<a class='open_in_this_dialog quickopen' href='{$_SERVER['REQUEST_URI']}&external_url={$v[0]}'>{$val}</a>";
            }
        }

        $this->Table($data);
    }

    function UpdateStats($from = '', $to = '', $print = 2)
    {
        return false;
    }
}


