<?php

/**
 * @desc This report displays the error report
 */
$reports["_ERROR_REPORT"] = [
    "ClassName" => "ErrorReport",
    "Category" => "_PROBLEMS",
    "icon" => "images/icons/32x32/errorreport.png",
    "Options" => "daterangeField,profileselector,displaymode,trafficsource,search,limit",
    "Filename" => "error_report",
    "Distribution" => "Standard",
    "Order" => 1,
    "ReportVersion" => 1.0,
    "MinimumVersion" => 3.0,
    "EmailAlerts" => true
];

class ErrorReport extends Report
{

    function Settings()
    {
        $this->DefaultDisplay = "table";
        $this->DisplayModes = "table,pie";
        $this->actionmenu_type = 'status';
        $this->sort_order = SORT_DESC;
        $this->sort_key = 1;
        if (!empty($this->status)) {
            $this->addlabel .= _ERROR_CODE . ": " . $this->status;
            $this->fileNameExpension = "." . $this->status;
            $this->columnDefinitions[] = ["Label" => "_PAGE", "actionmenu" => 'page'];
        } else {
            $this->columnDefinitions[] = ["Label" => "_STATUS", "actionmenu" => 'error'];
        }

        $this->columnDefinitions[] = ["Label" => "_VIEWED_PAGES"];
        $this->columnDefinitions[] = ["Label" => "_CRAWLED_PAGES"];
        $this->columnDefinitions[] = ["Label" => "_TOTAL_HITS"];
    }

    function DefineQuery()
    {
        global $db;
        $merge = $this->profile->tablename_merge;
        $query = "select concat(l.status,' - ',s.descr),(count(*)-sum(crawl)) as viewed, sum(crawl),count(*) from " . $merge . " as l, {$this->profile->tablename_urls} as u, " . TBL_LGSTATUS . " as s where l.timestamp >=" . $db->quote(
                $this->from
            ) . " and l.timestamp <=" . $db->quote(
                $this->to
            ) . " and l.status=s.code and l.url = u.id and l.status!=200 and (l.crawl=0 or l.crawl=1) group by l.status, s.descr order by viewed desc";

        return $query;
    }
}


