<?php

$reports["_ADWORDS_CLICKS_PER_USER"] = [
    "ClassName" => "AdwordsClicksPerUser",
    "Category" => "_ADVERTISING",
    "Options" => "daterangeField,profileselector,displaymode,trafficsource,search,country_list,limit,columnSelector",
    "Filename" => "adwords_clicks_per_user",
    "Distribution" => "Premium",
    "Order" => 9,
    "ReportVersion" => 1.0,
    "MinimumVersion" => 3.0,
    "EmailAlerts" => true
];

class AdwordsClicksPerUser extends Report
{

    function Settings()
    {
        $this->datafiles = false;
        $this->DefaultDisplay = "table";
        $this->DisplayModes = "table";
        $this->columnDefinitions[] = ["Label" => "_IP_NUMBER", "actionmenu" => 'ip', "search" => true];
        $this->columnDefinitions[] = ["Label" => "_CLICKS", "bchart" => true];
        $this->columnDefinitions[] = ["Label" => "_VISITS", "bchart" => false];
        $this->columnDefinitions[] = ["Label" => "CPV"];
        $this->columnDefinitions[] = ["Label" => "_COUNTRY", "actionmenu" => 'country'];
        $this->columnDefinitions[] = ["Label" => "_TIME"];
        $this->columnDefinitions[] = ["Label" => "Bot"];
        //$this->sort_order = SORT_DESC;
        //$this->sort_key = 1;

        if (isset($this->country_list)) {
            $this->addlabel .= $this->country_list;
        }
        $this->help = _ADWORDS_CLICKS_DESC . "<br><br>" . _ADWORDS_CLICKS_PER_DAY_DESC;
    }

    function DefineQuery()
    {
        global $db;


        $tablename = $this->profile->tablename_merge;

        $subquery = "select visitorid,count(*) as hits, count(distinct sessionid) as visits, (count(*)/count(distinct sessionid)) as cpv, country, (MAX(timestamp)-MIN(timestamp)) as dur, a.crawl as bot from {$tablename} as a, {$this->profile->tablename_urlparams} as u where timestamp >= " . $db->quote(
                $this->from
            ) . " and timestamp <= " . $db->quote(
                $this->to
            ) . " and a.params=u.id and (u.params like '?gclid=%' or u.params like '%&gclid=%') group by visitorid, a.country, a.crawl order by hits desc limit {$this->limit}";
        $subquery = subsetDataToSourceID($subquery, $this->trafficsource);
        $this->applytrafficsource = false;
        $query = "SELECT concat(v.ipnumber,'##',v.visitorid,'##',v.customlabel), hits, visits, cpv, country, dur, bot FROM ({$subquery}) as a, {$this->profile->tablename_visitorids} as v where a.visitorid=v.id ";


        return $query;
    }

    function GetReportData()
    {
        $data = parent::GetReportData();
        //dump($data);
        foreach ($data as $d => $v) {
            //$data[$d][5] = $this->sec2time($v[5]);
            $data[$d][5] = $this->sec2time($v[5]);
        }
        return $data;
    }

    function DisplayReport()
    {
        //dump($this);
        parent::DisplayReport();
    }

    function UpdateStats($from = '', $to = '', $print = 2)
    {
        # not important enough
        return false;
    }
}


