<?php

/**
 * @desc This report displays a visitors per day table
 */
if (!defined('APP_INCLUDE')) {
    die('invalid inclusion');
}

class TwitterCore extends Report
{

    function Settings()
    {
        $this->IgnReIm = 1; # Never ever ask for reimport data
        if (isset($this->account)) {
            $this->fileNameExpension = "." . $this->account;
            $this->addlabel = $this->account;
        }
    }

    function DefineReport()
    {
        if (isset($_REQUEST["rem"])) {
            $this->remAccount($_REQUEST["rem"]);
        }

        if (isset($_REQUEST["accountName"])) {
            $this->addAccount($_REQUEST["accountName"]);
        }

        echo "<div class='col-sm-6'>";
        $this->addForm();
        echo "</div>";

        echo "<div class='col-sm-6'>";
        $this->remForm();
        echo "</div>";
        echo "<div style='clear:both;'></div>";
    }

    function remAccount($num)
    {
        $accs = $this->getAcounts();
        echoWarning("Removed " . $accs[$num]);
        unset($accs[$num]);
        $this->profile->SetOtherSettings("twitterAccounts", json_encode($accs));
    }

    function getAcounts()
    {
        $accounts = $this->profile->GetOtherSettings("twitterAccounts", false);
        if ($accounts != false) {
            $accounts = json_decode($accounts, true);
        }
        return $accounts;
    }

    function addAccount($account)
    {
        if (!$this->checkDoubleAccounts($account)) {
            $accs = $this->getAcounts();
            if ($accs == false) {
                $accs[] = $account;
            } else {
                array_push($accs, $account);
            }
            $this->profile->SetOtherSettings("twitterAccounts", json_encode($accs));
            echoNotice("Account saved");
        } else {
            echoWarning(_ACCOUNT_STORED);
        }
    }

    function checkDoubleAccounts($account)
    {
        $accs = $this->getAcounts();
        if (!empty($accs)) {
            foreach ($accs as $k => $v) {
                if ($v == $account) {
                    return true;
                }
            }
        }
        return false;
    }

    function addForm()
    {
        if (isset($_REQUEST["accountName"])) {
            $val = $_REQUEST["accountName"];
        } else {
            $val = "";
        }


        echo "<form method='POST' action='definereport.php'>";
        echo "<div class='form-group'>";
        echo "<label>" . _ADD_NEW_ACCOUNT . "</label>";
        echo "<input class='form-control twitterAccountName' type='text' name='accountName' value='$val' />";
        echo "</div>";
        echo "<div class='form-group'>";
        echo "<input type='hidden' name='conf' value='{$this->conf}' />";
        echo "<input type='hidden' name='labels' value='{$this->label_constant}' />";
        echo "<input type='hidden' name='action' value='start' />";
        echo "<button class='form-control btn btn-primary add_twitter_button' data-loading-text='Adding account, please wait ..'>" . _ADD_NEW_ACCOUNT . "</button>";
        echo "</div>";
        echo "</form>";
        ?>
        <script>
            $(".add_twitter_button").on("click", function () {
                const btn = $(this);
                btn.button('loading');
            });
        </script>
        <?php
    }

    function remForm()
    {
        $url = "definereport.php?conf={$this->conf}&labels={$this->label_constant}&action=start&nohtml=1";

        $accs = $this->getAcounts();
        if (!$accs) {
            #leave empty
        } else {
            echo "<div class='form-group'>";
            echo "<label>Twitter Accounts (click to remove)</label>";

            echo "<div class='twitter-remove-list'><ul>";
            foreach ($accs as $k => $v) {
                echo "<li class='bg-success'>$v <a class='remove_twitter_button' href='{$url}&action=remform&rem=$k' data-loading-text=' Removing, please wait...'><i class='fa fa-times'></i></a></li>";
            }
            echo "</div></ul>";
            echo "</div>";
            ?>
            <script>
                $(".remove_twitter_button").on("click", function () {
                    const btn = $(this);
                    btn.button('loading');
                });
            </script>
            <?php
        }
    }

    function GetDataFromDb()
    {
        # if no account is set return false
        if (empty($this->account)) {
            return [];
        }

        $data = [];
        $result = $this->TwitterCall("stats", $this->account);
        if (isset($result['error'])) {
            echoWarning("Twitter responded with an error: " . $result['error']);
            return;
        }
        $data[0][0] = date("d-M-Y D");
        $data[0][1] = $result[0]['user']['followers_count'];
        $data[0][2] = $result[0]['user']['friends_count'];
        $data[0][3] = $result[0]['user']['statuses_count'];
        return $data;
    }

    function TwitterCall($request, $q, $q2 = "")
    {
        $twitter = file_get_contents("https://software.logaholic.com/twitter/?request={$request}&q={$q}&q2={$q2}");
        return json_decode($twitter, true);
    }

    # Select/Add/Remove twitter account

    function DisplayCustomForm()
    {
        global $session;
        $accounts = $this->getAcounts();

        echo "<div class='form-group'>";

        if (!$accounts) {
            echo _NO_TWITTER_FOUND;
        } else {
            echo "<label>" . _PLEASE_SELECT_TWITTER_ACCOUNT . "</label>";
            echo "<select id='account' class='report_option_field form-control'>";
            foreach ($accounts as $k => $v) {
                echo "<option value='$v'>$v</option>";
            }
            echo "</select>";
        }
        echo "</div>";

        if ($session->canEditProfiles()) {
            echo "<div class='form-group'><a data-title='" . _ADD_REMOVE_TWITTER . "' href='definereport.php?conf={$this->conf}&labels={$this->label_constant}&action=start' class='btn btn-primary open_iframe_window'>" . _ADD_REMOVE_TWITTER_LINK . "</a></div>";
        }
    }

    function DisplayReport()
    {
        if (empty($this->account)) {
            echoNotice($this->SettingsButton() . _PLEASE_SELECT_TWITTER_ACCOUNT);
            return false;
        }
        parent::DisplayReport();
    }

    function UpdateStats($from = '', $to = '', $print = 2)
    {
        if (empty($from)) {
            $from = $this->from;
        }
        if (empty($to)) {
            $to = $this->to;
        }


        $accounts = $this->getAcounts();
        if (!$accounts) {
            return false;
        }

        foreach ($accounts as $k => $v) {
            $this->account = $v;
            $this->fileNameExpension = "." . $this->account;
            $this->createDataFiles(
                mktime(0, 0, 0, date('m', $from), date('d', $from), date('Y', $from)),
                mktime(23, 59, 59, date("m", $to), date("d", $to), date("Y", $to)),
                $print
            );
        }

        return false;
    }
}

?>
