<?php

if (!isset($_SERVER['HTTP_X_REQUESTED_WITH']) || ($_SERVER['HTTP_X_REQUESTED_WITH'] !== 'XMLHttpRequest')) {
    die("Ajax only");
}

if (!empty($_POST["q"])) {
    include_once("../common.inc.php");

    $skipips = trim($_POST["q"]);

    # Check if there is a star at the start of the regex
    if (substr($skipips, 0, 1) == "*") {
        $skipips = "." . $skipips;
    }

    # Create the regex needed to skip ips.
    $regex_skipips = preg_replace("/\r\n|\r|\n/", ",", $skipips);    # remove line breaks
    $regex_skipips = preg_replace("/,,|,/", "|", $regex_skipips);    # remove comma's

    # Test if the regex is invalid
    if (@preg_match("/({$regex_skipips})/i", null) === false) {
        echoWarning(_SKIP_IP_NUMBERS . ": Error - " . $errorHandler->error_msg);
    } else {
        echo 1;
    }
}
