<?php

require_once '../../AccessControl.php';

# check if subscription component is being used by checking if the table exists.
$r = $db->execute("SHOW TABLES LIKE '" . TBL_SUBSCRIPTIONS . "';");
if ($r->RecordCount() == 1) {
    $results = $db->Execute("SELECT * FROM " . TBL_SUBSCRIPTIONS);
}
$subscriptions = [];
if ($results != false) {
    while ($row = $results->fetchRow()) {
        $vals = json_decode($row["value"], true);

        $subscriptions[$row["id"]]['name'] = $row["name"];
        $subscriptions[$row["id"]]['price'] = 0;
        if (!empty($vals["Price"])) {
            $subscriptions[$row["id"]]['price'] = $vals["Price"]['value'];
        }
    }
}

?>
<div class="response">
    <div class="callout-danger-template callout callout-danger" style="display:none;">
        <h4></h4>
    </div>
    <div class="callout-success-template callout callout-success" style="display:none;">
        <h4></h4>
    </div>
</div>


<div id="the_grid">
    <!-- Main row -->
    <div class="row">
        <section id="userSettings" class="col-sm-7 formarea">
            <div class="box box-solid box-primary">
                <div class="box-header">
                    <h3 class="box-title"><?php
                        echo _CREATE_NEW_USER; ?></h3>

                </div><!-- /.box-header -->

                <div class="box-body">
                    <form id="userForm" style="display:none;">

                        <div class="form-group" data-help="<?php
                        echo _LOGIN_USERNAME_EXPLAIN; ?><br/><a href='#'><?php
                        echo _LOGIN; ?></a>">
                            <label><?php
                                echo _LOGIN_USERNAME; ?></label>
                            <input class="form-control" size="40" type="text" name="username"/>
                            <input class="form-control" size="40" type="hidden" name="userid"/>
                        </div>

                        <div class="form-group" data-help="<?php
                        echo _NAME_EXPLAIN; ?>">
                            <label><?php
                                echo _NAME; ?></label>
                            <input class="form-control" size="40" type="text" name="name"/>
                        </div>

                        <div class="form-group" data-help="<?php
                        echo _PASSWORD_EXPLAIN; ?><br/>- <?php
                        echo _PASSWORD_ENCRYPTION; ?>">
                            <label><?php
                                echo _PASSWORD; ?></label>
                            <input class="form-control" size="40" type="text" name="password" value=""/>
                        </div>

                        <div class="form-group" data-help="<?php
                        echo _EMAIL_ADDRESS_EXPLAIN; ?>">
                            <label><?php
                                echo _EMAIL_ADDRESS; ?></label>
                            <input class="form-control" size="25" maxlength="51" type="text" name="email"/>
                        </div>

                        <div class="form-group" data-help="<?php
                        echo _ENABLED_EXPLAIN; ?>">
                            <label><?php
                                echo _ENABLED; ?></label>
                            <select class="form-control" name="active">
                                <option value="1"><?php
                                    echo _ENABLE; ?></option>
                                <option value="0"><?php
                                    echo _DISABLE; ?></option>
                            </select>
                        </div>

                        <div class="form-group" data-help="<?php
                        echo _ACCOUNT_CREATED_DATE_EXPLAIN; ?>" style="display:none;">
                            <label><?php
                                echo _ACCOUNT_CREATED_DATE; ?></label>
                            <div class="input-group">
                                <div class="input-group-addon">
                                    <i class="fa fa-calendar"></i>
                                </div>
                                <input class="form-control" size="40" type="text" name="created"
                                       placeholder="mm/dd/yyyy" data-inputmask="'alias': 'mm/dd/yyyy'" data-mask/>
                            </div>
                        </div>

                        <div class="form-group" data-help="<?php
                        echo _EXPIRE_DATE_EXPLAIN; ?>">
                            <label><?php
                                echo _EXPIRE_DATE; ?></label>
                            <div class="input-group">
                                <div class="input-group-addon">
                                    <i class="fa fa-calendar"></i>
                                </div>
                                <input class="form-control" size="40" type="text" name="expires"
                                       placeholder="mm/dd/yyyy" data-inputmask="'alias': 'mm/dd/yyyy'" data-mask/>
                            </div>
                        </div>

                        <?php
                        # check if there actually are subscriptions in the table. If so then add the subscription option to the form.

                        if (!empty($subscriptions)) {
                            echo "<div class='form-group' data-help='" . _SUBSCRIPTION_EXPLAIN . "' >";
                            echo "<label>" . _SUBSCRIPTION . "</label>";
                            # add dropdown option for selecting a subscription.
                            echo "<select class=\"form-control\"  name='userSubscription'>";
                            echo "<option value=''>-----" . _NONE . "-----</option>";
                            foreach ($subscriptions as $subid => $sub) {
                                $selected = "";
                                if ($session->userinfo["subscriptionid"] == $subid) {
                                    $selected = "selected='selected'";
                                }
                                echo "<option $selected value='{$subid}'>{$sub['name']}</option>";
                            }
                            echo "</select>";
                            echo "</div>";
                        }
                        ?>
                        <div class="form-group" data-help="<?php
                        echo _PROFILE_LIMIT_HELP; ?>">
                            <label><?php
                                echo _PROFILE_LIMIT . " (0 - " . _LIMIT_PROFILES . " )"; ?></label>
                            <input class="form-control" size="40" type="text" name="profileLimit"/>
                        </div>

                        <!-- PROFILES LIKE TAGS! -->
                        <div class="form-group">
                            <label><?php
                                echo _PROFILES; ?></label>
                            <div class="profiles-box">
                                <ul class="profiles-list">
                                    <li class="input"><input type="text" value="" name="user-search-profile"
                                                             class="search" placeholder="<?php
                                        echo _TYPE_TO_ADD_PROFILE; ?>."></li>
                                </ul>
                                <div style="clear:both; height: 1px;">&nbsp;</div>
                            </div>

                        </div>


                        <div class="form-group">
                            <label><?php
                                echo _PERMISSIONS; ?></label>
                            <div class="permissions-box">
                                <div class="checkbox" data-help="<?php
                                echo _IS_ADMINISTRATOR_EXPLAIN; ?>">
                                    <label><input value="1" type="checkbox" name="isAdmin"><?php
                                        echo _IS_ADMINISTRATOR; ?></label>
                                </div>

                                <div class="checkbox" data-help="<?php
                                echo _CAN_UPDATE_LOGS_EXPLAIN; ?>">
                                    <label><input value="1" type="checkbox" name="accessUpdateLogs"><?php
                                        echo _CAN_UPDATE_LOGS; ?></label>
                                </div>

                                <div class="checkbox" data-help="<?php
                                echo _CAN_ADD_PROFILES; ?>">
                                    <label><input value="1" type="checkbox" name="accessAddProfile"><?php
                                        echo _CAN_ADD_PROFILES; ?></label>
                                </div>

                                <div class="checkbox" data-help="<?php
                                echo _CAN_EDIT_PROFILES_EXPLAIN; ?>">
                                    <label><input value="1" type="checkbox" name="accessEditProfile"><?php
                                        echo _CAN_EDIT_PROFILES; ?></label>
                                </div>

                                <div class="checkbox"
                                     data-help="This will hide advanced profile settings when editing profiles<?php
                                     echo _CAN_EDIT_BASIC_PROFILE_EXPLAIN; ?>">
                                    <label><input value="1" type="checkbox" name="accessBasicEditProfile"><?php
                                        echo _CAN_EDIT_BASIC_PROFILE; ?></label>
                                </div>

                                <div class="checkbox" data-help="<?php
                                echo _CAN_CHANGE_ACCOUNT_INFO_EXPLAIN; ?>">
                                    <label><input value="1" type="checkbox" name="changeAccountInfo"><?php
                                        echo _CAN_CHANGE_ACCOUNT_INFO; ?></label>
                                </div>
                                <div class="checkbox" data-help="<?php
                                echo _CAN_VIEW_ALL_PROFILES_EXPLAIN; ?>">
                                    <label><input value="1" type="checkbox" name="canViewAllProfiles"><?php
                                        echo _CAN_VIEW_ALL_PROFILES; ?></label>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label><?php
                                echo _DATA_COLLECTION_METHOD; ?></label>
                            <div class="permissions-box">
                                <div class="checkbox">
                                    <label><input value="1" type="checkbox" name="trackermode_0"><?php
                                        echo _LOG_ANALYSIS_LOCAL; ?></label>
                                </div>
                                <div class="checkbox">
                                    <label><input value="1" type="checkbox" name="trackermode_1"><?php
                                        echo _JS_BASED_TRACKING; ?></label>
                                </div>
                                <div class="checkbox">
                                    <label><input value="1" type="checkbox" name="trackermode_2"><?php
                                        echo _LOG_ANALYSIS_FTP; ?></label>
                                </div>
                                <div class="checkbox">
                                    <label><input value="1" type="checkbox" name="trackermode_3"><?php
                                        echo _UPLOAD_FILES; ?></label>
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <button class="btn btn-primary save-user"><?php
                                echo _SAVE; ?></button>
                        </div>
                    </form>
                </div>
            </div>
        </section>
        <section class="col-sm-5">

            <div class="box box-solid box-success license_info" style="display:none;">
                <div class="box-header">
                    <h3 class="box-title"><i class="fa fa-user">&nbsp;</i> <span>Logaholic Pro Account</span></h3>
                </div>
                <div class="box-body">

                    <div class="subscribed" style="display:none;">
                        <p>
                            You are subscribed to : <span class="planname"><i class="fa fa-spinner fa-spin"> </i></span>
                        </p>

                        <div class="billing_info">
                            <h5>Billing info:</h5>
                            <div><label>Name:</label><span class="billing_name"></span></div>
                            <div><label>Email:</label><span class="billing_email"></span></div>
                            <div><label>Address:</label><span class="billing_address"></span></div>
                            <div><label>Payment:</label><span class="billing_cc"></span></div>
                            <div><label>Subscription started:</label><span class="billing_started"></span></div>
                            <div><label>End of current period:</label><span class="billing_current_period_end"></span>
                            </div>
                            <div><label>Usage:</label><span class="billing_pageviews"></span></div>
                        </div>
                        <div style="text-align:center;" class="cancel-but">
                            <a href="#" onclick="ui.PlanChange()" class="btn btn-sm btn-success">Upgrade</a>
                            <a href="#" onclick="ui.CancelPro()" class="btn btn-sm btn-danger">Cancel</a>
                        </div>
                    </div>

                    <div style="text-align:center;" class="upgrade-but">
                        <a href="#" onclick="ui.LicenseUpgrade()" class="btn btn-success">Upgrade to Logaholic Pro</a>
                    </div>

                </div>
                <div class="box-footer"></div>
            </div>

            <div class="box box-solid box-warning helptxt" style="min-height:250px">
                <div class="box-header">
                    <h3 class="box-title"><i class="fa fa-info-circle">&nbsp;</i> <span><?php
                            echo _HELP; ?></span></h3>

                </div>
                <div class="box-body"></div>
            </div>


        </section>
    </div>
</div>

                     