<?php

/**
 * @desc This report displays the days of the week
 */
$reports["_TOP_DAYS"] = [
    "ClassName" => "TopDays",
    "Category" => "_VISITOR_TRENDS",
    "icon" => "images/icons/32x32/daysoftheweek.png",
    "Options" => "daterangeField,profileselector,displaymode,trafficsource,columnSelector,human",
    "Filename" => "top_days",
    "Distribution" => "Standard",
    "Order" => 8,
    "ReportVersion" => 1.0,
    "MinimumVersion" => 3.0,
    "EmailAlerts" => true
];

class TopDays extends Report
{

    function Settings()
    {
        $this->DefaultDisplay = "barchart";
        $this->DisplayModes = "table,pie,barchart";
        $this->allowDateFormat = false;
        $this->sort_order = SORT_ASC;
        $this->sort_key = 3;
        $this->columnDefinitions[] = ["Label" => "_DAY"];
        $this->columnDefinitions[] = ["Label" => "_VISITS"];
        $this->columnDefinitions[] = ["Label" => "_PAGEVIEWS"];
        # Define this column because we want to sort on this , but it should not sum the number...
        $this->columnDefinitions[] = [
            "Label" => "Day Number",
            "dataType" => "String",
            "display" => true,
            "show_line" => false
        ];

        $this->help = _DEFINITIONS_FOR_THIS_REPORT . ':<ul>' . '<li>' . _VISITS_DEFINITION . '<li>' . _PAGEVIEWS_DEFINITION . '</ul><div class=\'indentbody\'>' . _MAKE_SURE_DATE_RANGE . '</div>';
    }

    function GetReportData()
    {
        $data = parent::GetReportData();
        # remove the sorting number from the column definitions because the sorting has now been done in the parent.
        //unset($this->columnDefinitions[3]);
        for ($i = 0; $i < count($data); $i++) {
            $data[$i][0] = LogaDate(["format1" => "l"], $data[$i][0], "STRING");
            # remove the sorting number from the array
            //unset($data[$i][3]);
        }
        return $data;
    }

    function DefineQuery()
    {
        global $db;

        if (isset($this->human) && $this->human == 1) {
            $tablename = $this->profile->tablename_merge;
        } else {
            $tablename = $this->profile->tablename;
        }

        $query = "SELECT FROM_UNIXTIME(timestamp,'%W') AS days, COUNT(distinct sessionid), COUNT(*) AS hits, FROM_UNIXTIME(timestamp,'%w') AS daynum FROM {$tablename} WHERE timestamp >= " . $db->quote(
                $this->from
            ) . " and timestamp <= " . $db->quote(
                $this->to
            ) . " GROUP BY days, timestamp ORDER BY FROM_UNIXTIME(timestamp, '%w')";

        return $query;
    }
}


