<?php

/**
 * @desc Definitions for this report: Visitors per Day
 *
 * Visitors: Unique Visitors that accessed your site (excluding any bots and crawlers).
 * Pageviews: The total number of pages requested (excluding any bots and crawlers).
 * Average Pages per user: The total number of pages devided by the number of visitors.
 */
$reports["_NEW_VS_RETURNING"] = [
    "ClassName" => "NewVsReturning",
    "Category" => "_VISITOR_TRENDS",
    "icon" => "images/icons/32x32/visitorsperday.png",
    "Options" => "daterangeField,profileselector,columnSelector,trafficsource,displaymode",
    "Filename" => "new_vs_returning",
    "Distribution" => "Premium",
    "Order" => 6,
    "ReportVersion" => 1.0,
    "MinimumVersion" => 3.0,
    "EmailAlerts" => false,
    "Update" => false
];

class NewVsReturning extends Report
{

    function Settings()
    {
        $this->DefaultDisplay = "barchart";
        $this->DisplayModes = "table,linechart,barchart";
        //$this->allowDateFormat = false;
        $this->columnDefinitions[] = ["Label" => "_DATE"];
        $this->columnDefinitions[] = ["Label" => "_NEW"];
        $this->columnDefinitions[] = ["Label" => "_RETURNING"];
        $this->stacked = true;

        $this->sort = false;
        $this->key_col = 0;

        $range = $this->to - $this->from;

        $this->help = _DEFINITIONS_FOR_THIS_REPORT . ":<br/>" . _NEW_VS_RETURNING_DESC;

        // if($this->period == "months") {
        // 	$this->allowDateFormat = false;
        // 	$this->dataCollectType = "months";
        // } else {
        // 	$this->dataCollectType = "days";
        // }

    }

    function DisplayCustomForm()
    {
        echo "<div class='form-group'>";
        echo "<label for='period'>" . _PERIOD . ":</label>";
        if ($this->period == 'days') {
            $sel = "selected='selected'";
        } else {
            $sel = "";
        }
        echo "<select name='period' id='period' class='report_option_field form-control'><option $sel value='days'>" . _DAYS . "</option>";
        if ($this->period == 'months') {
            $sel = "selected='selected'";
        } else {
            $sel = "";
        }
        echo "<option $sel value='months'>" . _MONTHS . "</option></select>";
        echo "</div>";
    }

    function GetDataFromDb()
    {
        global $db, $reports, $session;

        $data = [];

        $range = $this->to - $this->from;

        //if($range <= 86400) {
        # first get total number of visitors to page
        $vpd = new $reports["_VISITORS_PER_DAY"]["ClassName"]();
        $vpd->regenerateDatafiles = false;
        $vpd->label = _VISITORS_PER_DAY;
        $vpd->from = $this->from;
        $vpd->to = $this->to;
        $total_visitors = $vpd->GetReportData();
        //} else {
        # first get total number of visitors to page
        // $vpm = new $reports["_VISITORS_PER_MONTH"]["ClassName"]();
        // $vpm->regenerateDatafiles = false;
        // $vpm->label = _VISITORS_PER_MONTH;
        // $vpm->from = $this->from;
        // $vpm->to = $this->to;
        // $total_visitors = $vpm->GetReportData();
        //}

        # New Visitors
        $query = "select count(distinct v.id) as nv from {$this->profile->tablename_visitorids} v, {$this->profile->tablename} as a where created >=" . $db->quote(
                $this->from
            ) . " and created <=" . $db->quote($this->to) . " and v.id=a.visitorid";

        $query = subsetDataToSourceID($query, $this->trafficsource);
        $result = $db->Execute($query);

        $i = 0;

        while ($new_visitors = $result->FetchRow()) {
            $new_visitors = $new_visitors[0];
            $total_visitors[$i] = (isset($total_visitors[$i])) ? $total_visitors[$i] : [1 => 0];

            $new_percentage = 0;
            if (!$total_visitors[$i][1] == 0) {
                $new_percentage = intval(($new_visitors / $total_visitors[$i][1]) * 100);
            }

            if ($new_percentage > 100) {
                $new_percentage = 100;
            }
            $return_percentage = 100 - $new_percentage;
            if ($return_percentage < 0) {
                $return_percentage = 0;
            }

            if ($range <= 86400) {
                $data[$i][0] = date(implode($this->profile->dateFormat), $this->to);
            } else {
                $data[$i][0] = date("F Y", $this->to);
            }
            $data[$i][1] = $new_percentage;
            $data[$i][2] = $return_percentage;

            $i++;
        }

        return $data;
    }

    function GetReportData()
    {
        global $db, $get_constant;
        $this->createDataFiles($this->from, $this->to);
        $d = $this->getDataFromFiles($this->dataFiles($this->from, $this->to));
        $data = [];

        if ($this->displaymode == "table") {
            $i = 0;
            foreach ($d as $k => $val) {
                $data[$i][0] = $val[0];
                $data[$i][1] = $val[1] . "%";
                $data[$i][2] = $val[2] . "%";

                $i++;
            }
        } else {
            $data = $d;
        }

        return $data;
    }

    function UpdateStats($from = '', $to = '', $print = 2)
    {
        return false;
    }
}

