<?php

/**
 * @desc This report displays the error report
 */
$reports["_DETAILED_ERROR_REPORT"] = [
    "ClassName" => "DetailedErrorReport",
    "Category" => "_PROBLEMS",
    "icon" => "images/icons/32x32/errorreport.png",
    "Options" => "daterangeField,profileselector,displaymode,trafficsource,search,limit,columnSelector",
    "Filename" => "detailed_error_report",
    "Distribution" => "Premium",
    "Order" => 9,
    "hidden" => 1
];

class DetailedErrorReport extends Report
{

    function Settings()
    {
        $this->DefaultDisplay = "table";
        $this->DisplayModes = "table,pie";

        if (!isset($this->status)) {
            $this->status = "404 - Not Found";
        }

        $this->addlabel .= _ERROR_CODE . ": " . $this->status;

        $this->status = explode(" ", $this->status);
        $this->status = $this->status[0];

        $this->columnDefinitions[] = ["Label" => "_PAGE", "actionmenu" => 'page'];
        $this->columnDefinitions[] = ["Label" => "_VIEWED_PAGES"];
        $this->columnDefinitions[] = ["Label" => "_CRAWLED_PAGES"];
        $this->columnDefinitions[] = ["Label" => "_TOTAL_HITS"];
        $this->columnDefinitions[] = ["Label" => "_STATUS", "dataType" => "String", "hide_column" => true];
        $this->fileNameExpension .= "." . $this->status;
        $this->actionmenu_type = 'status';
        $this->sort_order = SORT_DESC;
        $this->sort_key = 1;
    }

    function DefineQuery()
    {
        global $db;
        $query = "select u.url,(COUNT(*) - SUM(IF(crawl='0','0',1))) AS viewed, SUM(IF(crawl='0','0',1)) as crawled,count(*),status from " . $this->profile->tablename_merge . " as a, {$this->profile->tablename_urls} as u where status!=200 and status=" . $db->quote(
                $this->status
            ) . " and timestamp >=" . $db->quote($this->from) . " and timestamp <=" . $db->quote(
                $this->to
            ) . " and a.url=u.id group by a.url,status order by viewed desc";

        return $query;
    }

    function DisplayCustomForm()
    {
        echo "<div class='form-group'>";
        echo "<label for='status'>" . _ERROR_CODE . ": </label>";
        echo "<input class='report_option_field form-control' type='text' title='i.e. 200, 302' id='status' name='status' value='" . @$this->status . "'>";
        echo "</div>";
    }
}


