<?php

/**
 * @desc This report displays the browser breakdown
 */
$reports["_BROWSER_BREAKDOWN"] = [
    "ClassName" => "BrowserBreakdown",
    "Category" => "_CLIENT_SYSTEM",
    "icon" => "images/icons/32x32/browser_breakdown.png",
    "Options" => "daterangeField,profileselector,trafficsource",
    "Filename" => "browser_breakdown",
    "Distribution" => "Premium",
    "Order" => 2,
    "ReportVersion" => 1.0,
    "MinimumVersion" => 3.0,
    "EmailAlerts" => false,
    "Update" => false,
    "canAggregate" => false
];

class BrowserBreakdown extends Report
{

    function Settings()
    {
        $this->remove_outputmodes = ["xml", "mail", "csv"];
        //$this->columnDefinitions[] = array("Label" => "_BROWSER");
        $this->columnDefinitions[] = ["Label" => "_BROWSER_VERSION", "dataType" => "String"];
        $this->columnDefinitions[] = ["Label" => "_VISITS"];
        $this->limit = 10000; # equals 10 per type
        $this->HighlightFormatString = '<table class="jqplot-highlighter" style="color: #333;"><tr><td>' . _BROWSER . ':</td><td>%s</td></tr><tr><td>' . _VISITS . ':</td><td>%s</td></tr><tr><td></td><td>%s</td></tr></table>';

        if (!isset($this->limit)) {
            $this->limit = 10;
        }
        $this->report_limit = $this->limit;
        $this->sunburstcolors = ["d3cat" => "d3.scale.category10().range()"];
    }

    function ConvertData($d)
    {
        $newLimit = $this->limit / 1000;
        $data = [];
        $ie = 1;
        $ff = 1;
        $o = 1;
        $c = 1;
        foreach ($d as $k => $v) {
            if ($v[0] == "Internet Explorer" || $v[0] == "IE") {
                $key = 0;
                $i = $ie;
            } else {
                if ($v[0] == "Firefox") {
                    $key = 1;
                    $i = $ff;
                } else {
                    if (stripos($v[0], "Chrome") !== false) {
                        $key = 2;
                        $i = $c;
                    } else {
                        $key = 3;
                        $i = $o;
                    }
                }
            }

            if ($i > $newLimit) {
                continue;
            }

            $data[$key][$i][0] = $v[0] . " " . $v[1];
            $data[$key][$i][1] = $v[2];

            if ($v[0] == "Internet Explorer" || $v[0] == "IE") {
                $ie++;
            } else {
                if ($v[0] == "Firefox") {
                    $ff++;
                } else {
                    if (stripos($v[0], "Chrome") !== false) {
                        $c++;
                    } else {
                        $o++;
                    }
                }
            }
            if (($o > $newLimit) && ($ff > $newLimit) && ($ie > $newLimit)) {
                $this->limit = $newLimit;
                break;
            }
        }
        return $data;
    }

    function DisplayReport()
    {
        global $db;
        $data = $this->GetReportData();
        if (empty($data)) {
            # this means no data
            $this->ReportHeader();
            echoNotice(_NO_DATA_TO_DISPLAY, "margin:10px;");
            return false;
        }

        $this->ReportHeader();
        //dump($data);

        $this->collapsekeys = [0, 1];
        $this->sumkeys = [2];
        $this->Sunburst($data);

        // $data = $this->ConvertData($data);
        // $this->CreateDonut($data);
        echo "<div style='clear:both'>&nbsp;</div>";
    }

    function GetReportData()
    {
        global $reports;
        $r = new $reports["_BROWSER_VERSIONS"]["ClassName"]();
        $r->sort_order = SORT_DESC;
        $r->sort_key = 2;
        $r->key_col = 4;
        $r->limit = 10000; # equals 10 per type
        $data = $r->GetReportData();
        return $data;
    }

    function CreateDonut($data)
    {
        $i = ["IE", "Firefox", "Chrome", "Other"];
        ksort($data);

        $totals = [];
        $alldata = [];
        $total = 0;
        foreach ($data as $b => $entry) {
            $totals[$i[$b]] = 0;

            foreach ($entry as $k => $v) {
                $totals[$i[$b]] = $totals[$i[$b]] + $v[1];
                $alldata[$v[0]] = $v[1];
                $total = $total + $v[1];
            }
        }

        $innerRing = [];
        $outerRing = [];
        foreach ($totals as $k => $v) {
            $p = round(($v / $total) * 100);
            $innerRing[] = "['$k',$v,'$p%']";
            $innerLabels[] = "'$k $p%'";
        }
        $i = 0;

        $iecolors = [
            "'rgba(247,143,106,1)'"
        ,
            "'rgba(241, 126, 83,1)'"
        ,
            "'rgba(241, 156, 125,1)'"
        ,
            "'rgba(241, 83, 83,1)'"
        ,
            "'rgba(241, 125, 125,1)'"
        ,
            "'rgba(226, 82, 29,1)'"
        ,
            "'rgba(226, 82, 29,1)'"
        ,
            "'rgba(226, 29, 29,1)'"
        ,
            "'rgba(147, 47, 9,1)'"
        ,
            "'rgba(147, 9, 9,1)'"
        ];

        $ffcolors = [
            "'rgba(179, 222, 137,1)'"
        ,
            "'rgba(163, 222, 106,1)'"
        ,
            "'rgba(177, 222, 137,1)'"
        ,
            "'rgba(130, 211, 135,1)'"
        ,
            "'rgba(100, 211, 108,1)'"
        ,
            "'rgba(160, 222, 106,1)'"
        ,
            "'rgba(50, 166, 58,1)'"
        ,
            "'rgba(119, 189, 57,1)'"
        ,
            "'rgba(45, 151, 91,1)'"
        ,
            "'rgba(68, 123, 19,1)'"
        ];


        $crcolors = [
            "'rgba(131, 238, 243,1)'"
        ,
            "'rgba(90, 237, 243,1)'"
        ,
            "'rgba(135, 214, 244,1)'"
        ,
            "'rgba(139, 193, 245,1)'"
        ,
            "'rgba(96, 203, 244,1)'"
        ,
            "'rgba(101, 174, 245,1)'"
        ,
            "'rgba(44, 181, 233,1)'"
        ,
            "'rgba(51, 144, 234,1)'"
        ,
            "'rgba(14, 114, 151,1)'"
        ,
            "'rgba(16, 86, 152,1)'"
        ];

        $otcolors = [
            "'rgba(247, 212, 116,1)'"
        ,
            "'rgba(242, 203, 96,1)'"
        ,
            "'rgba(229, 184, 59,1)'"
        ,
            "'rgba(219, 169, 21,1)'"
        ,
            "'rgba(216, 169, 39,1)'"
        ,
            "'rgba(206, 159, 28,1)'"
        ,
            "'rgba(201, 153, 22,1)'"
        ,
            "'rgba(191, 144, 15,1)'"
        ,
            "'rgba(178, 132, 7,1)'"
        ,
            "'rgba(160, 118, 1,1)'"
        ];

        $c1 = 0;
        $c2 = 0;
        $c3 = 0;
        $c4 = 0;

        if (empty($alldata)) {
            # this means no data
            $this->ReportHeader();
            echoNotice(_NO_DATA_TO_DISPLAY, "margin:10px;");
            return false;
        }

        $legends = [
            "IE" => [],
            "FF" => [],
            "CR" => [],
            "OT" => []
        ];

        foreach ($alldata as $k => $v) {
            $p = "";
            $legendKey = "";

            if (((strpos($k, "IE") !== false) || (strpos($k, "Internet Explorer") !== false) && $c1 < 10)) {
                $p = round(($v / $totals["IE"]) * 100);
                $outerColors[] = $iecolors[$c1];
                $c1++;
                $legendKey = "IE";
            } else {
                if (strpos($k, "Firefox") !== false && $c2 < 10) {
                    $p = round(($v / $totals["Firefox"]) * 100);
                    $outerColors[] = $ffcolors[$c2];
                    $c2++;
                    $legendKey = "FF";
                } else {
                    if (strpos($k, "Chrome") !== false && $c3 < 10) {
                        $p = round(($v / $totals["Chrome"]) * 100);
                        $outerColors[] = $crcolors[$c3];
                        $c3++;
                        $legendKey = "CR";
                    } else {
                        if ($c4 < 10) {
                            $p = round(($v / $totals["Other"]) * 100);
                            $outerColors[] = $otcolors[$c4];
                            $c4++;
                            $legendKey = "OT";
                        }
                    }
                }
            }
            $outerRing[] = "['$k',$v,'$p%']";
            $outerLabels[] = "'$k $p%'";

            if (strlen($k) > 15) {
                $view = substr($k, 0, 15) . "...";
            } else {
                $view = $k;
            }

            $legends[$legendKey][] = "'<span style=\"float:left;\">$view</span> <span style=\"float:right;\">  $p%</span>'";
        }

        $this->outerColors = implode(",", $outerColors);
        $this->DonutGraph($innerRing, $outerRing, $innerLabels, $outerLabels);
        $colors = [];
        foreach ($outerColors as $k => $v) {
            if ($k >= (count($legends["IE"]) + count($legends["FF"]) + count($legends["CR"]))) {
                $colors[3][] = str_replace("'", "", $v);
            } else {
                if ($k >= count($legends["IE"]) + count($legends["FF"])) {
                    $colors[2][] = str_replace("'", "", $v);
                } else {
                    if ($k >= count($legends["IE"])) {
                        $colors[1][] = str_replace("'", "", $v);
                    } else {
                        $colors[0][] = str_replace("'", "", $v);
                    }
                }
            }
        }
        $this->hidelegenda = true;
        if ($this->hidelegenda === false) {
            echo "<style>div[name='" . _BROWSER_BREAKDOWN . "'] .glegend label{ border-bottom: 1px dotted silver; width: 80%; } </style>";
            $legendcontainerstyle = "width: 48%; float: left; margin:10px 0; display:block;";
            $legendstyle = "width: 100%; display: block; clear: both; ";
            echo "<div style='width:580px; margin:0 auto;'>";
            $this->graphcolors = $colors[0];
            echo $this->CreateLegend($legends["IE"], $legendcontainerstyle, $legendstyle, 28);
            $this->graphcolors = $colors[1];
            echo $this->CreateLegend($legends["FF"], $legendcontainerstyle, $legendstyle, 28);
            $this->graphcolors = $colors[2];
            echo $this->CreateLegend($legends["CR"], $legendcontainerstyle, $legendstyle, 28);
            $this->graphcolors = $colors[3];
            echo $this->CreateLegend($legends["OT"], $legendcontainerstyle, $legendstyle, 28);
            echo "<div>";
        }
    }

    function UpdateStats($from = '', $to = '', $print = 2)
    {
        return false;
    }
}

