function GetDatamModel(request, callback) {
    $.ajax({
        url: "app/model/DataManager.php",
        data: request,
        success: function (result) {
            res = ui.ParseJSON(result);
            callback(res);
        }
    });
}

function CheckPath() {
    GetDatamModel({checkpath: $(".datadir input").val()}, function (res) {
        if (res.Status == "Success") {
            $(".datadir i").css("color", "green");
            $(".datadir").attr("title", "");
            $(".datadir i").switchClass("fa-exclamation-triangle", "fa-check", 0);

        } else {
            $(".datadir i").css("color", "red");
            $(".datadir").attr("title", ui.data.languages['_PATH_NOT_WRITEABLE']);
            $(".datadir i").switchClass("fa-check", "fa-exclamation-triangle", 0);

        }
    });
}

function ProgressStream(header, params, from, to) {
    $(".datamImExControls").hide();
    $("#datamViewArchive").hide();
    $("#datamRunNow").hide();
    $(".progressListener .box-title").html("<i class='fa fa-archive'></i>&nbsp;" + header);
    $(".datamLogsList").hide();
    $(".progressListener .box-body").empty();
    $(".progressListener").show();

    if (from == undefined) {
        from = $(".datamImExControls select[name='fday']").val() + "-" +
            $(".datamImExControls select[name='fmonth']").val() + "-" +
            $(".datamImExControls select[name='fyear']").val();
    }

    if (to == undefined) {
        to = $(".datamImExControls select[name='tday']").val() + "-" +
            $(".datamImExControls select[name='tmonth']").val() + "-" +
            $(".datamImExControls select[name='tyear']").val();
    }

    let url = 'app/model/DataManager.php?conf=' + p.data.profile.profilename + "&fromDate=" + from + "&toDate=" + to;

    if (params != undefined) {
        url += params;
    }

    const source = new EventSource(url);

    source.addEventListener('message', function (e) {
        $(".progressListener .box-body").append('<div class="progress-log">' + e.data + '</div>');

        $(".progressListener .box-body").scrollTop($(".progressListener .box-body")[0].scrollHeight);


    }, false);

    source.addEventListener('error', function (e) {
        source.close();
        $("#datamViewArchive").show();
        $("#datamRunNow").show();
        $("#datamImpExp").button('reset');
    }, false);
}


CheckPath();

if (GetURLParameter('reimport-from') != undefined && GetURLParameter('reimport-to') != undefined) {
    $("#datamImpExp").button('loading');
    ProgressStream("Datamanager Import Progress", "&imp=true", GetURLParameter('reimport-from'), GetURLParameter('reimport-to'));
}

$(".datamIm").on("click", function () {
    $("#datamImpExp").button('loading');
    ProgressStream("Datamanager Import Progress", "&imp=true");
});

$(".datamEx").on("click", function () {
    $("#datamImpExp").button('loading');
    ProgressStream("Datamanager Export Progress", "&exp=true");
});

/* -- Check the path on every keystroke-- */
$(".datadir input").on("keyup", function () {
    CheckPath();
});

$("#datamRunNow").on("click", function (e) {
    e.preventDefault();
    $("#datamImpExp").hide();
    $("#datamViewArchive").hide();
    $(".datamImExControls").hide();
    $(".datamLogsList").hide();
    $(".progressListener .box-body").empty();
    $(".progressListener .box-title").html("<i class='fa fa-archive'></i>&nbsp;" + ui.data.languages["_DATAM_PROCESS"]);
    $(".progressListener").fadeIn();

    const btn = $(this);
    btn.button('loading');

    const source = new EventSource('app/model/DataManager.php?conf=' + p.data.profile.profilename + '&runDatamNow=1');

    source.addEventListener('message', function (e) {
        console.log(e);
        $(".progressListener .box-body").append('<div class="progress-log">' + e.data + '</div>');

        $(".progressListener .box-body").scrollTop($(".progressListener .box-body")[0].scrollHeight);
    }, false);

    source.addEventListener('error', function (e) {
        source.close();
        $("#datamImpExp").show();
        $("#datamViewArchive").show();
        btn.button('reset');
    }, false);


});

$("#datamImpExp").on("click", function (e) {
    e.preventDefault();
    $(".progressListener").hide();

    $(".datamImExControls").fadeIn();
});

$("#datamViewArchive").on("click", function (e) {
    e.preventDefault();
    $(".datamImExControls").hide();
    $(".progressListener").hide();

    $(".datamLogsList .archives").fadeIn();

    const btn = $(this);
    btn.button('loading');

    $(".datamLogsList .archives > ul").empty();

    $(".datamLogsList .box-title").html("<i class='fa fa-archive'></i>&nbsp;Archives");
    $(".datamLogsList").fadeIn();

    GetDatamModel({GetDatamanagerLogList: 1, conf: p.data.profile.profilename}, function (res) {
        btn.button('reset');

        if (res.Status != "Success") {
            ui.Callout(res);
        }

        if (res.Logs.length == 0) {
            $(".datamLogsList .archives > ul").append("<span>" + ui.data.languages["_NO_ARCHIVE_FILES"] + "</span>");
        }

        $.each(res.Logs, function (date, logs) {
            const li = "<li class='archive-date' name='" + date + "'><i class='fa fa-angle-right'></i><span>" + date + "</span><ul style='display:none;'></ul></li>";

            $(".datamLogsList .archives > ul").append(li);
            $.each(logs, function (k, v) {
                $(".datamLogsList .archives > ul > li[name='" + date + "'] ul").append("<li><i class='fa fa-file-o'></i><span>" + v + "</span></li>");
            });
            $(".datamLogsList .archives > ul > li[name='" + date + "']").on("click", function () {
                // switch arrow icon
                if ($(this).find("i").first().hasClass('fa-angle-right')) {
                    $(this).find("i").first().switchClass('fa-angle-right', 'fa-angle-down');
                } else {
                    $(this).find("i").first().switchClass('fa-angle-down', 'fa-angle-right');
                }


                $(this).find("ul").toggle();
            });
        });

    });
});

	
