<?php

if(!defined('APP_INCLUDE')){ die('invalid inclusion'); }
$headers = array(
	"From: Logaholic Web Analytics Alarm <{$fromTaEmail}>",
	"To: {$toUserMail}",
	"Cc: {$ccMail}"
);

$subject = "{$profilename} - Alarm {$event} for {$metric}";

$content = "--<'boundary'>
\r\n{$toUserName},
\r\nAn Alarm has been {$event} for the {$metric} metric on {$profilename}.
\r\n==== Profile Notes ====
\r\n$notes
\r\n==== Latest Test ====
\r\nTime range: {$timerange}
\r\nObserved: {$observed} {$metric} {$xvisits}
\r\nResult: $threshold
\r\n<'distributionGraph'>
\r\n==== Historical Graph(s) ====
\r\n<'historicalGraph'>";

$graphdivs[0] = "<div style='width:100%; float:left;'>
	<div id='chart0' style='float: left; width: 75%;'></div>
	<div class='glegend' style='float: left; width: 20%;'>
		" . implode($distributionPlotData['legend']) . "
	</div>
</div>
<script type='text/javascript'>
  $.jqplot('chart0', ". json_encode($distributionPlotData['data']) . ", {
      title:'Distribution Graph', 
      axes : {
      	yaxis : {
      		min : 0, tickInterval : 0.1, tickOptions: { show: false }
      	}
      },
      highlighter : { show : false },
      Trendline : { show : false },
      seriesColors : ['#FFA14E','#FFBF80','#98E3F9','#AEC7E8', '#68ADB5','#1F77B4'],
      seriesDefaults : {
      	lineWidth : 4, showMarker : false, pointLabels: { show:true } 
      },
      cursor : { show : false },
      grid : { shadow : false, gridLineColor : 'rgba(239,239,239,1)', borderWidth : 1, borderColor : 'rgba(239,239,239,1)' },
      series:[]
  })</script>
";

$graphdivs[1] = "<div style='width:100%; float:left;'>
	<div id='chart1' style='width:75% float:left;'></div>
	<div class='glegend' style='width:20% float:left;'>
		" . implode($metricData['legend']) . "
	</div>
</div>
<script type='text/javascript'>
  $.jqplot('chart1', ". json_encode($historicalPlotData) .", {
      title:'Historical Graph', 
      axes:{xaxis:{renderer:$.jqplot.DateAxisRenderer , min : '". $metricData['mindate'] . "' }},
      highlighter : { show : false },
      seriesColors : ['#68ADB5','#1F77B4'],
      cursor : { show : false },
      seriesDefaults : {
      	lineWidth : 4, showMarker : false, pointLabels: { show:false } 
      },
      grid : {
			shadow : false,
			gridLineColor : 'rgba(239,239,239,1)',
			borderWidth : 1,
			borderColor : 'rgba(239,239,239,1)'
	  },
      series:[{lineWidth:1 }]
  })</script>
";
?>