<?php

$reports["_TIMED_SPLIT_TEST"] = Array(
	"ClassName" => "TimeBasedSplitTest", 
	"Category" => "_TEST_CENTER",	
	"canAggregate" => false,  
	"icon" => "images/icons/32x32/time_based_split_test.png",
	"Options" => "daterangeField,profileselector,roadto",
	"Filename" => "time_based_split_test",
	"Distribution" => "Premium",
	"Order" => 2,
	"ReportVersion" => 1.0,
	"MinimumVersion" => 3.0,
	"EmailAlerts" => false,
	"Update" => false
); 

Class TimeBasedSplitTest extends Report{
	function Settings(){
		$this->help= _SPLIT_TEST_RESULTS_HELP;
	}
	function DisplayCustomForm(){
		$form = "<script>conf_name = '{$this->profile->profilename}'; from_date = {$this->from}; to_date = {$this->to};</script><div class='form-group'>
				<label for='tPage'>"._SEARCH_SPLIT_TEST." :</label>
				<input value='is' type='hidden' id=\"condition1\" class=\"report_option_field\" name=\"condition1\" src=\"condition\" />
				<input value='url' type='hidden' id=\"field1\" class=\"report_option_field\" name=\"field1\" src=\"field\" />
			
				<input class='report_option_field form-control' type='text' name='tPage' id='tPage' value='".@$this->tPage."' onkeyup=\"popupActionMenu(event, this.value+'@'+this.id+'@'+'page', 'forminput');\" onclick=\"popupActionMenu(event, this.value+'@'+this.id+'@'+'page', 'forminput');\">
			</div><div class='form-group'>
			<label>". _COMPARE_PAGE_TO_DATERANGE ."</label> 
			<select id='ba' class='report_option_field form-control'>
				<option value='before'>"._BEFORE."</option>
				<option value='after' >"._AFTER."</option>
			</select>
		</div>";		
		return $form;
	}
	function DisplayReport(){		
		
		$this->displayReportButtons = false;
		$this->reportHeader(); 
		
		$range =  $this->to - $this->from;
		$ndays = $range / 86400;
		if(empty($this->ba)){
			echoNotice($this->SettingsButton()._NO_OPTIONS_FOUND); 
			return false; 
		}
		if(empty($this->tPage)){
			echoNotice($this->SettingsButton()._NO_OPTIONS_FOUND); 
			return false; 
		}
		if($this->ba == "before"){
			$comparefrom = ($this->from -1) - $range;
			$compareto = $comparefrom + $range;
		}
		if($this->ba == "after"){
			$comparefrom = $this->to + 1;
			$compareto = $comparefrom + $range; 
		}
		
		$data1 = $this->collectData($this->from, $this->to);
		$data2 = $this->collectData($comparefrom, $compareto);

		
		echo "<div style='width:500px;margin: 0 auto;font-size:14px;line-height:20px;padding: 10px 0 10px 0;'>";
		echo _TESTING_PAGE.": <strong>{$this->tPage}</strong><br />";
		echo _KEY_PERFORMANCE_INDICATOR.": <strong>{$this->roadto}</strong><br />";
		echo "</div>";	
		
		$this->CompareMeter(_COMPARING_DATE_RANGE.":", 50,50,_RANGE." A (".date("d M Y",$data1["from"])." - ".date("d M Y",$data1["to"]).")", _RANGE." B (".date("d M Y",$data2["from"])." - ".date("d M Y",$data2["to"]).")");
		$this->CompareMeter(_PAGE." "._VISITORS.":", $data1['page_total'], $data2['page_total']);
		$this->CompareMeter(_SHARE_TOTAL_CONVERSION.":", $data1["salesp"] , $data2["salesp"], $data1["salesp"]."% of ".$data1["conversions"]." "._USERS, $data2["salesp"]."% of ".$data2["conversions"]." "._USERS);
		
		$this->CompareMeter(_DIRECT_CONVERSIONS.":", $data1["direct"] , $data2["direct"], "{$data1['direct']}% ({$data1['target_total']})", "{$data2['direct']}% ({$data2['target_total']})");

		$this->CompareMeter(_TIMELAPSE_CONVERSIONS.":", $data1["indirect"] , $data2["indirect"], "{$data1['indirect']}% ({$data1['target_indirect_total']})", "{$data2['indirect']}% ({$data2['target_indirect_total']})");

		
		echo "<br>";
		$this->DisplayWinner($data1,$data2,"Range");
		?>
		
		
		<?php
	}
	
	
	function collectData($f, $t){
		global $db;
		$page_id = getID($this->tPage,"urls");
		$target_id = getID($this->roadto,"urls");
		
		$query="select count(distinct visitorid) as users from {$this->profile->tablename_conversions} where timestamp >=". $db->quote($f) ." and timestamp <=". $db->quote($t) ." and url='$target_id'"; 
		$result=$db->Execute($query);
		$data=$result->FetchRow();
		$conversions=$data["users"];
		
		$query="select count(distinct visitorid) as users from {$this->profile->tablename} where timestamp >=". $db->quote($f) ." and timestamp <=". $db->quote($t) ." and url='$page_id' and (status=200 or status=302)";
		$result=$db->Execute($query);
		$data=$result->FetchRow();
		$page_total=$data["users"];
		
		$query="select count(distinct visitorid) as users from {$this->profile->tablename} as a, {$this->profile->tablename_referrers} as r where timestamp >=". $db->quote($f) ." and timestamp <=". $db->quote($t) ." and url='$target_id' and a.referrer=r.id and r.referrer like ". $db->quote("%{$this->profile->confdomain}{$this->tPage}") ." and (status=200 or status=302)";
		$result=$db->Execute($query);
		$data=$result->FetchRow();
		$target_total=$data["users"];
		
		$subq = "select visitorid, timestamp from {$this->profile->tablename_conversions} where url='$target_id' and timestamp between ". $db->quote($f) ." and ". $db->quote($t);
		$query="select count(distinct l2.visitorid) as users from {$this->profile->tablename} as l, ($subq) as l2 where l.timestamp >=". $db->quote($f) ." and l.timestamp <=". $db->quote($t) ." and l.visitorid=l2.visitorid and l.url='$page_id' and l.timestamp < l2.timestamp and (l.status=200 or l.status=302)";
				
		$result=$db->Execute($query);
		$data=$result->FetchRow();
		$target_indirect_total=$data["users"];
		
				
		$return["conversions"] = $conversions;
		$return["page_total"] = $page_total;
		$return["target_total"] = $target_total;
		$return["target_indirect_total"] = $target_indirect_total;
		$return["from"] = $f;
		$return["to"] = $t;
		
		if($return["page_total"] > 0){
			$return['direct'] = number_format(($return["target_total"]/$return["page_total"]*100),2);
			$return['indirect'] = number_format(($return["target_indirect_total"]/$return["page_total"]*100),2);
		}else{
			$return['direct'] = 0;
			$return['indirect'] = 0;
		}
		if($return["conversions"] > 0){		
			$return["salesp"] = number_format(($return["target_indirect_total"]/$return["conversions"]*100),2);
		}else{
			$return["salesp"] = 0;
		}
		
		return $return;
	}
	
	function UpdateStats($from = '', $to = '',$print = 2) {
		return false;
	}
}
?>