<?php

/**
* @desc This report displays the used os versions
*/

$reports["_OS_VERSIONS"] = Array(
	"ClassName" => "OSVersions", 
	"Category" => "_CLIENT_SYSTEM", 
	"icon" => "images/icons/32x32/os_versions.png",
	"Options" => "daterangeField,profileselector,displaymode,trafficsource,limit,columnSelector",
	"Filename" => "os_versions",
	"Distribution" => "Premium",
	"Order" => 6,
	"ReportVersion" => 1.0,
	"MinimumVersion" => 3.0,
	"EmailAlerts" => true
);

class OSVersions extends Report {

	function Settings() {
		$this->DefaultDisplay = "table";
		$this->DisplayModes = "table,pie";
		
		$this->columnDefinitions[] = array("Label" => "_OPERATING_SYSTEM");
		$this->columnDefinitions[] = array("Label" => "_VISITS");
		$this->sort_order = SORT_DESC;
		$this->sort_key = 1;
	}
	
	function DefineQuery() {
		global $db;

		$query = subsetDataToSourceID("SELECT IF(ua.os_version='','Unknown',ua.os_version) AS os_name, COUNT(DISTINCT a.sessionid) AS visits, COUNT(DISTINCT a.visitorid) AS visitors, ua.os FROM {$this->profile->tablename} AS a, {$this->profile->tablename_useragents} as ua WHERE a.useragentid = ua.id AND  a.timestamp BETWEEN ". $db->quote($this->from) ." AND ". $db->quote($this->to) ." AND ua.is_mobile = 0 GROUP BY os_version, os ", $this->trafficsource);
		$query .= subsetDataToSourceID(" UNION SELECT 'Mobile Operating Systems' AS os_name, COUNT(DISTINCT a.sessionid) AS visits, COUNT(DISTINCT a.visitorid) AS visitors, 'Mobile Operating Systems' FROM {$this->profile->tablename} AS a, {$this->profile->tablename_useragents} as ua WHERE a.useragentid = ua.id AND  a.timestamp BETWEEN ". $db->quote($this->from) ." AND ". $db->quote($this->to) ."  AND ua.is_mobile = 1 GROUP BY 'Mobile Operating Systems' ", $this->trafficsource);

		$query .= "ORDER BY visits DESC";
		$this->applytrafficsource = false;
		return $query;
	}
	
	function UpdateStats($from = '', $to = '',$print = 2) {
		# because the query takes too long
		return false;		
	}
}
?>
