<?php


$reports["_OPENCART_TOP_AFFILIATES"] = Array(
	"ClassName" => "OpenCartTopAffiliates",
	"Category" => "_OPENCART",
	"icon" => "images/icons/32x32/opencart.png",
	"Options" => "daterangeField,columnSelector",
	"Filename" => "oc_top_affiliates",
	"Distribution" => "Premium",
	"Order" => 5,
	"ReportVersion" => 1.0,
	"MinimumVersion" => 3.0,
	"EmailAlerts" => false,
	"Update" => false
);
Class OpenCartTopAffiliates extends Report{

	function Settings() {
		$this->columnDefinitions[] = array("Label" => 'Company'); 
		$this->columnDefinitions[] = array("Label" => _ORDERS); 
		$this->columnDefinitions[] = array("Label" => 'Commission'); 
		$this->columnDefinitions[] = array("Label" => 'Amount'); 
		$this->bchart[] = _ORDERS;
		if(empty($this->oc_store)) { $this->oc_store = '0'; }	
		$this->tableprefix = $this->profile->GetOtherSettings("externalConnection.prefix.openCartConnect", "");
	}
	
	function DefineQuery() {
		global $db;
		$query = "SELECT a.company as affname,
			count(a.company) as ord,
			CONCAT(a.commission,'%') as comm,
			(SELECT SUM(amount) from {$this->tableprefix}affiliate_transaction WHERE affiliate_id = a.affiliate_id) as amount,			
			(SELECT `code` from {$this->tableprefix}currency WHERE `value` = 1) as currency

			FROM {$this->tableprefix}affiliate as a,
			{$this->tableprefix}affiliate_transaction as aft,
			`{$this->tableprefix}order` as o
			
			WHERE a.affiliate_id = o.affiliate_id AND o.store_id = ". $db->quote($this->oc_store) ."
			GROUP BY a.company
			ORDER BY amount DESC
			LIMIT ". $this->limit;
		return $query;
	}
	
	function GetReportData() {		
		global $cnames;
		
		$countrynames = array_flip($cnames);
		
		$connection = $this->checkExternalConnection("openCartConnect");
		if($connection == false){ echoNotice($this->SettingsButton()._CONNECTION_TO_DATABASE_FAILED);exit();  }
		
		$query = $this->DefineQuery();
		
		$result = mysql_query($query, $connection);
		$currency = "";
		$data = [];
		while($row = mysql_fetch_array($result)) {
			if(empty($row[0])) {
				continue;
			}
			
			$data[] = $row;
			if(!empty($row['currency'])) {
				$currency = $row["currency"];
			}
		}
		$this->addlabel = _CURRENCY .": {$currency}";
		return $data;
	}
	
	function DisplayCustomForm() {
		global $session;
		
		$connection = $this->checkExternalConnection("openCartConnect");
		if($connection != false){		
			#GET STORES
			$query = "SELECT `store_id`,`name` FROM store";
			$result = mysql_query($query, $connection);
			
			echo "<div class='form-group'><label for='oc_store'>".'Store'."</label>";
			
			echo "<select id='oc_store' name='oc_store' class='form-control'>";
			
			echo "<option value='0'>".'Default Store'."</option>";
			while($row = mysql_fetch_assoc($result)) {
				if($row['store_id'] == $this->oc_store) {
					$selected = ' selected ';
				} else {
					$selected = '';
				}
				echo "<option value='{$row["store_id"]}' {$selected}>{$row["name"]}</option>";
			}
			echo "</select>";
			if($session->canEditProfiles()) {
				echo "<a data-title='"._VIEW_OPENCART_CONF."' href='definereport.php?conf={$this->profile->profilename}&testcenter=create&labels={$this->label_constant}&action=welcome' class='optionlink open_iframe_window'>"._VIEW_OPENCART_CONF."</a>";
			}
			echo "</div>";

			
			# GET ORDER STATUS
			$query = "SELECT DISTINCT(order_status_id) AS status_id, `name` AS status_name FROM `{$this->tableprefix}order_status` ORDER BY `name` ASC";
			
			$result = mysql_query($query, $connection);
			
			if(empty($this->order_status)) { $this->order_status = '0'; }
			if(empty($this->order_status_name)) { $this->order_status_name = _ALL_STATUSSES; }			

			echo "<div class='form-group'>";
				echo "<label for='order_status'>"._ORDER_STATUS."</label>";
				echo "<input type='hidden' id='order_status_name' name='order_status_name' value='{$this->order_status_name}'>";
				
				echo "<select id='order_status' name='order_status' class='form-control'>";
					echo "<option value='0'>"._ALL_STATUSSES."</option>";
				while($row = mysql_fetch_assoc($result)) {
					if($row['status_id'] == $this->order_status) {
						$selected = ' selected ';
					} else {
						$selected = '';
					}
					echo "<option {$selected} value='{$row['status_id']}'>{$row['status_name']}</option>";
				}
				echo "</select>";
			echo "</div>";
			
			echo "<script type='text/javascript'>";
				echo "$('#order_status').change(function() {
					$('#order_status_name').attr('value', $(this).find('option[value=\"' + $(this).val() + '\"]').html());
				});";
			echo "</script>";
		} else if($session->canEditProfiles()) {
			echo "<div class='form-group'><a data-title='"._VIEW_OPENCART_CONF."' href='definereport.php?conf={$this->profile->profilename}&testcenter=create&labels={$this->label_constant}&action=welcome' class='optionlink open_iframe_window'>"._VIEW_OPENCART_CONF."</a></div>";
		}
	}
	function DefineReport(){
		$this->externDbConnectForm("openCartConnect");	
	}
	
	function UpdateStats($from = '', $to = '',$print = 2) {
		return false;
	}
}