<?php

/**
* @desc This report displays athe mobile agents
*/
$reports["_MOBILE_AGENTS"] = Array(
	"ClassName" => "MobileAgents", 
	"Category" => "_CLIENT_SYSTEM", 
	"icon" => "images/icons/32x32/mobileuseragents.png",
	"Options" => "daterangeField,profileselector,limit,columnSelector",
	"Filename" => "mobile_agents",
	"Distribution" => "Premium",
	"Order" => 9,
	"ReportVersion" => 1.0,
	"MinimumVersion" => 3.0,
	"EmailAlerts" => true
);

class MobileAgents extends Report {

	function Settings() {
		$this->sort_order = SORT_DESC;
		$this->sort_key = 0;
		$this->key_col = 7;
		
		$this->columnDefinitions[] = array("Label" => "_VISITS");
		$this->columnDefinitions[] = array("Label" => "_BROWSER");
		$this->columnDefinitions[] = array("Label" => "_BROWSER_VERSION", "dataType" => "String");
		$this->columnDefinitions[] = array("Label" => "_OS_VERSION", "dataType" => "String");
		$this->columnDefinitions[] = array("Label" => "_DEVICE");
		$this->columnDefinitions[] = array("Label" => "_UNIQUE_VISITORS","display" => false);
		$this->columnDefinitions[] = array("Label" => "_PAGEVIEWS","display" => false);
		$this->columnDefinitions[] = array("Label" => "key","display" => false);
	}
	
	function DefineQuery() {	
		global $db;
		$query = "SELECT COUNT(distinct a.sessionid) AS visits,ua.name,ua.version,ua.os_version,ua.device,COUNT(distinct a.visitorid) AS visitors, count(*) as pageviews, MD5(CONCAT(ua.name,ua.os_version,ua.device)) as grouper FROM {$this->profile->tablename} as a INNER JOIN {$this->profile->tablename_useragents} as ua ON a.useragentid = ua.id WHERE a.timestamp BETWEEN ". $db->quote($this->from) ." AND ". $db->quote($this->to) ." AND a.status = 200 AND ua.is_mobile = 1 GROUP BY name,os_version,device,ua.version ORDER BY visits DESC";
		
		return $query;
	}
	
	function GetReportData() {
		$d = parent::GetReportData();
		$data = [];
		foreach($d as $k => $v){
			if($v[4] === 0){
				$v[4] = "";
			}
			$data[$k] = $v;
		}
		return $data;
	}
	
	function UpdateStats($from = '', $to = '',$print = 2) {
		# because the query takes too long
		return false;		
	}
}
?>
