<?php

define("_MINI_TOTAL_PAGEVIEWS",	_TOTAL_PAGEVIEWS );

$reports["_MINI_TOTAL_PAGEVIEWS"] = Array(
	"ClassName" => "MiniTotalPageviews", 
	"Category" => "_KEY_METRIC", 
	"icon" => "images/icons/32x32/visitorsperday.png",
	"Options" => "daterangeField,profileselector",
	"Filename" => "metric_total_pageviews",
	"Distribution" => "Standard",
	"Order" => 3,
	"ReportVersion" => 6.0,
	"MinimumVersion" => 6.0,
	"Update" => false
);

class MiniTotalPageviews extends Report {
	
	function GetReportData(){
		global $reports;

		$r = new $reports['_VISITORS_PER_DAY']['ClassName']();
		$r->IgnReIm = 1;
		$r->from = $this->from;
		$r->to = $this->to;
		$data = $r->GetReportData();

		$pageviews = 0;

		foreach ($data as $row => $col) {
			$pageviews += $col[2];
		}

		$daterange = date(implode($this->profile->dateFormat), $this->from) . " - " . date(implode($this->profile->dateFormat), $this->to);

		return array( 
			_PAGEVIEWS 					# Label
			,number_format($pageviews) 	# Number to display
			,'_VISITORS_PER_DAY'		# Report label to load
			,'ion-ios-photos'			# Background icon Class
			,'bg-green'
			,"<strong>". $daterange . "</strong><br/>" . _MINI_TOTAL_PAGEVIEWS_DESC
		);
	}
}
?>