<?php

define("_MINI_SITE_ERRORS",_SITE_ERRORS );

$reports["_MINI_SITE_ERRORS"] = Array(
	"ClassName" => "MiniSiteErrors", 
	"Category" => "_KEY_METRIC", 
	"icon" => "images/icons/32x32/visitorsperday.png",
	"Options" => "daterangeField,profileselector",
	"Filename" => "metric_site_errors",
	"Distribution" => "Standard",
	"Order" => 4,
	"ReportVersion" => 6.0,
	"MinimumVersion" => 6.0,
	"Update" => false
);

class MiniSiteErrors extends Report {
	
	function GetReportData(){
		global $reports;

		$r = new $reports['_ERROR_REPORT']['ClassName']();
		$r->IgnReIm = 1;
		$r->dataCollectType = "days";
		$r->createDataFiles($this->from,$this->to);	
		$error_data = $r->getTrendDataFromFiles($r->DataFiles($r->from,$r->to));

		$total = 0;

		foreach($error_data as $k => $entry){
			foreach ($entry as $d) {
				$total += $d[1]; 
			}
		}

		$daterange = date(implode($this->profile->dateFormat), $this->from) . " - " . date(implode($this->profile->dateFormat), $this->to);

		return array( 
			_SITE_ERRORS 			# Label
			,number_format($total) 	# Number to display
			,'_ERROR_REPORT'		# Report label to load
			,'ion-android-warning'	# Background icon Class
			,'bg-orange'			# Background color class
			,"<strong>". $daterange . "</strong><br/>" . _MINI_SITE_ERRORS_DESC
		);
	}
}
?>