<?php

$reports["_MAILCHIMP_LIST_RATE"] = Array( 
  "ClassName" => "MailChimpListRate", 
  "Category" => "_MAILCHIMP", 
  "Options" => "displaymode",
  "Distribution" => "Premium",
  "EmailAlerts" => false,
  "Update" => false,
  "Filename" => "mailchimp_list_rate" 
); 


use DrewM\MailChimp\MailChimp;

class MailChimpListRate extends Report {

    function Settings() {
        $this->DisplayModes = "table,barchart";
        $this->DefaultDisplay = "barchart";
        $this->columnDefinitions[] = array("Label" => "Title");
        $this->columnDefinitions[] = array("Label" => "Avg Sub Rate");
        $this->columnDefinitions[] = array("Label" => "Avg Unsub Rate");
        $this->columnDefinitions[] = array("Label" => "Open Rate");
        $this->columnDefinitions[] = array("Label" => "Click Rate");
        $this->help = "This will show the rates for each list for mailchimp.";
        $old_api_key = $this->profile->GetOtherSettings("MailChimpApiKey", "");
        if(isset($this->ApiKey) && $this->ApiKey != $old_api_key) {
           $this->profile->SetOtherSettings("MailChimpApiKey", $this->ApiKey);
        } else {
            $this->ApiKey = $old_api_key;
        }
    }
    function DisplayCustomForm(){
        $form = "<div class='form-group'>" .
                "<label for='author'>API Key:</label>
                <input type='text' name='ApiKey'
                value='".@$this->ApiKey."' class='report_option_field form-control' /> " .
                "</div>";
        return $form;
    } 
    function GetReportData(){
        include_once 'includes/MailChimp.php';

        $mc = new MailChimp($this->ApiKey);

        $mc->verify_ssl = false; 

        $result = $mc->get('lists');
        
        $data = [];

        if(empty($result)){
            return $data;
        }

        $i = 0;
        foreach($result['lists'] as $campaign){
            $data[$i][0] = $campaign['name'];  
            $data[$i][1] = $campaign['stats']['avg_sub_rate'];
            $data[$i][2] = $campaign['stats']['avg_unsub_rate'];
            $data[$i][3] = $campaign['stats']['open_rate']; 
            $data[$i][4] = $campaign['stats']['click_rate'];

            $i++;   
        }
        return $data;
    }
    function DisplayReport(){
        if (empty($this->ApiKey)) {
            echoNotice($this->SettingsButton(). "The Key field is empty. <br><br> for more information: check <a href='https:///kb.mailchimp.com/accounts/management/about-api-keys?utm_source=mc-api&utm_medium=docs&utm_campaign=apidocs&_ga=1.268391566.1298809865.1456133150' target='_blank'>the documentation</a>. "
            );
            return false;
        }elseif(strpos($this->ApiKey, '-') === false){
            echoWarning($this->SettingsButton(). "The Key field is invalid. <br><br> for more information: check <a href='https:///kb.mailchimp.com/accounts/management/about-api-keys?utm_source=mc-api&utm_medium=docs&utm_campaign=apidocs&_ga=1.268391566.1298809865.1456133150' target='_blank'>the documentation</a>. "
            );
            return false;
        }
        else{
                parent::DisplayReport();
        }   
    }         
}
?>