<?php

/**
* @desc shows a trend of the most popular keyword 
*/

$reports["_KEYWORD_TRENDS"] = Array(
	"ClassName" => "KeywordTrends", 
	"Category" => "_TRAFFIC_SOURCES",
	"icon" => "images/icons/32x32/keywordtrends.png",
	"Options" => "daterangeField,profileselector,trafficsource,search,period,displaymode,limit",
	"Filename" => "keyword_trends",
	"Distribution" => "Premium",
	"Order" => 7,
	"ReportVersion" => 1.0,
	"MinimumVersion" => 3.0,
	"EmailAlerts" => false,
	"Update" => false,
	"canAggregate" => false
);

class KeywordTrends extends Report {

	function Settings() {
		$this->DefaultDisplay = "areachart";
		$this->DisplayModes = "table,linechart,areachart";
		$this->help = "";
		$this->displayReportButtons = false;
		$this->remove_outputmodes = array("xml");
		$this->allowDateFormat = false;
		$this->actionmenu_type = 'keyword';
		if(empty($this->period)){ $this->period = '_DAYS';  }
		$this->chartoptions = array("stacked_graph_style" => "stack", "stacked_showcontrols" => true, "showlegend" => false);
		$this->addlabel .= _GROUPED_BY . " ".constant($this->period);
	}

	function GetReportData() {

		$data = $this->rawGetReportData();

		$data = $this->ConvertData($data);
		return $data;	

	}

	function rawGetReportData() {
		global $reports;
		$r = new $reports["_TOP_KEYWORDS"]["ClassName"]();
		$r->dataCollectType = "days";
		$r->createDataFiles($this->from,$this->to);	
		$d = $r->getTrendDataFromFiles($r->DataFiles($this->from,$this->to));
		
		$data = [];		
		foreach($d as $k => $v){
			$l = 0;
			if(empty($v)) { continue; }
			foreach($v as $val){		
				if ($this->limit < 50 && $l > ($this->limit * 5)){
					break;
				} else if ($this->limit >= 50 && $l > ($this->limit * 2)){
					break;
				}
				$timestamp = mktime(0,0,0,substr($k,4,-2),substr($k,6,7),substr($k,0,4));
				
				$keyword = $val[0];
				$visits = $val[1];
				
				# Define the chosen period / time unit
				if ($this->period == '_DAYS') { 
					$format = "D, m/d/Y";
					$date = date($format,$timestamp);
					
				} else if ($this->period == '_WEEKS') {
					$format = "Y-#W";
					$date = date($format,$timestamp);
					$date = str_replace("#","W",$date);
				} else if ($this->period == '_MONTHS') {
					$format = "M Y";
					$date = date($format,$timestamp);
				}				
				
				if(isset($data[$keyword][$date])) {				
					$data[$keyword][$date] = $data[$keyword][$date] + $visits;
				} else {	
					$data[$keyword][$date] = $visits;
				}
				$l ++;
			}
		}
		
		$temp_d = [];		
		foreach($data as $keyword => $v){
			$temp_d[$keyword] = array_sum($v);
		}
		arsort($temp_d);
		
		$final = [];
		$i = 0;
		$l = 0;
		foreach($temp_d as $keyword => $v){		
			if($l > $this->limit){
				break;
			}			
			foreach($data[$keyword] as $date => $visits){
				$final[$i][0] = $date; 
				$final[$i][1] = $keyword; 
				$final[$i][2] = $visits; 
				$i ++;
			}			
			$l ++;
		}
		return $final;
	}

	function ConvertData($data = "") {
		// if(empty($data)) {
		// 	$data = $this->GetReportData();
		// }
		
		# transform the data array to a column for each serie
		$data = $this->seriesToColumns($data);
		
		if(empty($data)) {
			return $this->EmptyTrendData();
		}	
		
		foreach($data['fields'] as $key => $val) { 
			if (strpos($val, "javascript")!==false) {
				$val= str_replace("'", "\"", $val);
			}
			$this->columnDefinitions[] = array("Label" => $val);
		}
		$this->setupColumnDefinitions();
		
		# create an empty seed array with the right dimensions
		$ncols = count($data['fields']);
		$nrows = $this->dateNumber($this->from, $this->to, $this->period);
		
		$seed_data = $this->newReportArray($nrows, $ncols);
		# add a date to he first value of each row.
		$seed_data = $this->AddDateToZeroArray($seed_data);
		
		# merge the actual results with the seed_data array
		foreach ($data['data'] as $key => $val) {
			if($this->period == '_WEEKS'){
				$dparts = explode("-",$key);
				$year = mktime(0,0,0,1,1,$dparts[0]);
				$week = str_replace("W","",$dparts[1]);
			
				$timestamp = (86400 * 7 * $week) + $year;		
			} else {
				$timestamp = strtotime($key);
			}
			
			$day_id = $this->dateNumber($this->from,$timestamp, $this->period);
			
			for ($i=0;$i<$ncols;$i++) {
				if (isset($val[$i])) {
					$seed_data[$day_id][$i] = $val[$i];
				}
			}		
		}	
		ksort($seed_data);
		
		# now make sure the date column is properly filled
		foreach($seed_data as $key => $value) {
			$value[0] = $this->getFormatDate($this->period,($this->from+(($key)*$this->getSeconds($this->period))));
			$seed_data[$key] = $value;
		}
		
		return $seed_data;
	}

	
	function UpdateStats($from = '', $to = '',$print = 2) {
		# not using datafiles yet
		return false;		
	}
}
?>