<?php

/**
* @desc This report displays the age of your facebook friends 
*/
$reports["_FACEBOOK_VIDEOS"] = Array(
    "ClassName" => "FacebookPageVideos", 
    "Category" => "_FACEBOOK", 
    "icon" => "images/icons/32x32/facebookicon.png",
	"Options" => "daterangeField,displaymode",
	"Filename" => "facebook_page_videos",
	"Distribution" => "Premium",
	"Order" => 16,
	"ReportVersion" => 4.0,
	"MinimumVersion" => 3.0,
	"EmailAlerts" => false,
	"Update" => false
);

class FacebookPageVideos extends FacebookCore {
	
	function Settings() {
		parent::Settings();
		$this->DisplayModes = "table,linechart";
		$this->DefaultDisplay = "linechart";
		if(empty($this->displaymode)){
			$this->displaymode = $this->DefaultDisplay;
		}
		$this->addlabel = _FACEBOOK_VIDEOS_ADDLABEL;
		$this->help = _FACEBOOK_VIDEOS_HELP;
		$this->metric = "videos";
	}	
    
	function DisplayGraph(){
		?><script type="text/javascript">
		function lg_fb_<?php echo $this->graphID; ?>(container_id,result){
			if(result.Status == undefined || result.Status != "Success"){
				return;
			}

			var data = result.data;
			if(!data || data.values === undefined){
				console.log("No data");
				return;
			}	

			var lg_gr_data = [	
				{"key":"Viewed Videos","area":true,"disabled":false,"values": [] }
			];
			var xticks=[];

			

			for (var i = 0; i < data.values.length; i++) {
				var row = data.values[i];


				xticks.push(d3.time.format('<?php echo GetCustomDateFormat("D3"); ?>')(new Date(row.end_time)));

				lg_gr_data[0].values[i] = [i , parseInt(row.value) ];
			}

			$("#"+container_id).attr("data-ticks", JSON.stringify(xticks) );
			$("#"+container_id).attr("data-chart", JSON.stringify(lg_gr_data) );
			
			lg.LineChart(container_id);
		}
		</script><?php
	}

	function DisplayTable(){
		?><script type="text/javascript">
		function lg_fb_<?php echo $this->graphID; ?>(container_id,result){
			if(result.Status == undefined || result.Status != "Success"){
				return;
			}

			var data = result.data;
			if(!data || data === undefined){
				console.log("No data");
				return;
			}		

			var dataSet = [];

			var columnSet = [
				{ title : "<?php echo _DATE; ?>" },
				{ title : "Posts" }
			];

			for (var i = 0; i < data.values.length; i++) {
				var row = data.values[i];

				var time = d3.time.format('<?php echo GetCustomDateFormat("D3"); ?>')(new Date(row.end_time));

				dataSet.push( [time, row.value.toString() ] );

			}

			$("#" + container_id ).dataTable({
				data: dataSet,
		        columns: columnSet,	
		        "iDisplayLength": dataSet.length,	        
				"aaSorting": [],		
				"sDom": "t"
			});

		}
		</script><?php
	}
}
?>