<?php

$accessControl = array('Admin' => true);
require_once "../../AccessControl.php";

require_once '../../includes/upload_dir.php';

function CheckUploadDir($dir) {
    if (is_dir($dir)) {
        if (!is_writable($dir)) {
            return '{ "Status": "Error", "Message": "'. _PATH_NOT_WRITEABLE .'", "Type": "Permissions" }';
        }    

        if (strpos($dir,$_SERVER['DOCUMENT_ROOT'])!==false) {
            return '{ "Status": "Warning", "Message": "'. _THIS_VALID_PATH .'" }';
        }
        return '{ "Status": "Success", "Message": "'. _THIS_VALID_PATH .'" }';

    } else {
        return '{ "Status": "Error", "Message": "'. _DIR_NOT_EXISTS .'" }';

    }

}



if (isset($_REQUEST['check_upload_dir'])) {
    echo CheckUploadDir($_REQUEST['check_upload_dir']);

}


if (isset($_REQUEST['change_upload_dir'])) {
    
    $res = json_decode(CheckUploadDir($_REQUEST['change_upload_dir']), true);


    if ($res["Status"] == "Success" || $res["Status"] == "Warning") {        
        
        # save it
        $_REQUEST['change_upload_dir'] = properSlash($_REQUEST['change_upload_dir']);
        setGlobalSetting("upload_dir",$_REQUEST['change_upload_dir']);
        echo '{ "Status": "Success", "Message": "'. _NEW_UPLOAD_DIR_SAVED .'" }';

    } else {
        echo json_encode($res);
    }
}

?>