<?php

/**
* @desc This report displays a overview of your top Feeds
*/
$reports["_TOP_FEEDS"] = Array(
	"ClassName" => "TopFeeds", 
	"Category" => "_POPULAR_CONTENT", 
	"icon" => "images/icons/32x32/rssfeeds.png",
	"Options" => "daterangeField,profileselector,search,limit,columnSelector",
	"Filename" => "top_feeds",
	"Distribution" => "Premium",
	"Order" => 6,
	"ReportVersion" => 1.0,
	"MinimumVersion" => 3.0,
	"EmailAlerts" => true,
	"canAggregate" => false
);

class TopFeeds extends Report {

	function Settings() {
		$this->columnDefinitions[] = array("Label" => "_PAGE","actionmenu" => 'page');
		$this->columnDefinitions[] = array("Label" => "_VISITS");
		$this->columnDefinitions[] = array("Label" => "_PAGEVIEWS");
		$this->columnDefinitions[] = array("Label" => "_UNIQUE_VISITORS","display" => false);
		$this->sort_key= 1;
		$this->sort_order = SORT_DESC;
		$this->help = _DEFINITIONS_FOR_THIS_REPORT.':<ul><li>'._PAGE_DEFINITION.'<li>'._VISITS_RSS_DEFINITION.'<li>'._PAGEVIEWS_DEFINITION.'</ul><br><br>'._RSS_NOTICE;
	}
	
	function DefineQuery() {
		global $db;
        $query  = "select r.url,count(distinct sessionid) as visits,count(*) as hits,count(distinct visitorid) as visitors from {$this->profile->tablename_crawl}, {$this->profile->tablename_urls} as r where timestamp >= ". $db->quote($this->from) ." and timestamp <= ". $db->quote($this->to) ." and r.id={$this->profile->tablename_crawl}.url and crawl=2 group by {$this->profile->tablename_crawl}.url, r.url order by visits desc";
		
		return $query;
	}
}
?>
