<?php

/**
 * @desc This report displays a overview of search engines
 */
$reports["_SEARCH_ENGINES"] = array(
    "ClassName" => "SearchEngines",
    "Category" => "_TRAFFIC_SOURCES",
    "icon" => "images/icons/32x32/searchengines.png",
    "Options" => "daterangeField,profileselector,displaymode,trafficsource,limit,columnSelector",
    "Filename" => "search_engines",
    "Distribution" => "Premium",
    "Order" => 8,
    "ReportVersion" => 1.0,
    "MinimumVersion" => 3.0,
    "EmailAlerts" => true
);

class SearchEngines extends Report
{

    function Settings()
    {
        $this->DefaultDisplay = "table";
        $this->DisplayModes = "table,pie";
        $this->columnDefinitions[] = array("Label" => "_SEARCH_ENGINE");
        $this->columnDefinitions[] = array("Label" => "_VISITS");
        $this->columnDefinitions[] = array("Label" => "_HITS");
        $this->columnDefinitions[] = array("Label" => "_SEARCHES_PER_USER");
        $this->sort_order = SORT_DESC;
        $this->sort_key = 1;
    }

    function DefineQuery()
    {
        global $db;
        if ($this->from < mktime(
                12,
                0,
                0,
                6,
                3,
                2009
            )) { // This is when Bing was launched. If report is in an earlier date, we still display these old buggers
            $query = subsetDataToSourceID(
                " select r.referrer, count(distinct sessionid) as visits, count(*) as hits, count(distinct visitorid) as visitors from {$this->profile->tablename} as a, {$this->profile->tablename_referrers} as r,{$this->profile->tablename_keywords} as k where timestamp >=" . $db->quote(
                    $this->from
                ) . " and timestamp <=" . $db->quote(
                    $this->to
                ) . " and a.keywords=k.id and k.keywords!='' and r.referrer not like \\",
                $this->trafficsource
            );
            $query .= subsetDataToSourceID(
                "select \"MSN Search\" referrer, count(distinct sessionid) as visits, count(*) as hits, count(distinct visitorid) as visitors from {$this->profile->tablename} as a, {$this->profile->tablename_referrers} as r where timestamp >=" . $db->quote(
                    $this->from
                ) . " and timestamp <=" . $db->quote(
                    $this->to
                ) . " and (r.referrer like \"%search.msn.%\" or r.referrer like  \"%.live.com%\") and a.referrer=r.id union ",
                $this->trafficsource
            );
        } else {
            $query = subsetDataToSourceID(
                " select r.referrer, count(distinct sessionid) as visits, count(*) as hits, count(distinct visitorid) as visitors from {$this->profile->tablename} as a, {$this->profile->tablename_referrers} as r,{$this->profile->tablename_keywords} as k where timestamp >=" . $db->quote(
                    $this->from
                ) . " and timestamp <=" . $db->quote(
                    $this->to
                ) . " and a.keywords=k.id and k.keywords!='' and r.referrer not like \\",
                $this->trafficsource
            );
            //echo $query;
        }

        $query .= subsetDataToSourceID(
            "select \"Google (Natural Search)\" referrer, count(distinct sessionid) as visits, count(*) as hits, count(distinct visitorid) as visitors from {$this->profile->tablename} as a, {$this->profile->tablename_referrers} as r,{$this->profile->tablename_urlparams} as up where timestamp >=" . $db->quote(
                $this->from
            ) . " and timestamp <=" . $db->quote(
                $this->to
            ) . " and ((r.referrer like \\",
            $this->trafficsource
        );

        $query .= subsetDataToSourceID(
            "select \"Google (Paid Search)\" referrer, count(distinct sessionid) as visits, count(*) as hits, count(distinct visitorid) as visitors from {$this->profile->tablename} as a, {$this->profile->tablename_referrers} as r,{$this->profile->tablename_urlparams} as up where timestamp >=" . $db->quote(
                $this->from
            ) . " and timestamp <=" . $db->quote(
                $this->to
            ) . " and (r.referrer like \\",
            $this->trafficsource
        );

        $query .= subsetDataToSourceID(
            "select \"Yahoo\" referrer, count(distinct sessionid) as visits, count(*) as hits, count(distinct visitorid) as visitors from  {$this->profile->tablename} as a, {$this->profile->tablename_referrers} as r where timestamp >=" . $db->quote(
                $this->from
            ) . " and timestamp <=" . $db->quote(
                $this->to
            ) . " and r.referrer like \"%search.yahoo.%\" and a.referrer=r.id union ",
            $this->trafficsource
        );

        $query .= subsetDataToSourceID(
            "select \"Bing\" referrer, count(distinct sessionid) as visits, count(*) as hits, count(distinct visitorid) as visitors from {$this->profile->tablename} as a, {$this->profile->tablename_referrers} as r where timestamp >=" . $db->quote(
                $this->from
            ) . " and timestamp <=" . $db->quote(
                $this->to
            ) . " and r.referrer like \"%bing.com/%\" and a.referrer=r.id union ",
            $this->trafficsource
        );

        $query .= subsetDataToSourceID(
            "select \"AOL Search\" referrer, count(distinct sessionid) as visits, count(*) as hits, count(distinct visitorid) as visitors from {$this->profile->tablename} as a, {$this->profile->tablename_referrers} as r where timestamp >=" . $db->quote(
                $this->from
            ) . " and timestamp <=" . $db->quote(
                $this->to
            ) . " and r.referrer like \"%search.aol.%\" and a.referrer=r.id union ",
            $this->trafficsource
        );

        $query .= subsetDataToSourceID(
            "select \"Ask.com\" referrer, count(distinct sessionid) as visits, count(*) as hits, count(distinct visitorid) as visitors from {$this->profile->tablename} as a, {$this->profile->tablename_referrers} as r where timestamp >=" . $db->quote(
                $this->from
            ) . " and timestamp <=" . $db->quote(
                $this->to
            ) . " and r.referrer like \"%.ask.com%\" and a.referrer=r.id union ",
            $this->trafficsource
        );

        $query .= subsetDataToSourceID(
            "select \"Dogpile.com\" referrer, count(distinct sessionid) as visits, count(*) as hits, count(distinct visitorid) as visitors from {$this->profile->tablename} as a, {$this->profile->tablename_referrers} as r where timestamp >=" . $db->quote(
                $this->from
            ) . " and timestamp <=" . $db->quote(
                $this->to
            ) . " and r.referrer like \\",
            $this->trafficsource
        );

        $query .= subsetDataToSourceID(
            "select \"Baidu.com\" referrer, count(distinct sessionid) as visits, count(*) as hits, count(distinct visitorid) as visitors from {$this->profile->tablename} as a, {$this->profile->tablename_referrers} as r where timestamp >=" . $db->quote(
                $this->from
            ) . " and timestamp <=" . $db->quote(
                $this->to
            ) . " and r.referrer like \"%www.baidu.com%\" and a.referrer=r.id union ",
            $this->trafficsource
        );

        $query .= subsetDataToSourceID(
            "select \"Naver\" referrer, count(distinct sessionid) as visits, count(*) as hits, count(distinct visitorid) as visitors from {$this->profile->tablename} as a, {$this->profile->tablename_referrers} as r where timestamp >=" . $db->quote(
                $this->from
            ) . " and timestamp <=" . $db->quote(
                $this->to
            ) . " and r.referrer like \"%search.naver.com%\" and a.referrer=r.id union ",
            $this->trafficsource
        );

        $query .= subsetDataToSourceID(
            "select \"Yandex\" referrer, count(distinct sessionid) as visits, count(*) as hits, count(distinct visitorid) as visitors from {$this->profile->tablename} as a, {$this->profile->tablename_referrers} as r where timestamp >=" . $db->quote(
                $this->from
            ) . " and timestamp <=" . $db->quote(
                $this->to
            ) . " and (r.referrer like \"%www.yandex.com%\" or r.referrer like '%ya.ru%') and a.referrer=r.id ",
            $this->trafficsource
        );

        $query .= " order by visits desc";

        $this->applytrafficsource = false;

        //echo $query;
        return $query;
    }

    function UpdateStats($from = '', $to = '', $print = 2)
    {
        # because the query takes too long
        return false;
    }

    function DisplayReport()
    {
        if ($this->displaymode == "pie") {
            parent::DisplayReport();
        } else {
            $this->ReportHeader();

            $data = $this->GetReportData();

            foreach ($data as $key => $row) {
                if ($row[1] == 0) {
                    unset($data[$key]);
                    continue;
                }
                $data[$key][0] = '<a class=\'open_in_new_dialog quickopen\' href=\'reports.php?conf=' . $this->profile->profilename . '&labels=_DETAILED_SEARCH_ENGINES&se=' . $row[0] . '\' rel=\'DetailedSearchEngines\' type=\'_DETAILED_SEARCH_ENGINES\' name=\'' . _DETAILED_SEARCH_ENGINES . '\'>' . str_replace(
                        "[G]",
                        "<img src='images/google.png' border='0' />",
                        $row[0]
                    ) . '</a>';
            }

            $this->Table($data);
        }
    }

    function GetReportData()
    {
        $d = parent::GetReportData();
        $data = [];
        $i = 0;
        foreach ($d as $k => $v) {
            $data[$i][0] = $d[$i][0];
            $data[$i][1] = $d[$i][1];
            $data[$i][2] = $d[$i][2];
            if (isset($d[$i][2]) % isset($d[$i][1]) != 0) {
                $data[$i][3] = $d[$i][2] / $d[$i][1];
            } else {
                $data[$i][3] = 0;
            }
            $i++;
        }
        return $data;
    }

    function AggregateFixData($data, $num_profiles)
    {
        foreach ($data as $k => $val) {
            if ($data[$k][2] % $data[$k][1] != 0) {
                $data[$k][3] = $data[$k][2] / $data[$k][1];
            } else {
                $data[$k][3] = 0;
            }
        }
        return $data;
    }
}
