<?php

/**
* @desc This report displays a overview of your performance trends
*/
$reports["_PERFORMANCE_TRENDS"] = Array(
	"ClassName" => "PerformanceTrends", 
	"Category" => "_PERFORMANCE",
	"canAggregate" => false,  
	"icon" => "images/icons/32x32/performancetrends.png",
	"Options" => "daterangeField,profileselector,trafficsource,displaymode,period,limit",
	"Filename" => "performance_trends",
	"Distribution" => "Premium",
	"Order" => 1,
	"ReportVersion" => 1.0,
	"MinimumVersion" => 3.0,
	"EmailAlerts" => false,
	"Update" => false
);

class PerformanceTrends extends Report {

	function Settings() {		
		$this->DefaultDisplay = "areachart";
		$this->DisplayModes = "table,linechart,areachart";
		$this->help = "";
		$this->displayReportButtons = false;
		$this->remove_outputmodes = array("xml");
		$this->actionmenu_type = 'page';
		if ($this->period!='auto') {
			$this->addlabel .= _GROUP_BY ." ".constant($this->period);
		}		
		
		if(empty($this->conversion_mode)) {
			$this->conversion_mode = _CONVERTED_VISITORS;
		}
		$this->addlabel .= " | ".$this->conversion_mode;
		if ($this->conversion_mode == _CONVERTED_VISITORS) {
			$this->chartoptions = array("stacked_graph_style" => "stack", "stacked_showcontrols" => true, "showlegend" => false);
		} else {
			$this->chartoptions = array("stacked_graph_style" => "stack", "stacked_showcontrols" => true, "showlegend" => false, "yFormat" => ",.2f");
		}
		$this->highlight="Thu, 01/19/2017";
		
	}
	
	function getReportData(){
		global $reports;
		$r = new $reports["_OVERALL_PERFORMANCE"]["ClassName"]();
		$r->dataCollectType = "days";
		$r->createDataFiles($this->from,$this->to);	
		$data = $r->getTrendDataFromFiles($r->DataFiles($this->from,$this->to));
		
		$newdata = [];	
		
		$i = 0;
		foreach($data as $k => $v){
			$date = mktime(0,0,0,substr($k,4,-2),substr($k,6,7),substr($k,0,4));
			$date = date("D, m/d/Y",$date);
			if(empty($v)) { continue; }
			foreach($v as $ck => $cv){
				$url = $cv[0];
				$newdata[$i][0] = $date; # Date
				$newdata[$i][1] = $cv[0]; # Url
				if($this->conversion_mode == _CONVERTED_VISITORS) {
					$newdata[$i][2] = $cv[1]; # Requests
					$newdata[$i][3] = $cv[2]; # Converted Visitors
				} else {
					$newdata[$i][2] = $cv[2]; # Converted Visitors
					$newdata[$i][3] = $cv[3]; # Conversion Rate
				}
				
				$i ++;
			}
		}
		
		$data = $this->seriesToColumns($newdata);

		if(empty($data)){
			return $this->EmptyTrendData();
		}
		foreach($data['fields'] as $key => $val) { 
			$this->columnDefinitions[] = array("Label" => $val);
		}
		$this->setupColumnDefinitions();
		
		# create an empty seed array with the right dimensions
		$ncols = count($data['fields']);
		$nrows = $this->dateNumber($this->from, $this->to, $this->period);
		
		$seed_data = $this->newReportArray($nrows, $ncols);
		# add a date to he first value of each row.
		$seed_data = $this->AddDateToZeroArray($seed_data);

		# merge the actual results with the seed_data array
		foreach ($data['data'] as $key => $val) {			
			$day_id = $this->dateNumber($this->from,strtotime($key), $this->period);
			
			for ($i=0;$i<$ncols;$i++) {
				if (isset($val[$i])) {
					$seed_data[$day_id][$i] = $val[$i];
				}
			}		
		}	
		ksort($seed_data);
		
		return $seed_data;
	}
	
	
	function DisplayReport() {
		global $db;
		
		if (empty($this->profile->targetfiles)) {			
			echoNotice(_REPORT_NEEDS_KPI. "<br/><br/><a href='profile.php?conf={$this->profile->profilename}#_KPI' class='btn btn-default'>". _EDIT_PROFILE .": ". _KPI ."</a>", "margin:10px;");
			return;
		}
		
		# get the data from the database
		$data = $this->getReportData();

		$this->ReportHeader();
		
		if($this->displaymode == 'table') {
			$this->Table($data);
		} elseif($this->displaymode == 'areachart') {
			$this->StackedAreaChart2($data);

		} elseif($this->displaymode == 'linechart') {
			$this->LineChart($data);
		}
	}
	
	function DisplayCustomForm() {
		echo "<div class='form-group'>";
			echo "<label for='conversion_mode'>Show conversion as</label>";
			echo "<select id='conversion_mode' class='form-control' name='conversion_mode'>";
				if($this->conversion_mode == _CONVERSION_RATE) {
					echo "<option selected value='"._CONVERSION_RATE."'>"._CONVERSION_RATE."</option>";
				} else {
					echo "<option value='"._CONVERSION_RATE."'>"._CONVERSION_RATE."</option>";
				}
				
				if($this->conversion_mode == _CONVERTED_VISITORS) {
					echo "<option selected value='"._CONVERTED_VISITORS."'>"._CONVERTED_VISITORS."</option>";
				} else {
					echo "<option value='"._CONVERTED_VISITORS."'>"._CONVERTED_VISITORS."</option>";
				}
			echo "</select>";
		echo "</div>";
	}
	
	function UpdateStats($from = '', $to = '',$print = 2) {
		return false;		
	}
}
?>