<?php


$reports["_OPENCART_STATUSSES"] = Array(
	"ClassName" => "OpenCartStatusses",
	"Category" => "_OPENCART",
	"icon" => "images/icons/32x32/opencart.png",
	"Options" => "columnSelector",
	"Filename" => "oc_statusses",
	"Distribution" => "Premium",
	"Order" => 7,
	"ReportVersion" => 1.0,
	"MinimumVersion" => 3.0,
	"EmailAlerts" => false,
	"Update" => false
);
Class OpenCartStatusses extends Report{

	function Settings() {
		$this->columnDefinitions[] = array("Label" => _STATUS,"disableShowfieldsHandling" => true);
		$this->columnDefinitions[] = array("Label" => _ORDERS, "dataType" => 'String');
		$this->columnDefinitions[] = array("Label" => _TOTAL_REVENUE, "dataType" => 'String');
		$this->bchart[] = _ORDERS;
		if(empty($this->oc_store)) { $this->oc_store = '0'; }	
		$this->tableprefix = $this->profile->GetOtherSettings("externalConnection.prefix.openCartConnect", "");
	}
	
	function DefineQuery() {
		global $db;
		$query = "SELECT `name` AS status_name,
			(SELECT COUNT(order_status_id) FROM `{$this->tableprefix}order` WHERE order_status_id = os.order_status_id AND store_id = ". $db->Quote($this->oc_store) .") as orders,	
			FORMAT((SELECT SUM(total) FROM `{$this->tableprefix}order` WHERE order_status_id = os.order_status_id AND store_id = ". $db->Quote($this->oc_store) ."),2) as total,	

			os.order_status_id AS status_id,			
			(SELECT `code` from {$this->tableprefix}currency WHERE `value` = 1) as currency

			FROM `{$this->tableprefix}order_status` as os

			ORDER BY status_id";
		return $query;
	}
	
	function GetReportData() {		
			
		$connection = $this->checkExternalConnection("openCartConnect");
		if($connection == false){ echoNotice($this->SettingsButton()._CONNECTION_TO_DATABASE_FAILED); exit();  }
		
		$query = $this->DefineQuery();
		
		$result = mysql_query($query, $connection);
		$currency = "";
		$data = [];
		$i = 0;
		while($row = mysql_fetch_array($result)) {
			if(!empty($row['currency'])) {
				$currency = $row["currency"];
			}
			if(empty($row[0])) {
				continue;
			}			
			
			if(empty($row['total'])) {
				$row[2] = 0.00;
			}
			
			$data[$i][0] = $row[0];
			$data[$i][1] = $row[1];
			$data[$i][2] = $row[2];
			$i ++;
		}
		$this->addlabel = "All Time";
		$this->addlabel .= " | Currency: {$currency}";
		return $data;
	}
	
	function DisplayCustomForm() {
		global $session;
		$connection = $this->checkExternalConnection("openCartConnect");
		if($connection != false){		
			#GET STORES
			$query = "SELECT `store_id`,`name` FROM store";
			$result = mysql_query($query, $connection);
			
			echo "<div class='form-group'><label for='oc_store'>".'Store'."</label>";
			
			echo "<select id='oc_store' name='oc_store' class='form-control'>";
			
			echo "<option value='0'>".'Default Store'."</option>";
			while($row = mysql_fetch_assoc($result)) {
				if($row['store_id'] == $this->oc_store) {
					$selected = ' selected ';
				} else {
					$selected = '';
				}
				echo "<option value='{$row["store_id"]}' {$selected}>{$row["name"]}</option>";
			}
			echo "</select>";
			if($session->canEditProfiles()) {
				echo "<a data-title='"._VIEW_OPENCART_CONF."' href='definereport.php?conf={$this->profile->profilename}&testcenter=create&labels={$this->label_constant}&action=welcome' class='optionlink open_iframe_window'>"._VIEW_OPENCART_CONF."</a>";
			}
			echo "</div>";

		} else if($session->canEditProfiles()) {
			echo "<div class='form-group'><a data-title='"._VIEW_OPENCART_CONF."' href='definereport.php?conf={$this->profile->profilename}&testcenter=create&labels={$this->label_constant}&action=welcome' class='optionlink open_iframe_window'>"._VIEW_OPENCART_CONF."</a></div>";
		}
	}
	function DefineReport(){
		$this->externDbConnectForm("openCartConnect");	
	}
	function UpdateStats($from = '', $to = '',$print = 2) {
		return false;
	}
}