<?php

/**
* @desc This report displays the age of your facebook friends 
*/
$reports["_FACEBOOK_GENDER_AND_AGE"] = Array(
    "ClassName" => "FacebookPageGenderAge", 
    "Category" => "_FACEBOOK", 
    "icon" => "images/icons/32x32/fb_age.png",
	"Options" => "daterangeField,displaymode",
	"Filename" => "facebook_page_gender_and_age",
	"Distribution" => "Premium",
	"Order" => 10,
	"ReportVersion" => 4.0,
	"MinimumVersion" => 3.0,
	"EmailAlerts" => false,
	"Update" => false
);

class FacebookPageGenderAge extends FacebookCore {
	
	function Settings() {
		parent::Settings();
		$this->DisplayModes = "table,barchart";
		$this->DefaultDisplay = "barchart";
		if(empty($this->displaymode)){
			$this->displaymode = $this->DefaultDisplay;
		}

		$this->addlabel = _FACEBOOK_GENDER_AND_AGE_ADDLABEL;
		$this->help = _FACEBOOK_GENDER_AND_AGE_HELP;
	}

	function DisplayGraph(){
		?><script type="text/javascript">
		function lg_fb_<?php echo $this->graphID; ?>(container_id,result){
			if(result.Status == undefined || result.Status != "Success"){
				return;
			}

			var data = result.data;
			if(!data || data.values === undefined){
				console.log("No data");
				return;
			}	

			var lg_gr_m_data = [];
			var lg_gr_f_data = [];

			var lg_gr_m_ticks = [];
			var lg_gr_f_ticks = [];

			for (var i = 0; i < data.values.length; i++) {
				var row = data.values[i];

				var time = d3.time.format('<?php echo GetCustomDateFormat("D3"); ?>')(new Date(row.end_time));

				lg_gr_m_ticks.push(time);
				lg_gr_f_ticks.push(time);

				var m = 0;
				var f = 0;
				$.each(row.value, function(k,v){

					if(k.slice(0,1) == 'M'){
						if(lg_gr_m_data[m] == undefined){
							lg_gr_m_data[m] = {
								key : k.slice(2),
								values : [
									[i, v]
								]
							}
						} else {
							lg_gr_m_data[m].values.push({ x: i, y :v });
						}
						m ++;
					} else {
						if(lg_gr_f_data[f] == undefined){
							lg_gr_f_data[f] = {
								key : k.slice(2),
								values : [
									[i, v]
								]
							}
						} else {
							lg_gr_f_data[f].values.push({ x: i, y :v });
						}
						f ++;
					}
				});

			}

			$("#M"+container_id).attr("data-chart", JSON.stringify(lg_gr_m_data) );
			$("#F"+container_id).attr("data-chart", JSON.stringify(lg_gr_f_data) );


			$("#M"+container_id).attr("data-ticks", JSON.stringify(lg_gr_m_ticks) );
			$("#F"+container_id).attr("data-ticks", JSON.stringify(lg_gr_f_ticks) );
			
			lg.BarChart("M"+container_id, true);
			lg.BarChart("F"+container_id, true);
		}
		</script><?php
	}
    
	function DisplayTable(){
		?><script type="text/javascript">
		function lg_fb_<?php echo $this->graphID; ?>(container_id,result){
			if(result.Status == undefined || result.Status != "Success"){
				return;
			}

			var data = result.data;
			if(!data || data.values === undefined){
				console.log("No data");
				return;
			}	

			var dataSet = {};

			columnSet = [{ title: "Date" }];

			for (var i = 0; i < data.values.length; i++) {
				var row = data.values[i];

				var time = d3.time.format('<?php echo GetCustomDateFormat("D3"); ?>')(new Date(row.end_time));
	
				$.each(row.value, function(k,v){
					if(dataSet[time] == undefined){
						dataSet[time] = {};
					}
					dataSet[time][k] = v.toString();
				});
			}

			var d = [];
			var i = 0;
			$.each(dataSet, function(k, row){
				d[i] = [
					k
				];

				$.each(row, function(k,v){
					// Add columns
					if(i == 0){ columnSet.push({ title: k }); }
					// add value to data set
					d[i].push(v);
				});	
				i ++;
			});

			$("#" + container_id ).dataTable({
				data: d,
		        columns: columnSet,	
		        "iDisplayLength": d.length,	        
				"aaSorting": [],		
				"sDom": "t"
			});
		}
		</script>
		<?php
	}

	function DisplayReport(){
		# Set default appID if we have it stored in a COOKIE
		if(!empty($this->appID)){	
			$this->SaveAppID();			
		} else if(!empty($_COOKIE['lg_fb_appID'])){
			$this->SetAppID();
		}

		if(!empty($this->appID)){
			$parts = explode("[S]", $this->appID);
			$this->appID = $parts[0];
			$this->appName = $parts[1];
			$this->addlabel = $this->appName . " | " . $this->addlabel;
		}
		

		$this->reportHeader();
		
		if(empty($this->appID)){
			echoNotice($this->SettingsButton()._FACEBOOK_SELECT_APP_PAGE_WARNING);
			return false;
		}

		if($this->displaymode == "table"){
			echo "<table id='{$this->graphID}' class='dataTable js_filled_datatable report_table' cellspacing=0 cellpadding=2 border=0 width='100%'></table>";
			$this->DisplayTable();
		} else {
			echo "<h3 style='width:100%; text-align:center;'>Male</h3><div id='M{$this->graphID}'></div>";
			echo "<h3 style='width:100%; text-align:center;'>Female</h3><div id='F{$this->graphID}'></div>";
			$this->DisplayGraph();
		}

		echo "<script type='text/javascript' src='//facebook.logaholic.com/authorization/stats/?page={$this->appID}&m=age&from={$this->from}&to={$this->to}&id=$this->graphID'></script>";	
	}
}
?>