<?php

$reports["_ADWORDS_CLICKS_PER_DAY"] = Array(
	"ClassName" => "AdwordsClicksPerDay", 
	"Category" => "_ADVERTISING", 	
	"Options" => "daterangeField,displaymode,trafficsource,profileselector,columnSelector",
	"Filename" => "adwords_clicks_per_day",
	"Distribution" => "Standard",
	"Order" => 8,
	"ReportVersion" => 1.0,
	"MinimumVersion" => 3.0,
	"EmailAlerts" => true
);

class AdwordsClicksPerDay extends Report {
	function Settings() {
		$this->DisplayModes = "table,linechart,barchart";
		$this->DefaultDisplay = "table";
		if(empty($this->displaymode)){
			$this->displaymode = $this->DefaultDisplay;
		}

		$this->sort = false;		
		$this->columnDefinitions[] = Array("Label" => "_DATE");
		$this->columnDefinitions[] = Array("Label" => "_UNIQUE_VISITORS", "line_order" => 0);
		$this->columnDefinitions[] = Array("Label" => "_CLICKS", "line_order" => 2, "bchart" =>true);
		$this->columnDefinitions[] = Array("Label" => "_BOTS", "line_order" => 3);
		
		$this->columnDefinitions[] = Array("Label" => "CPU", "totalRow" => "avg", "line_order" => 4);
		$this->columnDefinitions[] = Array("Label" => "_VISITS", "line_order" => 1, "bchart" => false);
		$this->columnDefinitions[] = Array("Label" => "CPV", "totalRow" => "avg", "line_order" => 5);
		$this->barcolors = array("#9ecae1","#c6dbef");
		$this->help = _ADWORDS_CLICKS_DESC."<br><br>"._ADWORDS_CLICKS_PER_DAY_DESC;

	}
	function DefineQuery() {
		global $db;
		
		$tablename = $this->profile->tablename_merge;			
		
		$query = "SELECT FROM_UNIXTIME(a.timestamp, '%d-%b-%Y %a') AS days, COUNT(DISTINCT a.visitorid) as visitors, COUNT(*) AS clicks, concat(format((SUM(IF(crawl='1',1,'0'))/COUNT(*))*100,1),'%') as cp, (COUNT(*) / COUNT(DISTINCT a.visitorid)) AS ppv, COUNT(DISTINCT a.sessionid) AS visits, (COUNT(*) / COUNT(DISTINCT a.sessionid)) AS ppvs FROM {$tablename} as a, {$this->profile->tablename_urlparams} as u  WHERE a.timestamp >= ". $db->quote($this->from) ." AND a.timestamp <= ". $db->quote($this->to) ." and a.params=u.id and (u.params like '?gclid=%' or u.params like '%&gclid=%') GROUP BY days ORDER BY a.timestamp";
		
		return $query;
	}

	function UpdateStats($from = '', $to = '',$print = 2) {
		# because the query takes too long
		return false;		
	}


}
?>
