<?php

/**
 * @desc This report displays a overview of your top keywords
 */

$reports["_TRAFFIC_INFOGRAPHIC"] = [
    "ClassName" => "TrafficInfographic",
    "Category" => "_INFOGRAPHICS",
    "icon" => "images/icons/32x32/trendsoverview.png",
    "Options" => "daterangeField,profileselector",
    "Filename" => "traffic_infographic",
    "Distribution" => "Standard",
    "Order" => 3,
    "ReportVersion" => 1.0,
    "MinimumVersion" => 3.0,
    "hidden" => true,
    "EmailAlerts" => false,
    "Update" => false
];

class TrafficInfographic extends Report
{
    var $ndays;

    function UpdateStats($from = '', $to = '', $print = 2)
    {
        return false;
    }

    function Settings()
    {
        if (date("ymd", time()) == date("ymd", $this->to)) {
            $this->to = $this->to - 86400;
        }

        $this->from = mktime(0, 0, 0, date("m", $this->to), date("d", $this->to) - 6, date("Y", $this->to));
        $this->limit = 10;

        $calc = round(($this->to - $this->from) / 86400);
        $this->ndays = $calc;
    }

    function DisplayReport()
    {
        global $reports;
        $this->ReportHeader();

        $required_reports = [
            "_KEYWORD_TRENDS",
            "_REFERRER_TRENDS",
            "_TOP_KEYWORDS",
            "_TOP_REFERRERS",
            "_TRAFFIC_BREAKDOWN",
            "_SEARCH_ENGINES",
            "_VISITORS_PER_DAY",
            "_NEW_VS_RETURNING"
        ];

        $missing = "";
        foreach ($required_reports as $c) {
            if (empty($reports[$c])) {
                $missing .= "- " . constant($c) . " -";
            }
        }
        if (!empty($missing) && CheckForSubscriptionsUsage()) {
            echoNotice(
                _MISSING_TO_SEE_COMPLETE_REPORT . ":<br/>$missing<br/><a class='subscription_report' style='cursor:pointer;'>" . _OPEN_SUBSCRIPTION_DIALOG . "</a>",
                "margin:10px; text-align:center;"
            );
        }

        $averages = $this->AvgVisitorsBlockData();

        if (empty($reports["_KEYWORD_TRENDS"])) {
            $keywtrenddata = [];
        } else {
            $kt = new $reports["_KEYWORD_TRENDS"]["ClassName"]();
            $kt->displaymode = "areachart";
            $kt->limit = 5;
            $kt->chartoptions['stacked_showcontrols'] = false;
            $kt->from = $this->from;
            $kt->to = $this->to;
            $keywtrenddata = $kt->GetReportData();
        }

        if (empty($reports["_REFERRER_TRENDS"])) {
            $reftrenddata = [];
        } else {
            $rt = new $reports["_REFERRER_TRENDS"]["ClassName"]();
            $rt->displaymode = "areachart";
            $rt->chartoptions['stacked_showcontrols'] = false;
            $rt->chartoptions['stacked_graph_style'] = "stacked";
            $rt->limit = 5;
            $rt->from = $this->from;
            $rt->to = $this->to;
            $reftrenddata = $rt->GetReportData();
        }


        $keywords = [];
        if (!empty($reports["_TOP_KEYWORDS"])) {
            $tk = new $reports["_TOP_KEYWORDS"]["ClassName"]();
            $tk->label = _TOP_KEYWORDS;
            $tk->from = $this->from;
            $tk->to = $this->to;
            $tkdata = $tk->GetReportData();
            # Week before this week
            $tk->to = $this->from - 1;
            $tk->from = ($tk->to - (86400 * 7));
            $i = 0;
            if (!empty($tkdata)) {
                while ($i < 5) {
                    @$keywords[$tkdata[$i][0]]["hits"] = @$tkdata[$i][1];
                    $tk->searchmode = "equals";
                    $tk->search = @$tkdata[$i][0];
                    $keydata = $tk->GetReportData();
                    @$keywords[@$tkdata[$i][0]]["diff"] = (empty($keydata)) ? 0 : $keydata[0][1];
                    $i++;
                }
            }
        }

        $referrers = [];
        if (!empty($reports["_TOP_REFERRERS"])) {
            $tr = new $reports["_TOP_REFERRERS"]["ClassName"]();
            $tr->label = _TOP_REFERRERS;
            $tr->from = $this->from;
            $tr->to = $this->to;
            $trdata = $tr->GetReportData();
            # Week before this week
            $tr->to = $this->from - 1;
            $tr->from = ($tr->to - (86400 * 7));
            $i = 0;
            if (!empty($trdata)) {
                while ($i < 5) {
                    $referrers[$trdata[$i][0]]["hits"] = $trdata[$i][1];
                    $tr->searchmode = "equals";
                    $tr->search = $trdata[$i][0];
                    $refdata = $tr->GetReportData();
                    $referrers[$trdata[$i][0]]["diff"] = (empty($refdata)) ? 0 : $refdata[0][1];
                    $i++;
                }
            }
        }

        # Check if exist because this is not a basic report.
        if (!empty($reports["_TRAFFIC_BREAKDOWN"])) {
            $tb = new $reports["_TRAFFIC_BREAKDOWN"]["ClassName"]();
            $tb->label = _TRAFFIC_BREAKDOWN;
            $tb->from = $this->from;
            $tb->to = $this->to;
            $tb->displaymode = 'table';
            $trafficbreak = $tb->GetReportData();
            $tb->legendlabelstring = "'<span style=\"float:left;\">%t</span> <span style=\"float:right;\">  %v </span>'";
            $tb->legendstyle['container'] = "width: 95%; float: left; margin: 15px 0px 0px 0px;";
            $tb->legendstyle['legend'] = "width: 100%; display: block; clear: both;";
        }

        if (!empty($reports["_SEARCH_ENGINES"])) {
            $rse = new $reports["_SEARCH_ENGINES"]["ClassName"]();
            $rse->from = $this->from;
            $rse->to = $this->to;
            $rse->columnDefinitions[0]["displayMaxChars"] = 18;
            $search = $rse->GetReportData();
            $rse->legendlabelstring = "'<span style=\"float:left;\">%t</span> <span style=\"float:right;\">  %v </span>'";
            $rse->legendstyle['container'] = "width: 95%; float: left; margin: 15px 0px 0px 0px;";
            $rse->legendstyle['legend'] = "width: 100%; display: block; clear: both;";
        }
        ?>
        <div class="infograph-wrapper keyword-infograph-wrapper">
            <div class="infograph-row">
                <div class="visitor-block">
                    <div class="average-visitors">
                        <h1><?php
                            echo $averages["vpd"]; ?></h1>
                        <p><?php
                            echo _AVG_VISITORS; ?><br><?php
                            echo _PER_DAY; ?></p>
                    </div>
                    <div class="returning-new">
                        <div class="rotated">
                            <span><strong><?php
                                    echo $averages["returning"]; ?>%</strong> <?php
                                echo _RETURNING; ?><br><strong><?php
                                    echo $averages["new"]; ?>%</strong> <?php
                                echo _NEW; ?></span>
                        </div>
                    </div>
                    <div style="clear:both;"></div>
                    <div class="average-visitors-trend">
                        <h1><font color="<?php
                            echo $averages["trend"]["color"]; ?>"><?php
                                echo "{$averages["trend"]["data"]}"; ?></font></h1>
                        <p>
                            <?php
                            echo _COMPARED_TO_LAST_WEEK; ?>
                        </p>
                    </div>
                    <div class="returning-new">
                        <div class="">
							<span>
								<?php
                                echo $averages["trendsmile"]; ?>
                                <?php
                                echo $averages["trendarrow"]; ?>
							</span>
                        </div>
                    </div>
                </div>
                <div class="trend-block">
                    <h1><?php
                        echo _KEYWORDS; ?></h1>
                    <div class="infograph-graph" style="height:193px;">
                        <?php
                        if (!empty($kt)) {
                            $kt->StackedAreaChart2($keywtrenddata);
                        } ?>
                    </div>
                </div>
            </div>
            <div class="infograph-row">
                <div class="page-block"><?php
                    if (!empty($keywords)) { ?>
                        <table width="95%" border="0" class="top-table">
                            <tr>
                                <td style='border:0;'></td>
                                <td style='border:0;'></td>
                                <td style='border:0;' colspan="2">
                                    <div class='visitor-explain'><?php
                                        echo _VISITS; ?></div>
                                </td>
                            </tr>
                            <?php
                            $i = $kt->limit;
                            $ii = 0;
                            foreach ($keywords as $k => $v) {
                                $diff = ($v["hits"] - $v["diff"]);
                                if ($diff > 0) {
                                    $color = "green";
                                    $trend = "+{$diff}";
                                } else {
                                    $trend = "{$diff}";
                                    $color = "red";
                                }
                                echo "<tr>";
                                echo "<td style='width:15px;'><div class='page-legend' style='background:{$this->graphcolors[$ii]}'></div></td>";
                                echo "<td>{$k}</td>";
                                echo "<td>{$v["hits"]}</td>";
                                echo "<td><div style='color:{$color};'>({$trend})</div></td>";
                                echo "</tr>";
                                $i--;
                                $ii++;
                            }
                            ?>
                        </table>
                    <?php
                    } else {
                        echoNotice(_NO_DATA_IN_DATE_RANGE, "margin:10px;");
                    } ?></div>
            </div>
            <div class="infograph-row">
                <div class="divider">
                    <div class="divider1"></div>
                    <div class="divider2"><h1><?php
                            echo _FROM; ?></h1></div>
                    <div class="divider3"></div>
                </div>
            </div>
            <div class="infograph-row">
                <div class="duration">
                    <div class="visit-duration">
                        <h2><?php
                            echo _TRAFFIC_BREAKDOWN; ?></h2>
                        <div class="infograph-pie"><?php
                            if (!empty($reports["_TRAFFIC_BREAKDOWN"])) {
                                $tb->pieChart($trafficbreak, "south");
                            } else {
                                if (CheckForSubscriptionsUsage()) {
                                    # Report is not in this subscription
                                } else {
                                    if (LOGAHOLIC_BASE_EDITION == "cPanel Edition") {
                                        echoNotice(
                                            "The " . _TRAFFIC_BREAKDOWN . " report is not available in your <a target=_blank href='https://www.logaholic.com/'>Logaholic</a> version. Visit <a target=_blank href=https:///www.logaholic.com/'>www.logaholic.com</a> to check out our full featured editions!",
                                            "position:absolute; width:240px;margin-top: 70px;margin-left: 50px;border: 1px solid #0078AE;"
                                        );
                                        echo "<img style='margin-left: -40px;' src='images/infographics/trafficbreakdown_info_buy.png' />";
                                    } else {
                                        echoNotice(
                                            "The " . _TRAFFIC_BREAKDOWN . " report is not available in your <a target=_blank href='https://www.logaholic.com/'>Logaholic</a> yet. Visit <a target=_blank href=https:///store.logaholic.com/'>store.logaholic.com</a> to get it!",
                                            "position:absolute; width:240px;margin-top: 70px;margin-left: 50px;border: 1px solid #0078AE;"
                                        );
                                        echo "<img style='margin-left: -40px;' src='images/infographics/trafficbreakdown_info_buy.png' />";
                                    }
                                }
                            }
                            ?></div>
                    </div>
                    <div class="total-duration">
                        <h2><?php
                            echo _SEARCH_ENGINES; ?></h2>
                        <div class="infograph-pie"><?php
                            if (!empty($rse)) {
                                $rse->pieChart($search, "south");
                            } ?></div>
                    </div>
                </div>
            </div>
            <div class="infograph-row">
                <div class="divider">
                    <div class="divider1"></div>
                    <div class="divider2"><h1><?php
                            echo _REFERRERS; ?></h1></div>
                    <div class="divider3"></div>
                </div>
            </div>
            <div class="infograph-row referrers">
                <div class="refferer-trend-block">
                    <div class="ref-infograph-graph" style="height:213px;">
                        <?php
                        if (!empty($rt)) {
                            $rt->StackedAreaChart2($reftrenddata);
                        } ?>
                    </div>
                </div>
                <div class="page-block">
                    <table width="100%" border="0" class="top-table">
                        <tr>
                            <td style='border:0; width:15px;'></td>
                            <td style='border:0;'></td>
                            <td style='border:0;'>
                                <div class='visitor-explain'><?php
                                    echo _VISITS; ?></div>
                            </td>
                            <td style='border:0;'></td>
                        </tr>
                        <?php
                        $i = $rt->limit;
                        $ii = 0;
                        foreach ($referrers as $k => $v) {
                            $diff = ($v["hits"] - $v["diff"]);
                            if ($diff > 0) {
                                $color = "green";
                                $trend = "+{$diff}";
                            } else {
                                $trend = "{$diff}";
                                $color = "red";
                            }
                            echo "<tr>";
                            echo "<td style='width:15px;'><div class='page-legend' style='background:{$this->graphcolors[$ii]}'></div></td>";
                            echo "<td>{$k}</td>";
                            echo "<td>{$v["hits"]}</td>";
                            echo "<td><div style='color:{$color};'>({$trend})</div></td>";
                            echo "</tr>";
                            $i--;
                            $ii++;
                        }
                        ?>
                    </table>
                </div>
            </div>
        </div>
        <?php
    }

    function AvgVisitorsBlockData()
    {
        global $reports;
        $returndata = [];

        # Average Visitors Per Day
        $data = [];
        if (!empty($reports["_VISITORS_PER_DAY"])) {
            $vpd = new $reports["_VISITORS_PER_DAY"]["ClassName"]();
            $vpd->label = _VISITORS_PER_DAY;
            $vpd->from = $this->from - (86400 * 7);


            $vpd->period = "days";
            $vpd->to = $this->to;
            $data = $vpd->GetReportData();
        }

        $pageviews = 0;
        $prepageviews = 0;
        $visits = 0;
        $previsits = 0;
        $visitors = 0;
        $previsitors = 0;
        $i = 0;

        $ppu = 0;
        $prevppu = 0;

        foreach ($data as $set) {
            if ($i < 7) {
                $previsitors = $previsitors + $set[1];
                $prepageviews = $prepageviews + $set[2];
                $prevppu = $prevppu + $set[3];
                $previsits = $previsits + $set[4];
            } else {
                $visitors = $visitors + $set[1];
                $pageviews = $pageviews + $set[2];
                $ppu = $ppu + $set[3];
                $visits = $visits + $set[4];
            }
            $i++;
        }

        $days = $this->ndays;
        $diff = round(($visitors / $days) - ($previsitors / $days));
        $returndata["trend"]["color"] = ($diff < 0) ? "red" : "green";
        $returndata["trend"]["data"] = ($diff < 0) ? $diff : "+{$diff}";

        if ($returndata["trend"]["color"] == "red") {
            $returndata["trendarrow"] = "<img src='images/infographics/arrow_red.png' class='infograph-arrow' />";
            $returndata["trendsmile"] = "<img class='infograph-smiley' src='images/icons/smilleys/smilley_39.png' />";
        } else {
            $returndata["trendarrow"] = "<img src='images/infographics/arrow_green.png' class='infograph-arrow' />";
            $returndata["trendsmile"] = "<img class='infograph-smiley' src='images/icons/smilleys/smilley_01.png' />";
        }

        $returndata["vpd"] = round($visitors / $this->ndays);
        $returndata["visitspervisitor"]["prev"] = ($previsitors == 0) ? 0 : number_format(
            ($previsits / $previsitors),
            2
        );
        $returndata["visitspervisitor"]["now"] = ($visitors == 0) ? 0 : number_format(($visits / $visitors), 2);
        $returndata["visitspervisitor"]["color"] = (($returndata["visitspervisitor"]["now"] - $returndata["visitspervisitor"]["prev"]) < 0) ? "red" : "green";

        $ppu = number_format($ppu / $days, 2);
        $prevppu = number_format($prevppu / $days, 2);

        $returndata["pageviewspervisitors"]["prev"] = $prevppu;
        $returndata["pageviewspervisitors"]["now"] = $ppu;
        $returndata["pageviewspervisitors"]["color"] = (($returndata["pageviewspervisitors"]["now"] - $returndata["pageviewspervisitors"]["prev"]) < 0) ? "red" : "green";
        # New VS Returning
        $data = [];
        if (!empty($reports["_NEW_VS_RETURNING"])) {
            $newret = new $reports["_NEW_VS_RETURNING"]["ClassName"]();
            $newret->label = _NEW_VS_RETURNING;
            $newret->from = $this->from;
            $newret->period = "days";
            $newret->to = $this->to;
            $data = $newret->GetReportData();
        }

        $ret = 0;
        foreach ($data as $set) {
            # Returning
            $r = str_replace("%", "", $set[2]);
            $ret = $ret + $r;
        }

        $returndata["returning"] = round($ret / $this->ndays);
        $returndata["new"] = 100 - $returndata["returning"];
        return $returndata;
    }
}

?>
