<?php

/**
 * @desc This report displays the internal site search
 */
$reports["_INTERNAL_SITE_SEARCH"] = [
    "ClassName" => "InternalSiteSearch",
    "Category" => "_NAVIGATION",
    "icon" => "images/icons/32x32/internalsitesearch.png",
    "Options" => "daterangeField,profileselector,displaymode,trafficsource,internal_site_search,limit,columnSelector,search",
    "Filename" => "internal_site_search",
    "Distribution" => "Premium",
    "Order" => 4,
    "ReportVersion" => 1.0,
    "MinimumVersion" => 3.0,
    "EmailAlerts" => true,
    "canAggregate" => false
];

class InternalSiteSearch extends Report
{

    function Settings()
    {
        $this->DefaultDisplay = "table";
        $this->DisplayModes = "table,pie";
        $this->columnDefinitions[0] = ["Label" => _INTERNAL_KEYWORD];
        $this->columnDefinitions[1] = ["Label" => _VISITS];
        $this->columnDefinitions[2] = ["Label" => _REQUESTS];


        if (empty($this->internal_site_search) || (strpos($this->internal_site_search, "?") == false)) {
            $this->internal_site_search = $this->profile->GetOtherSettings("sitesearch", '');
        }
        if (!empty($this->internal_site_search)) {
            $searche = explode("?", $this->internal_site_search);
            $searchpage = $searche[0];
            if (isset($searche[1])) {
                # keep default definitions
            } else {
                $this->columnDefinitions = [["Label" => _INFO, "dataType" => "String"]];
            }
        } else {
            $this->columnDefinitions = [["Label" => _INFO, "dataType" => "String"]];
        }
        $this->help = _INTERNAL_SITE_SEARCH_DESC;
        $this->sort_order = SORT_DESC;
        $this->sort_key = 1;
        $this->fileNameExpension .= "." . md5($this->profile->GetOtherSettings("sitesearch", ""));
    }

    function DefineQuery()
    {
        global $session, $db;
        if (!empty($this->internal_site_search)) {
            $searche = explode("?", $this->internal_site_search);
            $searchpage = $searche[0];
            if (isset($searche[1])) {
                if (!empty($session) && $session->canEditProfiles()) {
                    $this->profile->SetOtherSettings("sitesearch", $this->internal_site_search);
                }
                $searchparam = $searche[1];
                $searchparamlen = strlen($searchparam);
                $searchparamlen2 = strlen($searchparam) + 2;


                //$query  = "select (SUBSTR(up.params,(LOCATE(". $db->Quote($searchparam) .",up.params)+$searchparamlen),(LOCATE('&',CONCAT(up.params,'&'))-$searchparamlen2))) as kw, count(distinct visitorid) as visitors,CONCAT(u.url,'?%$searchparam',(SUBSTR(up.params,(LOCATE(". $db->Quote($searchparam) .",up.params)+$searchparamlen),(LOCATE('&',CONCAT(up.params,'&'))-$searchparamlen2)))) from {$this->profile->tablename} as a,{$this->profile->tablename_urls} as u,{$this->profile->tablename_urlparams} as up where timestamp >=". $db->quote($this->from) ." and timestamp <=". $db->quote($this->to) ." and a.url=u.id and a.params=up.id and up.params like ". $db->Quote("%$searchparam%") ." and u.url = ". $db->Quote($searchpage) ." group by kw order by visitors desc";

                $db->Execute("SET @start = 0, @end = 0, @kw = 0;");
                $query = subsetDataToSourceID(
                    "select @start:=(LOCATE(" . $db->Quote(
                        $searchparam
                    ) . ",up.params)+$searchparamlen), @end:=(LOCATE('&',CONCAT(up.params,'&'),@start)-@start), @kw:=SUBSTR(up.params,@start,@end) as kew, count(distinct sessionid) as visits, count(*) as hits from {$this->profile->tablename} as a,{$this->profile->tablename_urls} as u,{$this->profile->tablename_urlparams} as up where timestamp >=" . $db->quote(
                        $this->from
                    ) . " and timestamp <=" . $db->quote(
                        $this->to
                    ) . " and a.url=u.id and a.params=up.id and up.params like " . $db->Quote(
                        "%$searchparam%"
                    ) . " and u.url = " . $db->Quote($searchpage) . " group by kew order by visits desc",
                    $this->trafficsource
                );
                $this->applytrafficsource = false;

                $query = "select ik.kew, ik.visits, ik.hits from ($query) as ik";
            } else {
                $query = "select \"" . _NO_QUESTION_MARK_WAS_FOUND_IN_YOUR_ENTRY . ".\"";
            }
        } else {
            $query = "select \"" . _NO_INTERNAL_SITE_SEARCH_FOUND . "\"";
        }

        return $query;
    }

    function DisplayReport()
    {
        if (empty($this->internal_site_search)) {
            $this->ReportHeader();
            echoNotice(
                $this->SettingsButton() . _PLEASE_PROVIDE_SEARCH . "<br><br>" . $this->help,
                "margin-left:15px;"
            );
            return;
        }
        parent::DisplayReport();
    }

    function UpdateStats($from = '', $to = '', $print = 2)
    {
        if (!empty($this->internal_site_search)) {
            if (empty($from)) {
                $from = $this->from;
            }
            if (empty($to)) {
                $to = $this->to;
            }
            $this->createDataFiles(
                mktime(0, 0, 0, date('m', $from), date('d', $from), date('Y', $from)),
                mktime(23, 59, 59, date("m", $to), date("d", $to), date("Y", $to)),
                2
            );
        }
        return false;
    }
}

