<?php

/**
 * @desc This report displays the country trends
 */
$reports["_COUNTRY_TRENDS"] = [
    "ClassName" => "CountryTrends",
    "Category" => "_LOCATIONS",
    "icon" => "images/icons/32x32/countrytrends.png",
    "Options" => "daterangeField,profileselector,country,trafficsource,period,displaymode,limit",
    "Filename" => "country_trends",
    "Distribution" => "Premium",
    "Order" => 4,
    "ReportVersion" => 1.0,
    "MinimumVersion" => 3.0,
    "EmailAlerts" => false,
    "Update" => false,
    "canAggregate" => true
];

class CountryTrends extends Report
{

    function Settings()
    {
        global $cnames;

        $this->DefaultDisplay = "areachart";
        $this->DisplayModes = "table,linechart,areachart";
        $this->help = "";
        $this->displayReportButtons = false;
        $this->remove_outputmodes = ["xml"];
        if (empty($this->period)) {
            $this->period = '_DAYS';
        }
        $this->chartoptions = [
            "stacked_graph_style" => "stack",
            "stacked_showcontrols" => true,
            "showlegend" => false
        ];

        if (isset($_REQUEST["country_name"])) {
            # country code unknown check on name..
            $flip = $cnames;
            $flip = array_flip($flip);
            $this->country = $flip[$_REQUEST["country_name"]];
        }

        if (!empty($_REQUEST["country"])) {
            $this->country = $_REQUEST["country"];
        }
        if (!empty($this->country)) {
            $this->addlabel = $cnames[$this->country];
        }

        $this->sort = false;

        // this is for the aggregation framework
        if (isset($this->limit)) {
            $this->limit_per_day = $this->limit;
        } else {
            $this->limit_per_day = 10;
        }
    }


    function GetReportData()
    {
        $data = $this->rawGetReportData();

        $data = $this->ConvertData($data);
        return $data;
    }

    function rawGetReportData()
    {
        global $reports;
        $r = new $reports["_TOP_COUNTRIES_CITIES"]["ClassName"]();
        $r->dataCollectType = "days";

        if (!empty($this->country)) {
            $r->country = $this->country;
            $r->Settings();
        }
        $r->createDataFiles($this->from, $this->to);
        $d = $r->getTrendDataFromFiles($r->DataFiles($this->from, $this->to));


        $data = [];
        foreach ($d as $k => $v) {
            $l = 0;
            if (empty($v)) {
                continue;
            }
            foreach ($v as $val) {
                if ($this->limit < 50 && $l > ($this->limit * 5)) {
                    break;
                } else {
                    if ($this->limit >= 50 && $l > ($this->limit * 2)) {
                        break;
                    }
                }
                if (strlen($k > 7)) {
                    $timestamp = mktime(0, 0, 0, substr($k, 4, -2), substr($k, 6, 7), substr($k, 0, 4));
                } else {
                    continue;
                }
                $country = $val[0];
                $visits = $val[1];

                # Define the chosen period / time unit
                if ($this->period == '_DAYS') {
                    $format = "D, m/d/Y";
                    $date = date($format, $timestamp);
                } else {
                    if ($this->period == '_WEEKS') {
                        $format = "Y-#W";
                        $date = date($format, $timestamp);
                        $date = str_replace("#", "W", $date);
                    } else {
                        if ($this->period == '_MONTHS') {
                            $format = "M Y";
                            $date = date($format, $timestamp);
                        }
                    }
                }

                if (isset($data[$country][$date])) {
                    $data[$country][$date] = $data[$country][$date] + $visits;
                } else {
                    $data[$country][$date] = $visits;
                }
                $l++;
            }
        }

        $temp_d = [];
        foreach ($data as $country => $v) {
            $temp_d[$country] = array_sum($v);
        }
        arsort($temp_d);

        $final = [];
        $i = 0;
        $l = 0;
        foreach ($temp_d as $country => $v) {
            if ($l > $this->limit) {
                break;
            }
            foreach ($data[$country] as $date => $visits) {
                $final[$i][0] = $date;
                $final[$i][1] = $country;
                $final[$i][2] = $visits;
                $i++;
            }
            $l++;
        }
        return $final;
    }

    function ConvertData($data = "")
    {
        global $db, $qd, $cnames;

        // if(empty($data)) {
        // 	$data = $this->GetReportData();
        // }

        # transform the data array to a column for each serie
        $data = $this->seriesToColumns($data);

        if (!$data) {
            return $this->EmptyTrendData();
        }

        foreach ($data['fields'] as $key => $countrycode) { // Convert country codes to countries
            if (isset($cnames[$countrycode])) {
                $countryname = $cnames[$countrycode];

                $data['fields'][$key] = $countryname;
                $this->columnDefinitions[] = ["Label" => $countryname];
            } else {
                $this->columnDefinitions[] = ["Label" => $countrycode];
            }
        }
        $this->setupColumnDefinitions();

        # create an empty seed array with the right dimensions
        $ncols = count($data['fields']);
        $nrows = $this->dateNumber($this->from, $this->to, $this->period);

        $seed_data = $this->newReportArray($nrows, $ncols);
        # add a date to he first value of each row.
        $seed_data = $this->AddDateToZeroArray($seed_data);

        # merge the actual results with the seed_data array
        foreach ($data['data'] as $key => $val) {
            if ($this->period == '_WEEKS') {
                $dparts = explode("-", $key);
                $year = mktime(0, 0, 0, 1, 1, $dparts[0]);
                $week = str_replace("W", "", $dparts[1]);

                $timestamp = (86400 * 7 * $week) + $year;
            } else {
                $timestamp = strtotime($key);
            }

            $day_id = $this->dateNumber($this->from, $timestamp, $this->period);

            for ($i = 0; $i < $ncols; $i++) {
                if (isset($val[$i])) {
                    $seed_data[$day_id][$i] = $val[$i];
                }
            }
        }
        ksort($seed_data);

        # now make sure the date column is properly filled
        foreach ($seed_data as $key => $value) {
            $value[0] = $this->getFormatDate(
                $this->period,
                ($this->from + (($key) * $this->getSeconds($this->period)))
            );
            $seed_data[$key] = $value;
        }

        return $seed_data;
    }

    function DisplayReport($hide_header = false)
    {
        global $gi;

        if (!isset($gi)) {
            // there is no data
            echo "<div class=\"lines\" id=\"countgraph\">";
            echoWarning(_NEED_GEO, "margin:10px;");
            echo "</div>";
        } else {
            parent::DisplayReport($hide_header);
        }
    }


    function UpdateStats($from = '', $to = '', $print = 2)
    {
        # not using datafiles yet
        return false;
    }
}

