<?php

$cssFiles = [
    "../../../components/bootstrap/css/bootstrap.min.css",
    "font-awesome-4.3.0/css/font-awesome.min.css",
    "jvectormap/jquery-jvectormap-1.2.2.css",
    "daterangepicker/daterangepicker-bs3.css",
    "datatables/dataTables.bootstrap.css",
    "../../../components/jquery/jqplot/jquery.jqplot.min.css",
    "ionslider/ion.rangeSlider.css",
    "ionslider/ion.rangeSlider.skinHTML5.css",
    "AdminLTE.css",
    "ui.css",
    "ui.responsive.css"
];


$buffer = "";
foreach ($cssFiles as $cssFile) {
    $buffer .= file_get_contents($cssFile);
}
// Remove comments
$buffer = preg_replace('!/\*[^*]*\*+([^/][^*]*\*+)*/!', '', $buffer);
// Remove space after colons
$buffer = str_replace(': ', ':', $buffer);
// Remove whitespace
$buffer = str_replace(["\r\n", "\r", "\n", "\t", '  ', '    ', '    '], '', $buffer);
// Enable GZip encoding.
ob_start("ob_gzhandler");
// Enable caching
header('Cache-Control: public');
// Expire in one day
header('Expires: ' . gmdate('D, d M Y H:i:s', time() + 86400) . ' GMT');
// Set the correct MIME type, because Apache won't set it for us
header("Content-type: text/css");
// Write everything out
echo($buffer);
