<?php

$reports["_UTM_LANDING_PAGES"] = [
    "ClassName" => "UtmLandingPages",
    "Category" => "_ADVERTISING",
    "Options" => "daterangeField,profileselector,displaymode,limit,search,columnSelector,human",
    "Filename" => "utm_landing_pages",
    "Distribution" => "Premium",
    "Order" => 5,
    "ReportVersion" => 1.0,
    "MinimumVersion" => 3.0,
    "EmailAlerts" => true
];

class UtmLandingPages extends Report
{

    function Settings()
    {
        //$this->datafiles=false;


        $this->DefaultDisplay = "sunburst";
        $this->DisplayModes = "sunburst,drilldown,table";
        if (empty($this->displaymode)) {
            $this->displaymode = $this->DefaultDisplay;
        }
        $this->columnDefinitions[] = ["Label" => "Page"];
        $this->columnDefinitions[] = ["Label" => "Campaign"];
        $this->columnDefinitions[] = ["Label" => "Source"];
        $this->columnDefinitions[] = ["Label" => "Meduim"];
        $this->columnDefinitions[] = ["Label" => "_PAGEVIEWS"];
        $this->columnDefinitions[] = ["Label" => "_VISITS"];
        $this->columnDefinitions[] = ["Label" => "key", "display" => false];

        $this->sort = false; // we do custom sorting for this report
        $this->key_col = 6;

        if (!isset($this->limit)) {
            $this->limit = 10;
        }
        $this->report_limit = $this->limit;
    }

    function DefineQuery()
    {
        global $db;

        if (isset($this->human) && $this->human == 1) {
            $tablename = $this->profile->tablename_merge;
        } else {
            $tablename = $this->profile->tablename;
        }

        $query = "select a.url, lg_getparam('utm_campaign',u.params) as camp, lg_getparam('utm_source',u.params) as src, lg_getparam('utm_medium',u.params) as medium, count(*) as hits, count(distinct sessionid) as visits, MD5(concat(a.url,lg_getparam('utm_campaign',u.params),lg_getparam('utm_source',u.params),lg_getparam('utm_medium',u.params))) as ky from {$tablename} as a, {$this->profile->tablename_urlparams} as u where timestamp >= " . $db->quote(
                $this->from
            ) . " and timestamp <= " . $db->quote(
                $this->to
            ) . " and a.params=u.id and u.params like '%utm_campaign=%' group by ky, a.url,u.params order by hits desc";

        $query = "select u.url, camp, src, medium, hits, visits, ky from ($query) as a, {$this->profile->tablename_urls} as u where a.url=u.id";

        return $query;
    }

    function DisplayReport()
    {
        $data = $this->GetReportData();
        //dump($data);
        $this->ReportHeader();
        $this->displayHeader = false;

        if (empty($data)) {
            echoNotice(_NO_DATA_FOR_THIS_DATE_RANGE, "margin: 10px;");
            return false;
        }
        if ($this->displaymode == "drilldown") {
            $collapsekeys = [0, 1, 2, 3];
            $sumkeys = [4, 5];

            $this->CollapseTable($data, $collapsekeys, $sumkeys);
            return;
        }
        if ($this->displaymode == "sunburst") {
            $this->collapsekeys = [0, 1, 2, 3];
            $this->sumkeys = [4, 5];

            $this->Sunburst($data);
            return;
        }

        $this->limit = 10000;
        $this->paginationPanel = true;
        $this->Table($data);
    }

    function GetReportData()
    {
        $this->limit = 10000;
        $data = parent::GetReportData();
        return $data;
    }

    function UpdateStats($from = '', $to = '', $print = 2)
    {
        # because the query takes too long
        return false;
    }
}


