<?php

$reports["_UTM_CONTENT"] = [
    "ClassName" => "UtmContent",
    "Category" => "_ADVERTISING",
    "Options" => "daterangeField,profileselector,displaymode,search,limit,columnSelector,human",
    "Filename" => "utm_content",
    "Distribution" => "Premium",
    "Order" => 7,
    "ReportVersion" => 1.0,
    "MinimumVersion" => 3.0,
    "EmailAlerts" => true
];

class UtmContent extends Report
{

    function Settings()
    {
        //$this->datafiles=false;

        $this->help = _UTM_DESC;
        $this->DefaultDisplay = "table";
        $this->DisplayModes = "table";
        $this->columnDefinitions[] = ["Label" => "Content", "actionmenu" => 'utm_content'];
        $this->columnDefinitions[] = ["Label" => "_PAGEVIEWS"];
        $this->columnDefinitions[] = ["Label" => "_VISITS"];
        $this->sort_key = 1;
        $this->sort_order = SORT_DESC;
    }

    function DefineQuery()
    {
        global $db;

        if (isset($this->human) && $this->human == 1) {
            $tablename = $this->profile->tablename_merge;
        } else {
            $tablename = $this->profile->tablename;
        }

        $query = "select lg_getparam('utm_content',u.params) as src, count(*) as hits, count(distinct sessionid) as visits from {$tablename} as a, {$this->profile->tablename_urlparams} as u where timestamp >= " . $db->quote(
                $this->from
            ) . " and timestamp <= " . $db->quote(
                $this->to
            ) . " and a.params=u.id and u.params like '%utm_content=%' group by src order by hits desc";

        return $query;
    }


    function UpdateStats($from = '', $to = '', $print = 2)
    {
        # because the query takes too long
        return false;
    }
}


