<?php

/**
 * @desc This report displays a graph where you can see how many tweets your account made with a daterange.
 */

$reports["_TWITTER_TOTAL_TWEETS"] = [
    "ClassName" => "TwitterTotalTweets",
    "Category" => "_TWITTER",
    "icon" => "images/icons/32x32/twitter_total_tweets.png",
    "Options" => "daterangeField,displaymode",
    "Filename" => "twitter_total_tweets",
    "Distribution" => "Premium",
    "Order" => 7,
    "ReportVersion" => 1.0,
    "MinimumVersion" => 3.0,
    "DeleteOutdatedFiles" => false,
    "EmailAlerts" => false
];

class TwitterTotalTweets extends TwitterCore
{

    function Settings()
    {
        parent::Settings();
        $this->columnDefinitions[] = ["Label" => _DATE];
        $this->columnDefinitions[] = [
            "Label" => "Total Tweets",
            "bchart" => true,
            "totalRow" => 'none',
            "dataType" => "String"
        ];
        $this->help = _TWITTER_FOLLOWERS_DESC;
        $this->DefaultDisplay = "table";
        $this->DisplayModes = "table,linechart";

        # overwrite the max and min from the db to get data even though the database does not has this..
        # Also set it to now so we can be sure it always only makes reports for today
        $this->dbMaximumDate = time();
        $this->dbMinimumDate = time();
    }

    function GetReportData()
    {
        $data = parent::GetReportData();
        $new_data = [];
        foreach ($data as $k => $row) {
            $new_data[$k][0] = $row[0];
            $new_data[$k][1] = $row[3];
        }
        return $new_data;
    }
}


