<?php

/**
 * @desc This report shows how many users follow you.
 */

$reports["_TWITTER_FOLLOWERS"] = [
    "ClassName" => "TwitterFollowers",
    "Category" => "_TWITTER",
    "icon" => "images/icons/32x32/twitter_followers.png",
    "Options" => "daterangeField,displaymode",
    "Filename" => "twitter_followers",
    "Distribution" => "Premium",
    "Order" => 5,
    "ReportVersion" => 1.0,
    "MinimumVersion" => 3.0,
    "DeleteOutdatedFiles" => false,
    "EmailAlerts" => false
];

class TwitterFollowers extends TwitterCore
{

    function Settings()
    {
        parent::Settings();
        $this->columnDefinitions[] = ["Label" => _DATE];
        $this->columnDefinitions[] = [
            "Label" => "Followers",
            "bchart" => true,
            "dataType" => "String",
            "totalRow" => 'none'
        ];
        $this->help = _TWITTER_FOLLOWERS_DESC;
        $this->DefaultDisplay = "table";
        //$this->sort_key = false;
        $this->DisplayModes = "table,linechart";

        # overwrite the max and min from the db to get data even though the database does not has this..
        # Also set it to now so we can be sure it always only makes reports for today
        $this->dbMaximumDate = time();
        $this->dbMinimumDate = time();
    }

    function GetReportData()
    {
        $data = parent::GetReportData();
        $new_data = [];
        foreach ($data as $k => $row) {
            $new_data[$k][0] = $row[0];
            $new_data[$k][1] = $row[1];
        }
        return $new_data;
    }
}


