<?php

/**
 * @desc This report displays graph that shows is how many tweets we make per day.
 */

$reports["_TWEETS_PER_DAY"] = [
    "ClassName" => "TweetsPerDay",
    "Category" => "_TWITTER",
    "icon" => "images/icons/32x32/tweets_per_day.png",
    "Options" => "daterangeField,columnSelector,displaymode",
    "Filename" => "tweets_per_day",
    "Distribution" => "Premium",
    "Order" => 3,
    "ReportVersion" => 1.0,
    "MinimumVersion" => 3.0,
    "DeleteOutdatedFiles" => false,
    "EmailAlerts" => false
];

class TweetsPerDay extends TwitterCore
{

    function Settings()
    {
        parent::Settings();
        $this->columnDefinitions[] = ["Label" => _DATE];
        $this->columnDefinitions[] = ["Label" => "Tweets", "bchart" => true, "dataType" => "String"];
        $this->help = _TWEETS_PER_DAY_DESC;
        $this->DefaultDisplay = "table";
        $this->DisplayModes = "table,linechart";

        # overwrite the max and min from the db to get data even though the database does not has this..
        # Also set it to now so we can be sure it always only makes reports for today
        $this->dbMaximumDate = time();
        $this->dbMinimumDate = time();
        # Change the from 1 day back so we can check if it is start data or not..

    }

    function GetReportData()
    {
        $reset_from = mktime(0, 0, 0, date("m", $this->from), date("d", $this->from) - 1, date("Y", $this->from));
        $this->createDataFiles($this->from, $this->to);
        $data = $this->getTrendDataFromFiles($this->dataFiles($reset_from, $this->to));

        if (empty($data) || count($data) < 2) {
            return [];
        }

        $new_data = [];

        $time = $this->from;
        while ($time <= $this->to) {
            $end_day = mktime(23, 59, 59, date("m", $time), date("d", $time), date("Y", $time));

            $new_data[date("Ymd", $time)][0][0] = date("d-M-Y D", $time);
            $new_data[date("Ymd", $time)][0][1] = 0;

            $time = $end_day + 1;
        }

        # Overwrite data
        foreach ($data as $date => $row) {
            $value = $row[0][3];
            if (!empty($data[$date - 1][0])) {
                $value = $row[0][3] - $data[$date - 1][0][3];
            }
            $new_data[$date][0][1] = $value;
        }

        $data = [];
        $i = 0;
        foreach ($new_data as $r) {
            $data[$i][0] = $r[0][0];
            $data[$i][1] = $r[0][1];
            $i++;
        }

        return $data;
    }


    function UpdateStats($from = '', $to = '', $print = 2)
    {
        return false;
    }
}

