<?PHP

/**
 * @desc This report displays a overview of your page analysis
 */
$reports["_PAGE_ANALYSIS"] = [
    "ClassName" => "PageAnalysis",
    "Category" => "_NAVIGATION",
    "icon" => "images/icons/32x32/pageanalysis.png",
    "Options" => "daterangeField,profileselector,limit",
    "Filename" => "page_analysis",
    "Distribution" => "Premium",
    "Order" => 1,
    "ReportVersion" => 1.0,
    "MinimumVersion" => 3.0,
    "EmailAlerts" => false,
    "Update" => false,
    "canAggregate" => false
];

class PageAnalysis extends Report
{

    function Settings()
    {
        $this->displayReportButtons = false;
        $this->remove_outputmodes = ["xml", "csv", "mail"];

        if (!isset($this->limit)) {
            $this->limit = 15;
        }

        if (!isset($this->use_parameters)) {
            $this->use_parameters = 0;
        }
        if (!isset($this->crawlerselect)) {
            $this->crawlerselect = 0;
        }

        if (empty($this->page)) {
            $this->page = '/';
        }
        if (strpos($this->page, "?") !== false) {
            $this->use_parameters = 1;
        } else {
            $this->page = urldecode($this->page);
        }

        if ($this->crawlerselect == 2) {
            $this->queryTable = $this->profile->tablename_merge;
            $this->addlabel .= " " . _HUMANS_AND_BOTS . "";
        } elseif ($this->crawlerselect == 1) {
            $this->queryTable = $this->profile->tablename_crawl;
            $this->addlabel .= " " . _BOTS_ONLY . "";
        } else {
            $this->queryTable = $this->profile->tablename;
            $this->addlabel .= " " . _HUMANS_ONLY . "";
        }

        if (empty($this->statuscodes)) {
            $this->statuscodes = "";
        } else {
            $this->statuscodes = str_replace(" ", "", $this->statuscodes);
            $this->addlabel .= ", " . _LANDING_PAGES_WITH_STATUS . ": $this->statuscodes";
        }

        $this->status_str = $this->MakeStatusSQL($this->statuscodes);

        if ($this->use_parameters == 1) {
            $p = explode("?", $this->page);
            $this->pageid = getID($p[0], "urls");
            if (isset($p[1])) {
                $this->paramid = getID("?" . $p[1], "urlparams");
            } else {
                //$this->paramid = getID("", "urlparams");
            }
        } else {
            $this->pageid = getID($this->page, "urls");
        }
    }

    function MakeStatusSQL($statuscodes = "")
    {
        global $db;

        if (empty($statuscodes)) {
            return "";
        }
        $status_array = explode(",", $statuscodes);
        $status_str = "and (";
        foreach ($status_array as $st) {
            $status_str .= " status=" . $db->Quote((int)$st) . " or";
        }
        $status_str = substr($status_str, 0, -3) . ")";
        return $status_str;
    }

    function DisplayReport()
    {
        if (empty($this->pageid)) {
            echoWarning("Page not found: " . $this->page);
            return;
        }

        $data = $this->GetReportData();

        $this->ReportHeader();

        ?>
        <style>
            .page_analysis_header {
                background: url("images/stripe-light.png") repeat scroll 0 0 #FFFFFF;
                border: 1px solid #9E9E9E;
            }

            .label1, .label2, .label3 {
                padding: 6px;
                font-size: 16px;
                text-align: right;
            }

            .patable {
                table-layout: fixed;
                width: 100%;
                white-space: nowrap;
                overflow: hidden;
                text-overflow: ellipsis;
            }

            .patable TD {
                padding: 4px;
                white-space: nowrap;
                overflow: hidden;
                text-overflow: ellipsis;
            }

            .patable TD:HOVER {
                background-color: #e0e0e0;
            }

            #from_refs DIV, #to_next DIV {
                margin: 0 auto;
                padding: 8px;
                font-size: 16px;
                text-align: center;
            }

            .tswitch {
                cursor: pointer;
            }

            .realnum {
                display: none;
            }
        </style>
        <script>
            $(".tswitch").on('click', function () {
                $(".realperc").toggle();
                $(".realnum").toggle();
            });
        </script>
        <?php
        echo "<div class='page_analysis_header'>";
        echo "<div class='col-md-6 col-lg-offset-3'>";


        echo "<table>";
        echo "<tr><td class='label1'>" . _PAGE . ":</td><td class='label1' colspan='2' style='text-align:left;'>" . $this->page;
        echo "</td></tr>";
        if (!empty($data['pagestats'][0][2])) {
            echo "<tr><td class='label1'>" . _PAGEVIEWS . ":</td><td class='label1'>" . $data['pagestats'][0][2] . "</td><td>";
            $this->echoSparkline($data['pagetrends'], 2);
            echo "</td></tr>";
        } else {
            echo "<tr><td class='label1'>" . _PAGEVIEWS . ":</td><td class='label1'>0</td><td></td></tr>";
        }

        if (!empty($data['pagestats'][0][1])) {
            echo "<tr><td class='label2'>" . _VISITS . ":</td><td class='label2'>" . $data['pagestats'][0][1] . "</td><td>";
            $this->echoSparkline($data['pagetrends'], 1);
            echo "</td></tr>";
        } else {
            echo "<tr><td class='label2'>" . _VISITS . ":</td><td class='label2'>0</td><td></td></tr>";
        }

        if (!empty($data['pagestats'][0]["visitors"])) {
            echo "<tr><td class='label3'>" . _UNIQUE_VISITORS . ":</td><td class='label3'>" . $data['pagestats'][0]["visitors"] . "</td><td>";
            if (isset($this->pageid)) {
                $this->echoSparkline($data['pagetrends'], 3);
            } else {
                $this->echoSparkline($data['pagetrends'], 4);
            }
            echo "</td></tr>";
        } else {
            echo "<tr><td class='label3'>" . _UNIQUE_VISITORS . ":</td><td class='label3'>0</td><td></td></tr>";
        }

        echo "</table>";
        echo "</div><br style='clear:both'>";
        echo "</div>";

        echo "<div id=from_refs style='width:49%;float:left;margin:1px;'><div class='tswitch' title=\"" . _CLICK_TO_SWITCH_VALUES . "\">" . _VISITORS_CAME_FROM . ":</div><table class='patable'>";
        foreach ($data['refs'] as $row) {
            $ctr = round((($row['visitors'] / $data['pagestats'][0]["visitors"]) * 100), 1) . "%";
            echo "<tr><td style='width:50px;' title=\"" . _PERC_VISITORS_CAME_FROM_HERE . "\"><span class='realperc'>{$ctr}</span><span class='realnum'>{$row['visitors']}</span></td><td title=\"{$row['referrer']}\n{$row['pageviews']} " . _PAGEVIEWS . "  |  {$row['visits']} " . _VISITS . "\">" . $this->PrettyRef(
                    $row
                ) . "</td></tr>";
        }
        echo "</table></div>";

        echo "<div id=to_next style='width:49%;float:right;margin:1px;'><div class='tswitch' title=\"" . _CLICK_TO_SWITCH_VALUES . "\">" . _VISITORS_WENT_TO . ":</div><table class='patable'>";
        foreach ($data['next'] as $row) {
            $ctr = round((($row['visitors'] / $data['pagestats'][0]["visitors"]) * 100), 1) . "%";
            echo "<tr><td style='width:50px;' title=\"" . _PERC_VISITORS_WENT_TO . "\"><span class='realperc'>{$ctr}</span><span class='realnum'>{$row['visitors']}</span></td><td title=\"{$row['furl']}\n{$row['pageviews']} " . _PAGEVIEWS . "  |  {$row['visits']} " . _VISITS . "\">" . $this->PrettyPage(
                    $row
                ) . "</td></tr>";
        }
        echo "</table></div><div style='clear:both;'>&nbsp;</div>";
    }

    # used in report and in in-page analytics

    function GetReportData()
    {
        # let's get all the data we need for this report and stick it it an array
        $data['refs'] = $this->getReferrers($this->page);
        $data['next'] = $this->getNextPages($this->page);
        $data['pagestats'] = $this->GetPageStats($this->page);
        $data['pagetrends'] = $this->GetPageTrends($this->page);

        return $data;
    }

    # used in report and in in-page analytics

    function getReferrers($page)
    {
        global $db;
        $data = [];


        if (empty($this->pageid)) {
            return $data;
        }
        $no = getID("-", "referrers");
        if (isset($this->paramid)) {
            $subquery = "select referrer,refparams,concat(referrer,'.',refparams) as furl, count(distinct sessionid) as visits, count(*) as pageviews, count(distinct visitorid) as visitors from {$this->queryTable} where timestamp between " . $db->quote(
                    $this->from
                ) . " and " . $db->quote($this->to) . " and url = " . $db->quote(
                    $this->pageid
                ) . " and params = " . $db->quote(
                    $this->paramid
                ) . " group by furl order by visitors desc limit " . (int)$this->limit;
            $query = "select concat(r.referrer,rp.params) as referrer, visits, pageviews, visitors from ($subquery) as a, {$this->profile->tablename_referrers} as r,{$this->profile->tablename_refparams} as rp where a.referrer = r.id and a.refparams = rp.id";
        } else {
            if ($this->use_parameters == 1) {
                $subquery = "select referrer,refparams,concat(referrer,'.',refparams) as furl, count(distinct sessionid) as visits, count(*) as pageviews, count(distinct visitorid) as visitors from {$this->queryTable} where timestamp between " . $db->quote(
                        $this->from
                    ) . " and " . $db->quote($this->to) . " and url = " . $db->quote(
                        $this->pageid
                    ) . " and referrer != " . $db->quote(
                        $no
                    ) . " group by referrer order by visitors desc limit " . (int)$this->limit;
                $query = "select concat(r.referrer,rp.params) as referrer, visits, pageviews, visitors from ($subquery) as a, {$this->profile->tablename_referrers} as r,{$this->profile->tablename_refparams} as rp where a.referrer = r.id and a.refparams = rp.id";
            } else {
                $subquery = "select referrer, count(distinct sessionid) as visits, count(*) as pageviews, count(distinct visitorid) as visitors from {$this->queryTable} where timestamp between " . $db->quote(
                        $this->from
                    ) . " and " . $db->quote($this->to) . " and url = " . $db->quote(
                        $this->pageid
                    ) . " and referrer != " . $db->quote(
                        $no
                    ) . " group by referrer order by visitors desc limit " . (int)$this->limit;
                $query = "select r.referrer, visits, pageviews, visitors from ($subquery) as a, {$this->profile->tablename_referrers} as r where a.referrer = r.id";
            }
        }

        $result = $db->Execute($query);
        $data = $result->Getarray();
        //echo $query;
        return $data;
    }

    # this function is only used in in-page analytics

    function getNextPages($page)
    {
        global $db;
        $data = [];
        # first get the id we need

        if (isset($this->paramid)) {
            $p = explode("?", $page);
            $pageid = getID("https://" . $this->profile->confdomain . $p[0], "referrers");
            $paramid = getID("?" . $p[1], "refparams");
        } else {
            $pageid = getID("https://" . $this->profile->confdomain . $page, "referrers");
        }

        if (empty($pageid)) {
            return $data;
        }

        if (isset($this->paramid)) {
            $subquery = "select url,params,concat(url,'.',params) as furl, count(distinct sessionid) as visits, count(*) as pageviews, count(distinct visitorid) as visitors from {$this->queryTable} where timestamp between " . $db->quote(
                    $this->from
                ) . " and " . $db->quote($this->to) . " and referrer = " . $db->quote(
                    $pageid
                ) . " and refparams = " . $db->quote(
                    $paramid
                ) . " {$this->status_str} group by furl order by visitors desc limit " . (int)$this->limit;
            $query = "select concat(u.url,up.params) as furl, visits, pageviews, visitors from ($subquery) as a, {$this->profile->tablename_urls} as u,{$this->profile->tablename_urlparams} as up where a.url = u.id and a.params = up.id";
        } else {
            if ($this->use_parameters == 1) {
                $subquery = "select url,params,concat(url,'.',params) as furl, count(distinct sessionid) as visits, count(*) as pageviews, count(distinct visitorid) as visitors from {$this->queryTable} where timestamp between " . $db->quote(
                        $this->from
                    ) . " and " . $db->quote($this->to) . " and referrer = " . $db->quote(
                        $pageid
                    ) . " {$this->status_str} group by url order by visitors desc limit " . (int)$this->limit;
                $query = "select concat(u.url,up.params) as furl, visits, pageviews, visitors from ($subquery) as a, {$this->profile->tablename_urls} as u,{$this->profile->tablename_urlparams} as up where a.url = u.id and a.params = up.id";
            } else {
                $subquery = "select url, count(distinct sessionid) as visits, count(*) as pageviews, count(distinct visitorid) as visitors from {$this->queryTable} where timestamp between " . $db->quote(
                        $this->from
                    ) . " and " . $db->quote($this->to) . " and referrer = " . $db->quote(
                        $pageid
                    ) . " {$this->status_str} group by url order by visitors desc limit " . (int)$this->limit;
                $query = "select u.url as furl, visits, pageviews, visitors from ($subquery) as a, {$this->profile->tablename_urls} as u where a.url = u.id";
            }
        }

        $result = $db->Execute($query);
        $data = $result->Getarray();

        return $data;
    }

    function GetPageStats($page)
    {
        global $db;
        $data = [];

        //if ($this->use_parameters ==1 && isset($this->paramid)) {
        if (isset($this->paramid)) {
            #top pages details is what we need

            $tp = new TopPagesDetails();
            $tp->search = $page;
            $tp->searchmode = "equals";
            $query = $tp->DefineQuery();

            $query = str_replace(
                "group by numfurl",
                "and url = " . $db->Quote($this->pageid) . " and params=" . $db->Quote(
                    $this->paramid
                ) . " group by numfurl",
                $query
            );

            if ($this->crawlerselect == 0) {
            } else {
                if ($this->crawlerselect == 1) {
                    $query = str_replace(
                        $this->profile->tablename . " ",
                        $this->profile->tablename_crawl . " ",
                        $query
                    );
                } else {
                    $query = str_replace(
                        $this->profile->tablename . " ",
                        $this->profile->tablename_merge . " ",
                        $query
                    );
                }
            }
        } else {
            $tp = new TopPages();
            $tp->search = $page;
            $tp->searchmode = "equals";
            $query = $tp->DefineQuery();
            $query = str_replace("group by url", "and url = " . $db->Quote($this->pageid) . " group by url", $query);

            if ($this->crawlerselect == 0) {
            } else {
                if ($this->crawlerselect == 1) {
                    $query = str_replace(
                        $this->profile->tablename . " ",
                        $this->profile->tablename_crawl . " ",
                        $query
                    );
                } else {
                    $query = str_replace(
                        $this->profile->tablename . " ",
                        $this->profile->tablename_merge . " ",
                        $query
                    );
                }
            }
        }
        //echo $query;
        $q = $db->Execute($query);
        $data = $q->Getarray();
        //echoWarning($query);
        //dump($data);
        return $data;
    }

    function GetPageTrends($page)
    {
        global $db;
        $data = [];
        # We can get the info we need from the Top Pages datafiles

        if (isset($this->paramid)) {
            $tp = new TopPagesDetails();
        } else {
            $tp = new TopPages();
        }

        $tp->search = $page;
        $tp->searchmode = "equals";
        $tp->dataCollectType = "days";
        $tp->createDataFiles($this->from, $this->to);
        $data = $tp->getTrendDataFromFiles($tp->DataFiles($this->from, $this->to));
        //dump($data);
        return $data;
    }

    function echoSparkline($data, $k = 2)
    {
        global $get_constant;

        $sourcedata = [];
        $n = count($data) - 1;
        $i = 0;
        foreach ($data as $date => $row) {
            foreach ($row as $val) {
                $timestamp = mktime(0, 0, 0, substr($date, 4, -2), substr($date, 6, 7), substr($date, 0, 4));
                $format = "D, m/d/Y";
                $pdate = date($format, $timestamp);

                $sourcedata[$i][0] = $pdate;
                $sourcedata[$i][1] = $val[$k];
                $i++;
            }
        }
        $data = $sourcedata;

        if (empty($data)) {
            return false;
        }

        $trend = number_format(getTrend($data, 1), 0);
        if ($trend > 0) {
            $trend = "<span class=\'uptrend\'>+$trend</span>";
        } else {
            $trend = "<span class=\'downtrend\'>$trend</span>";
        }

        echo "<div class='sparkline hidden-xs'>";
        $data = $this->ConvertToSparklineData($data);
        $id = "id" . time() . rand(0, 1000);
        echo "<span id='$id' style='float:left;'>{$data['values']}</span>";
        echo "<script>";
        ?>
        $(function() {
        $("#<?php
        echo $id; ?>").sparkline('html', {
        width: '150px',
        tooltipFormat: '<span style="color: {{color}}">&#9679;</span> {{offset:names}}  ({{y}})',
        tooltipValueLookups: { names: { <?php
        echo $data['names']; ?> } }
        });
        });
        <?php
        echo "</script>";
        echo "<span style='padding-left:8px;'>($trend) </span>";
        echo "</div>";
    }

    function PrettyRef($row)
    {
        $pref = str_replace("https://", "", $row['referrer']);
        $pref = str_replace("https://", "", $pref);
        // if (strlen($pref) > 35) {
        // 	$pref = substr($pref, 0,35)."...";
        // }
        return "<a class='palink nodec2' onclick=\"popupActionMenu(event, '" . urlencode(
                $row['referrer']
            ) . "', 'referrer');\" href=\"\">{$pref}</a>";
    }

    function PrettyPage($row)
    {
        $purl = $row['furl'];
        // if (strlen($purl) > 35) {
        // 	$purl = substr($purl, 0,35)."...";
        // }
        return "<a class='palink' onclick=\"popupActionMenu(event, '" . urlencode(
                $row['furl']
            ) . "', 'page');\" href=\"\">{$purl}</a>";
    }

    # used in report, NOT in in-page

    function DisplayCustomForm()
    {
        global $ourpath, $db;

        echo "<script language='javascript' type='text/javascript'>";
        echo "	var conf_name=\"{$this->conf}\";";
        echo "	var from_date=" . $this->from . ";";
        echo "	var to_date=" . $this->to . ";";
        echo "</script>";

        echo "<div class='form-group'>";
        echo "<label for='page'>" . _PAGE . ":</label>";
        echo "<input class='report_option_field form-control' type='text' name='page' id='page' value='" . isset($this->page) . "' onkeyup=\"popupActionMenu(event, this.value+'@'+this.id+'@'+'page', 'forminput');\" onclick=\"popupActionMenu(event, this.value+'@'+this.id+'@'+'page', 'forminput');\">";
        echo "</div>";

        echo "<div class='form-group'>";
        echo "<label for='statuscodes' title='" . _ONLY_LANDING_PAGES_WITH_THESE_STATUS_CODES_WILL_BE_DISPLAYED . "'>" . _STATUS_CODES . ": </label>";
        echo "<input class='report_option_field form-control' type='text' title='i.e. 200, 302' id='statuscodes' name='statuscodes' value='" . @$this->statuscodes . "'>";
        echo "</div>";

        echo "<div class='form-group'>";
        echo "<label for=\"crawlerselect\">" . _TRAFFIC . ": </label>";
        echo "<select class='report_option_field form-control' id=\"crawlerselect\" name=\"crawlerselect\">";
        echo "<option ";
        if (isset($this->crawlerselect) && $this->crawlerselect == 2) {
            echo "selected='selected'";
        }
        echo " value='2'>" . _ALL_HUMANS_AND_BOTS . "</option>";
        echo "<option ";
        if (!isset($this->crawlerselect) || $this->crawlerselect == 0) {
            echo "selected='selected'";
        }
        echo " value='0'>" . _HUMANS_ONLY . "</option>";
        echo "<option ";
        if (isset($this->crawlerselect) && $this->crawlerselect == 1) {
            echo "selected='selected'";
        }
        echo " value=\"1\">" . _BOTS_ONLY . "</option>";
        echo "</select>";
        echo "</div>";

        echo "<div class='form-group'>";
        echo "<label>";
        echo "<input style='float:left;width:24px;height:0px;' class='noTextInput form-control' type='checkbox' value='1' name='use_parameters' id='use_parameters' ";
        if (isset($this->use_parameters) && $this->use_parameters == 1) {
            echo "checked>";
        } else {
            echo ">";
        }
        echo "<span>" . _EXPLAIN_PARAMETERS . "</span>";
        echo "</label>";
        echo "</div>";
    }

    # this function is only used in in-page analytics

    function DisplaySparkline()
    {
        $real_limit = $this->limit;
        $this->limit = 30;
        $data1 = $this->getReferrers($this->page);
        $data2 = $this->getNextPages($this->page);
        $this->limit = $real_limit;
        $data3 = $this->getKeywords($this->page);

        // $this->showfields = _KEYWORDS.","._VISITS;
        $this->columnDefinitions[0] = ["Label" => _KEYWORDS, "display" => true];
        $this->columnDefinitions[1] = ["Label" => _VISITS, "display" => true];
        $this->Sparkline($data3, "bar", "Incoming Keywords");
        // $this->showfields = _REFERRERS.","._VISITS;
        $this->columnDefinitions[0] = ["Label" => _REFERRERS, "display" => true];
        $this->columnDefinitions[1] = ["Label" => _VISITS, "display" => true];
        $this->Sparkline(array_slice($data1, 0, 10), "bar", "Incoming Referrers");
        // $this->showfields = _KEYWORDS.","._CLICKS;
        $this->columnDefinitions[0] = ["Label" => _KEYWORDS, "display" => true];
        $this->columnDefinitions[1] = ["Label" => _CLICKS, "display" => true];
        $this->Sparkline(array_slice($data2, 0, 10), "bar", "Outgoing Clicks");
    }

    # this function is only used in in-page analytics

    function getKeywords($page)
    {
        global $db;
        $data = [];
        # first get the id we need
        $pageid = getID($page, "urls");
        if (empty($pageid)) {
            return $data;
        }
        $no = getID("", "keyword");

        $subquery = "select keywords, count(distinct sessionid) as visits, count(*) as pageviews from {$this->profile->tablename} where timestamp between " . $db->quote(
                $this->from
            ) . " and " . $db->quote(
                $this->to
            ) . " and url = $pageid and keywords != $no group by keywords order by visits desc limit " . (int)$this->limit;
        $query = "select r.keywords, visits, pageviews from ($subquery) as a, {$this->profile->tablename_keywords} as r where a.keywords = r.id";
        $result = $db->Execute($query);
        $data = $result->Getarray();
        return $data;
    }

    function DisplayHeatBullets()
    {
        $this->limit = 100;
        # Wrap this all in a function
        echo "function DisplayHeatBullets(){";

        $data1 = $this->getReferrers($this->page);
        $click_data = $this->getNextPages($this->page);
        echo "var lgClicks = new [];";
        echo "var lgClickValues = new [];";

        $total = 0;
        foreach ($data1 as $k => $v) {
            $total = $total + $v[1];
        }
        echo "itotal=$total;";

        foreach ($click_data as $k => $v) {
            # save the value before making it a percentage.
            echo "lgClickValues[window.location.protocol + '//' + window.location.hostname + '{$v[0]}']= \"{$v[1]}\";\n";
            echo "lgClickValues['{$v[0]}']= \"{$v[1]}\";\n";
            $page = explode("/", $v[0]);
            $page = array_pop($page);
            echo "lgClickValues['{$page}']= \"{$v[1]}\";\n";

            # make the value a percentage.
            $v[1] = number_format(($v[1] / $total) * 100, 0);
            echo "lgClicks[window.location.protocol + '//' + window.location.hostname + '{$v[0]}']= \"{$v[1]}\";\n";
            echo "lgClicks['{$v[0]}']= \"{$v[1]}\";\n";
            $page = explode("/", $this->page);
            $page = array_pop($page);
            $location = str_replace($page, "", $this->page);

            $page = str_replace($location, "", $v[0]);
            echo "lgClicks['{$page}']= \"{$v[1]}\";\n";
        }
        # box-shadow: 0 0 "+maxradius+"px "+radius+"px #F26722;
        ?>
        var icount = 0;
        jQuery("a[href^=]").each(function() {

        if (lgClicks[jQuery(this).attr('href')] > 0) {
        if(jQuery(this).is(":visible")){
        dtop = Math.round(jQuery(this).offset().top).toFixed(0) - 10;
        dleft = Math.round(jQuery(this).offset().left).toFixed(0) - 10;

        var contentTop = parseInt(dtop + 19);
        var contentLeft = parseInt(dleft + 17);

        ctr = lgClicks[jQuery(this).attr('href')] + "%";
        var maxradius = 10;
        var radius = Math.round( (maxradius / 100) * lgClicks[jQuery(this).attr('href')]);
        jQuery("
        <div class='heatMapDot' rel='"+icount+"'
             style='line-height:15px; font-size:10px; color:#fff; padding:4px; border-radius:50%; background:url((lg_url)"images/heatmapbullet.png) repeat-x; border:1px solid #333; z-index:1000; height:15px; position:absolute;top:"(dtop)"px;left:"(dleft)"px;'>
            " + ctr + "
        </div>").prependTo("body");

        jQuery("
        <div class='heatMapDotContent' rel='"+icount+"'
             style='height:30px; display:none; text-align:left; font-size:10px; color:#EEEEEE; padding:12px 4px; box-shadow: 1px 1px 2px 0 #333; background:url((lg_url)images/heatmapbullet.png) repeat-x 0 0 / 100% 100%; border:1px solid #333; z-index:999; position:absolute;top:(contentTop)px;left:(contentLeft)px;'>
            Url: <a style='color:#FFF;' href='"+jQuery(this).attr(' href')+"'>"+jQuery(this).attr('href')+"</a><br/>Clicks:
            "+lgClickValues[jQuery(this).attr('href')]+"
        </div>").prependTo("body");
        }
        }
        icount ++;
        });
        <?php
        echo "}";
    }

    function UpdateStats($from = '', $to = '', $print = 2)
    {
        return false;
    }
}

?>