<?php

$reports["_OPENCART_TAXES"] = [
    "ClassName" => "OpenCartTaxes",
    "Category" => "_OPENCART",
    "icon" => "images/icons/32x32/opencart.png",
    "Options" => "daterangeField,columnSelector,displaymode",
    "Filename" => "oc_taxes",
    "Distribution" => "Premium",
    "Order" => 2,
    "ReportVersion" => 1.0,
    "MinimumVersion" => 3.0,
    "EmailAlerts" => false,
    "Update" => false
];

class OpenCartTaxes extends Report
{
    function Settings()
    {
        $this->DefaultDisplay = "table";
        $this->DisplayModes = "table,linechart";

        $this->columnDefinitions[] = ["Label" => _TAX_CLASS];
        $this->columnDefinitions[] = ["Label" => _TAXES];
        $this->columnDefinitions[] = ["Label" => _ORDERS];

        if (empty($this->order_status)) {
            $this->order_status = '0';
        }
        if (empty($this->oc_store)) {
            $this->oc_store = '0';
        }
        if (empty($this->order_status_name)) {
            $this->order_status_name = _ALL_STATUSSES;
        }
        $this->tableprefix = $this->profile->GetOtherSettings("externalConnection.prefix.openCartConnect", "");
    }

    function DisplayCustomForm()
    {
        global $session;
        $connection = $this->checkExternalConnection("openCartConnect");
        if ($connection != false) {
            #GET STORES
            $query = "SELECT `store_id`,`name` FROM store";
            $result = mysql_query($query, $connection);

            echo "<div class='form-group'><label for='oc_store'>" . 'Store' . "</label>";

            echo "<select id='oc_store' name='oc_store' class='form-control'>";

            echo "<option value='0'>" . 'Default Store' . "</option>";
            while ($row = mysql_fetch_assoc($result)) {
                if ($row['store_id'] == $this->oc_store) {
                    $selected = ' selected ';
                } else {
                    $selected = '';
                }
                echo "<option value='{$row["store_id"]}' {$selected}>{$row["name"]}</option>";
            }
            echo "</select>";
            if ($session->canEditProfiles()) {
                echo "<a data-title='" . _VIEW_OPENCART_CONF . "' href='definereport.php?conf={$this->profile->profilename}&testcenter=create&labels={$this->label_constant}&action=welcome' class='optionlink open_iframe_window'>" . _VIEW_OPENCART_CONF . "</a>";
            }
            echo "</div>";

            # GET ORDER STATUS
            $query = "SELECT DISTINCT(order_status_id) AS status_id, `name` AS status_name FROM `{$this->tableprefix}order_status` ORDER BY `name` ASC";

            $result = mysql_query($query, $connection);

            echo "<div class='form-group'>";
            echo "<label for='order_status'>" . _ORDER_STATUS . "</label>";
            echo "<input type='hidden' id='order_status_name' name='order_status_name' value='{$this->order_status_name}'>";

            echo "<select id='order_status' name='order_status' class='form-control'>";
            echo "<option value='0'>" . _ALL_STATUSSES . "</option>";
            while ($row = mysql_fetch_assoc($result)) {
                if ($row['status_id'] == $this->order_status) {
                    $selected = ' selected ';
                } else {
                    $selected = '';
                }
                echo "<option {$selected} value='{$row['status_id']}'>{$row['status_name']}</option>";
            }
            echo "</select>";
            echo "</div>";

            echo "<script type='text/javascript'>";
            echo "$('#order_status').change(function() {
					$('#order_status_name').attr('value', $(this).find('option[value=\"' + $(this).val() + '\"]').html());
				});";
            echo "</script>";
        } else {
            if ($session->canEditProfiles()) {
                echo "<div class='form-group'><a data-title='" . _VIEW_OPENCART_CONF . "' href='definereport.php?conf={$this->profile->profilename}&testcenter=create&labels={$this->label_constant}&action=welcome' class='optionlink open_iframe_window'>" . _VIEW_OPENCART_CONF . "</a></div>";
            }
        }
    }

    function GetReportData()
    {
        $data = [];
        $import = [];
        $connection = $this->checkExternalConnection("openCartConnect");
        if ($connection == false) {
            echoNotice($this->SettingsButton() . _CONNECTION_TO_DATABASE_FAILED);
            exit();
        }
        $query = $this->DefineQuery();

        $currency = "";
        $result = mysql_query($query, $connection);
        if (!$result) {
            return false;
        }

        while ($row = mysql_fetch_array($result)) {
            if (!empty($row['currency'])) {
                $currency = $row["currency"];
            }
            $data[] = $row;
        }
        mysql_close($connection);

        if (empty($this->order_status_name)) {
            $this->order_status_name = _ALL_STATUSSES;
        }

        $this->addlabel .= _ORDER_STATUS . ": {$this->order_status_name}";
        $this->addlabel .= " | Currency: {$currency}";
        return $data;
    }

    function DefineQuery()
    {
        global $db;
        if ($this->order_status != '0') {
            $sql = " AND o.order_status_id = " . $db->Quote($this->order_status);
        } else {
            $sql = " AND o.order_status_id > '0'";
        }

        if (!empty($this->from)) {
            $sql .= " AND DATE(o.date_added) >= '" . date('Y-m-d', $this->from) . "'";
        }

        if (!empty($this->to)) {
            $sql .= " AND DATE(o.date_added) <= '" . date('Y-m-d', $this->to) . "'";
        }


        $query = "SELECT ot.title as taxName, SUM(ot.value) AS taxTotal, 
			COUNT(o.order_id) AS `orders`,
			(SELECT `code` from {$this->tableprefix}currency WHERE `value` = 1) as currency
			FROM `{$this->tableprefix}order_total` ot LEFT JOIN `{$this->tableprefix}order` o ON (ot.order_id = o.order_id) WHERE o.store_id = " . $db->Quote(
                $this->oc_store
            ) . " AND ot.code = 'tax' {$sql} 
			GROUP BY ot.title LIMIT {$this->limit}";
        return $query;
    }

    function DefineReport()
    {
        $this->externDbConnectForm("openCartConnect");
    }

    function UpdateStats($from = '', $to = '', $print = 2)
    {
        return false;
    }
}

