<?php

/**
 * @desc This report displays the age of your facebook friends
 */
$reports["_FACEBOOK_GENDER"] = [
    "ClassName" => "FacebookPageGender",
    "Category" => "_FACEBOOK",
    "icon" => "images/icons/32x32/fb_age.png",
    "Options" => "daterangeField,displaymode,limit",
    "Filename" => "facebook_page_gender",
    "Distribution" => "Premium",
    "Order" => 9,
    "ReportVersion" => 4.0,
    "MinimumVersion" => 3.0,
    "EmailAlerts" => false,
    "Update" => false
];

class FacebookPageGender extends FacebookCore
{

    function Settings()
    {
        parent::Settings();
        $this->DisplayModes = "pie,areachart";
        $this->DefaultDisplay = "pie";
        if (empty($this->displaymode)) {
            $this->displaymode = $this->DefaultDisplay;
        }
        $this->addlabel = _FACEBOOK_GENDER_ADDLABEL;
        $this->help = _FACEBOOK_GENDER_HELP;
        $this->metric = "age";
    }

    function DisplayPie()
    {
        ?>
        <script type="text/javascript">
            function lg_fb_<?php echo $this->graphID; ?>(container_id, result) {
                if (result.Status == undefined || result.Status != "Success") {
                    return;
                }

                const data = result.data;
                if (!data || data.values === undefined) {
                    console.log("No data");
                    return;
                }

                const lg_gr_data = [["<?php echo _FB_MALE; ?>", 0], ["<?php echo _FB_FEMALE; ?>", 0]];

                const max = data.values.length - 1;
                const row = data.values[max];

                $.each(row.value, function (k, v) {
                    const g = k.slice(0, 1);

                    if (g == 'M') {
                        lg_gr_data[0][1] += parseInt(v);
                    } else {
                        lg_gr_data[1][1] += parseInt(v);
                    }
                });

                $("#" + container_id).attr("data", JSON.stringify(lg_gr_data));

                lg.Pie(container_id);
            }
        </script><?php
    }

    function DisplayGraph()
    {
        ?>
        <script type="text/javascript">
            function lg_fb_<?php echo $this->graphID; ?>(container_id, result) {
                if (result.Status == undefined || result.Status != "Success") {
                    return;
                }


                const data = result.data;
                if (!data || data.values === undefined) {
                    console.log("No data");
                    return;
                }

                let limit =;

                const dataSet = {};
                const graph_data = [];
                const columns = [];
                const xticks = [];
                let totalColumns = 0;
                const columnsCheck = {};

                for (let i = 0; i < data.values.length; i++) {
                    const row = data.values[i];

                    xticks.push(d3.time.format('<?php echo GetCustomDateFormat("D3"); ?>')(new Date(row.end_time)))

                    let ii = 0;

                    $.each(row.value, function (a, b) {
                        if (ii >= limit) {
                            return;
                        }
                        ii++;

                        if (dataSet[a] == undefined) {
                            dataSet[a] = {
                                key: a,
                                values: []
                            }
                            columns.push({"Label": a});
                        }

                        dataSet[a].values.push([i, parseInt(b)]);

                        columnsCheck[i] = 0;

                        if (totalColumns < dataSet[a].values.length) {
                            totalColumns = dataSet[a].values.length;
                        }
                    });

                }

                function LookForDate(date, values) {
                    let c = false;
                    $.each(values, function (k, v) {
                        if (parseInt(v[0]) == parseInt(date)) {
                            c = v[1];

                        }
                    });
                    return c;
                }

                $.each(dataSet, function (k, v) {
                    // we are missing columns for this record
                    if (v.values.length < totalColumns) {
                        // lets check all the columns
                        const n = [];
                        $.each(columnsCheck, function (a, b) {
                            const c = LookForDate(a, v.values);
                            if (c === false) {
                                n.push([parseInt(a), 0]);
                            } else {
                                n.push([parseInt(a), c]);
                            }
                        });
                        v.values = n;
                    }
                    graph_data.push(v);
                });

                $("#" + container_id).attr("data-ticks", JSON.stringify(xticks));
                $("#" + container_id).attr("data-coldefs", JSON.stringify(columns));

                $("#" + container_id).attr("data-chartoptions", JSON.stringify({
                    "stacked_graph_style": "expand", "stacked_showcontrols": true, "showlegend": false
                }));

                $("#" + container_id).attr("data-chart", JSON.stringify(graph_data));

                lg.StackedAreaChart(container_id);
            }
        </script><?php
    }
}

?>