<?php

/**
 * @desc This report displays the color palette
 */
$reports["_COLOR_PALETTE"] = [
    "ClassName" => "ColorPalette",
    "Category" => "_CLIENT_SYSTEM",
    "icon" => "images/icons/32x32/colorpalette.png",
    "Options" => "daterangeField,profileselector,displaymode,trafficsource,columnSelector",
    "Filename" => "color_palette",
    "Distribution" => "Standard",
    "Order" => 13,
    "ReportVersion" => 1.0,
    "MinimumVersion" => 3.0,
    "EmailAlerts" => false
];

class ColorPalette extends Report
{

    function Settings()
    {
        $this->DefaultDisplay = "table";
        $this->DisplayModes = "table,pie";
        $this->columnDefinitions[] = ["Label" => "_COLOR_DEPTH"];
        $this->columnDefinitions[] = ["Label" => "_PAGEVIEWS"];
        $this->sort_key = 1;
        $this->sort_order = SORT_DESC;
        // get logaholic.gif id
        $this->gifid = getID("/logaholic.gif", "urls");
        if ($this->gifid == false) {
            $this->gifid = 'false';
            return false;
        }

        global $profile;
        include "includes/codespace.php";
        $this->help = _COLOR_PALETTE_DESC . '<br><br>' . _GIFDATA_REPORT_DESC . "<br><br>" . _REPORT_NEEDS_GIFDATA . " " . _TAG_LOGFILES . "<br><br>" . $codespace2;
    }

    function DefineQuery()
    {
        global $db;

        if ($this->gifid == 'false') {
            return false;
        }

        $q = subsetDataToSourceID(
            "select CONVERT(lg_getparam('cd',u.params), SIGNED INTEGER) as cd from {$this->profile->tablename_gifdata} as a, {$this->profile->tablename_urlparams} as u where a.params=u.id and a.url={$this->gifid} and a.timestamp >= " . $db->quote(
                $this->from
            ) . " AND a.timestamp <= " . $db->quote($this->to) . " and u.params like '%&cd=%'",
            $this->trafficsource
        );

        $q = "select concat(cd, ' bit color'), count(*) hits from ($q) as a group by cd order by hits desc";

        $this->applytrafficsource = false;
        return $q;
    }

    function UpdateStats($from = '', $to = '', $print = 2)
    {
        return false;
    }
}


