<?php

/**
 * @desc This report displays a clicktrail
 */

$reports["_CLICK_TRAILS"] = [
    "ClassName" => "ClickTrail",
    "Category" => "_NAVIGATION",
    "icon" => "images/icons/32x32/clicktrails.png",
    "Options" => "daterangeField,trafficsource,profileselector,limit",
    "Filename" => "clicktrail",
    "Distribution" => "Premium",
    "Order" => 2,
    "ReportVersion" => 1.0,
    "MinimumVersion" => 3.0,
    "EmailAlerts" => false,
    "Update" => false,
    "canAggregate" => false
];

class ClickTrail extends Report
{

    function Settings()
    {
        $this->help = _CLICK_TRAILS_HELP;

        $this->displayReportButtons = false;
        $this->remove_outputmodes = ["all"];

        if (!empty($this->options)) {
            # this creates our search conditions array
            foreach ($this->options as $option => $val) {
                if (substr($option, 0, 5) == 'field') {
                    $condition_options['field'][] = $val;
                } elseif (substr($option, 0, 9) == 'condition') {
                    $condition_options['condition'][] = $val;
                } elseif (substr($option, 0, 6) == 'cvalue') {
                    $condition_options['cvalue'][] = $val;
                }
            }
            if (!empty($condition_options)) {
                $this->conditions = $condition_options;
            }

            # this creates a string of conditions to show to the user
            if (!empty($condition_options['condition'])) {
                for ($c = 0; $c <= (count($condition_options['condition']) - 1); $c++) {
                    $condition_options['cvalue'][$c] = urldecode($condition_options['cvalue'][$c]);
                    if (strlen($condition_options['cvalue'][$c]) >= 50) {
                        $cvalue_val = substr($condition_options['cvalue'][$c], 0, 23) . "..." . substr(
                                $condition_options['cvalue'][$c],
                                -23
                            );
                    } else {
                        $cvalue_val = $condition_options['cvalue'][$c];
                    }
                    if ($c != 0) {
                        $this->addlabel .= !empty($this->andor) ? " {$this->andor} " : " AND ";
                    }
                    $this->addlabel .= $this->addlabel ?? $condition_options['field'][$c] . " ";
                    $this->addlabel .= $this->addlabel ?? $condition_options['condition'][$c] . " ";
                    $this->addlabel .= $this->addlabel ?? $cvalue_val;
                }
            }
        }

        $this->dhistory = $this->dhistory ?? "daterange";
        $this->andor = $this->andor ?? "AND";
        $this->limit = $this->limit ?? "100";

        if (isset($this->submit)) {
            if (($this->submit == "Report") && (isset($this->filter_top))) {
                $this->filter = $_GET["filter_top"];
            }
        }

        if (!empty($this->visitorid)) {
            $this->addlabel .= " | visitor-id: {$this->visitorid}";
        }
    }

    function DisplayCustomForm()
    {
        $this->options = $_REQUEST;

        echo "<input type='hidden' name='ip' id='ip' value=\"" . isset($this->ip) . "\"> ";
        echo "<input type='hidden' name='visitorid' value=\"" . isset($this->visitorid) . "\"> ";

        $condition_options = [];
        foreach ($this->options as $option => $val) {
            if (substr($option, 0, 5) == 'field') {
                $condition_options['field'][] = $val;
            } elseif (substr($option, 0, 9) == 'condition') {
                $condition_options['condition'][] = $val;
            } elseif (substr($option, 0, 6) == 'cvalue') {
                $condition_options['cvalue'][] = $val;
            }
        }
        echo "<div class='form-group' style='max-width: 540px;'>";
        echo "<span style=\"margin-top:8px;\"><b>" . _SEARCH . ":</b></span>";

        if (isset($condition_options['condition']) && count($condition_options['condition']) > 1) {
            echo "<div class='andor_selector'>";
            echo "<span style='float: left; margin-right: 20px;'>Mode: </span>";
            if (empty($this->andor) || $this->andor == "AND") {
                echo "<label style='float: left;'>AND</label><input type='radio' class='noTextInput' style='width: 25px; float: left;' name='andor' value='AND' checked />";
            } else {
                echo "<label style='float: left;'>AND</label><input type='radio' class='noTextInput' style='width: 25px; float: left;' name='andor' value='AND' />";
            }
            if (!empty($this->andor) && $this->andor == "OR") {
                echo "<label style='float: left;'>OR</label><input type='radio' class='noTextInput' style='width: 25px; float: left;' name='andor' value='OR' checked />";
            } else {
                echo "<label style='float: left;'>OR</label><input type='radio' class='noTextInput' style='width: 25px; float: left;' name='andor' value='OR' />";
            }
            echo "</div>";
            echo "<div class='clear'></div>";
        }

        echo "<div class='condition_descriptor' style='clear:both;'>(" . _FIELD . ", " . _CONDITION . ", " . _VALUE . ")</div>";

        $form_id = md5(time()) . rand(1, 500);
        echo "<table id='{$form_id}' class='conditions table'>";
        if (count($condition_options) == 0) {
            $fieldselect = LoadFieldSelectFull();
            $fieldselect = SelectField($fieldselect, 'field1');

            echo "<tr class='conditions_row' style='margin:5px 0;'>";
            echo "<td><select src='field' class='form-control' id='field1' name='field1'>" . $fieldselect . "</select></td>";
            echo "<td><select src='condition' class='form-control' id='condition1' name='condition1'>";
            echo "	<option value=\"" . isset($this->condition1) . "\" selected>" . isset($this->condition1);
            echo "	<option value='is'>" . _SELECT_IS . "</option>";
            echo "	<option value='contains'>" . _CONTAINS . "</option>";
            echo "	<option value='nocontain'>" . _NOT_CONTAINS . "</option>";
            echo "	<option value='start'>" . _STARTS_WITH . "</option>";
            echo "	<option value='end'>" . _ENDS_WITH . "</option>";
            echo "	<option value='isnot'>" . _SELECT_IS_NOT . "</option>";
            echo "</select></td>";
            echo "<td><input class='form-control qbuilderhelp' src='cvalue' rel='1' name='cvalue1' id='cvalue1' value='" . isset($this->cvalue1) . "' autocomplete='off'></td>";
            echo "<td><button type='button' class='plus_btn noOption btn btn-default'> &plus; </button></td>
						<td><button type='button' class='min_btn noOption btn btn-default' disabled='disabled'> &minus; </button></td>";
            echo "</tr>";
        } else {
            for ($c = 0; $c < count($condition_options['condition']); $c++) {
                $fieldselect = LoadFieldSelectFull();
                $fieldselect = SelectField($fieldselect, $condition_options['field'][$c]);

                echo "<tr class='conditions_row' style='margin:5px 0;'>";
                echo "<td><select src='field' class='form-control' id='field" . ($c + 1) . "' name='field" . ($c + 1) . "'>" . $fieldselect . "</select></td>";
                echo "<td><select src='condition' class='form-control' id='condition" . ($c + 1) . "' name='condition" . ($c + 1) . "'>";
                echo "	<option value=\"" . isset($condition_options['condition'][$c]) . "\" selected>" . isset($condition_options['condition'][$c]);
                echo "	<option value='is'>" . _SELECT_IS . "</option>";
                echo "	<option value='contains'>" . _CONTAINS . "</option>";
                echo "	<option value='nocontain'>" . _NOT_CONTAINS . "</option>";
                echo "	<option value='start'>" . _STARTS_WITH . "</option>";
                echo "	<option value='end'>" . _ENDS_WITH . "</option>";
                echo "	<option value='isnot'>" . _SELECT_IS_NOT . "</option>";
                echo "</select></td>";
                echo "<td><input src='cvalue' class='form-control qbuilderhelp' rel='" . ($c + 1) . "' name='cvalue" . ($c + 1) . "' id='cvalue" . ($c + 1) . "' value='" . isset($condition_options['cvalue'][$c]) . "' autocomplete='off'></td>";
                echo "<td><button type='button'class='plus_btn noOption btn btn-default'> &plus; </button></td>
								<td><button type='button' class='min_btn noOption btn btn-default'> &minus; </button></td>";
                echo "</tr>";
            }
        }
        echo "</table>";
        echo "</div>";

        echo "<script type='text/javascript'>
		$(document).ready(function(){
			plusMinusForm('{$form_id}', 'field', 'condition', 'cvalue');

			conf_name = '{$this->profile->profilename}';
			from_date = {$this->from};
			to_date = {$this->to};
			$('.conditions').on('click keyup','.qbuilderhelp', function(event) {
				QBuilderHelpForms($(this).val(), event, $(this).val() + '@' + 'cvalue' + $(this).attr('rel') + '@' + $('#field' + $(this).attr('rel')).val(), 'forminput');
			});
		});

		</script>";

        echo "<div class='form-group'>";
        echo "<label for='dhistory'>" . _DISPLAY . ":</label>";
        echo "<select class='report_option_field form-control' id='dhistory' name='dhistory'>";
        echo "<option value='all'>" . _FULL_VISITOR_HISTORY . "</option>";
        echo "<option value='daterange'";
        if (isset($this->dhistory) == "daterange") {
            echo "selected";
        }
        echo ">" . _SHOW_HISTORY_IN_DATE_RANGE . "</option>";
        echo "</select>";
        echo "</div>";
    }

    function DefineReport()
    {
        $this->DisplayReport();
    }

    function DisplayReport()
    {
        global $db, $gi, $cnames;

        $stop = 0;


        if (!empty($this->visitorid) && isset($this->cvalue1) == "") {
            $this->cvalue1 = $this->visitorid;
            $this->condition1 = "is";
            $this->field1 = "visitorid";
        } else {
            if (!empty($this->ip) && (isset($this->cvalue1) && empty($this->cvalue1))) {
                $this->cvalue1 = $this->ip;
                $this->condition1 = "is";
                $this->field1 = "ipnumber";
            }
        }

        if (isset($this->cvalue1) && $this->cvalue1 != "") {
            $i = 1;
            $andor = $andor ?? $this->andor;
            while ($i < 25) {
                $cvalue = $cvalue ?? $this->{'cvalue' . $i};
                if ($cvalue != "") {
                    $field = $field ?? $this->{'field' . $i};
                    if ($field == "") {
                        echoWarning(_UNKNOWN . " type: " . $cvalue . "<br>" . _PLEASE_SELECT_FIELD);
                        return false;
                    }

                    $condition = $condition ?? $this->{'condition' . $i};
                    if ($field == "keywords") {
                        //$cvalue=urlencode($cvalue);
                    } else {
                        $cvalue = urldecode($cvalue);
                    }
                    if ($field == "refparams" || $field == "params") {
                        $cvalue = str_replace(" ", "+", $cvalue);
                    }

                    # make sql string
                    if ($condition == "contains") {
                        $op = "$field LIKE " . $db->Quote("%{$cvalue}%");
                    } elseif ($condition == "nocontain") {
                        $op = "$field NOT LIKE " . $db->Quote("%{$cvalue}%");
                    } elseif ($condition == "start") {
                        $op = "$field LIKE " . $db->Quote("{$cvalue}%");
                    } elseif ($condition == "end") {
                        $op = "$field LIKE " . $db->Quote("%{$cvalue}");
                    } elseif ($condition == "is") {
                        $iid = $this->GetMatchingItemID($field, $condition, $cvalue);
                        if ($field == "ipnumber" || $field == "useragent" || $iid === false) {
                            $op = "$field =" . $db->Quote("$cvalue");
                        } else {
                            $op = "$field =" . $db->Quote($this->GetMatchingItemID($field, $condition, $cvalue));
                        }
                    } else {
                        if ($condition == "isnot") {
                            $iid = $this->GetMatchingItemID($field, $condition, $cvalue);
                            if ($field == "ipnumber" || $field == "useragent" || $iid === false) {
                                $op = "$field !=" . $db->Quote("$cvalue");
                            } else {
                                $op = "$field !=" . $db->Quote($this->GetMatchingItemID($field, $condition, $cvalue));
                            }
                        }
                    }

                    if ($i == 1) {
                        $sqlstring = " {$op}";
                    } else {
                        $sqlstring .= " {$andor} {$op}";
                    }
                }
                $i++;
            }
            $filter = 1;
        }

        # we need to rewrite the sqlstring to the new style tables
        $joincond = "";
        $addtables = "";
        if (isset($sqlstring)) {
            if (strpos("  " . $sqlstring, " url ") != false) {
                $sqlstring = str_replace("url =", "a.url=", $sqlstring);
                $sqlstring = str_replace("url !=", "a.url!=", $sqlstring);
                $sqlstring = str_replace("url LIKE", "u.url LIKE", $sqlstring);
                $sqlstring = str_replace("url NOT LIKE", "u.url NOT LIKE", $sqlstring);
                $addtables = ",{$this->profile->tablename_urls} as u";
                $joincond = "and a.url=u.id";
            }

            if (strpos("  " . $sqlstring, " params ") != false) {
                $sqlstring = str_replace("params =", "a.params=", $sqlstring);
                $sqlstring = str_replace("params !=", "a.params!=", $sqlstring);
                $sqlstring = str_replace("params LIKE", "up.params LIKE", $sqlstring);
                $sqlstring = str_replace("params NOT LIKE", "up.params NOT LIKE", $sqlstring);
                $addtables .= ",{$this->profile->tablename_urlparams} as up";
                $joincond .= " and a.params=up.id";
            }

            if (strpos("  " . $sqlstring, " referrer ") != false) {
                $sqlstring = str_replace("referrer =", "a.referrer=", $sqlstring);
                $sqlstring = str_replace("referrer !=", "a.referrer!=", $sqlstring);
                $sqlstring = str_replace("referrer LIKE", "r.referrer LIKE", $sqlstring);
                $sqlstring = str_replace("referrer NOT LIKE", "r.referrer NOT LIKE", $sqlstring);
                $addtables .= ",{$this->profile->tablename_referrers} as r";
                $joincond .= " and a.referrer=r.id";
            }

            if (strpos("  " . $sqlstring, " refparams ") != false) {
                $sqlstring = str_replace("refparams =", "a.refparams=", $sqlstring);
                $sqlstring = str_replace("refparams !=", "a.refparams!=", $sqlstring);
                $sqlstring = str_replace("refparams LIKE", "rp.params LIKE", $sqlstring);
                $sqlstring = str_replace("refparams NOT LIKE", "rp.params NOT LIKE", $sqlstring);
                $addtables .= ",{$this->profile->tablename_refparams} as rp";
                $joincond .= " and a.refparams=rp.id";
            }

            if (strpos("  " . $sqlstring, " keywords ") != false) {
                $sqlstring = str_replace("keywords =", "a.keywords=", $sqlstring);
                $sqlstring = str_replace("keywords !=", "a.keywords!=", $sqlstring);
                $sqlstring = str_replace("keywords LIKE", "k.keywords LIKE", $sqlstring);
                $sqlstring = str_replace("keywords NOT LIKE", "k.keywords NOT LIKE", $sqlstring);
                $addtables .= ",{$this->profile->tablename_keywords} as k";
                $joincond .= " and a.keywords=k.id";
            }

            if (strpos("  " . $sqlstring, " ipnumber ") != false) {
                $sqlstring = str_replace("ipnumber =", "v.ipnumber=", $sqlstring);
                $sqlstring = str_replace("ipnumber !=", "v.ipnumber!=", $sqlstring);
                $sqlstring = str_replace("ipnumber LIKE", "v.ipnumber LIKE", $sqlstring);
                $sqlstring = str_replace("ipnumber NOT LIKE", "v.ipnumber NOT LIKE", $sqlstring);
            }

            if (strpos("  " . $sqlstring, " visitorid ") != false) {
                $sqlstring = str_replace("visitorid =", "v.visitorid=", $sqlstring);
                $sqlstring = str_replace("visitorid !=", "v.visitorid!=", $sqlstring);
                $sqlstring = str_replace("visitorid LIKE", "v.visitorid LIKE", $sqlstring);
                $sqlstring = str_replace("visitorid NOT LIKE", "v.visitorid NOT LIKE", $sqlstring);
            }

            if (strpos("  " . $sqlstring, " useragent ") != false) {
                $sqlstring = str_replace("useragent =", "b.name=", $sqlstring);
                $sqlstring = str_replace("useragent !=", "b.name!=", $sqlstring);
                $sqlstring = str_replace("useragent LIKE", "b.name LIKE", $sqlstring);
                $sqlstring = str_replace("useragent NOT LIKE", "b.name NOT LIKE", $sqlstring);
            }
        }

        $this->ReportHeader();

        if (isset($filter)) {
            if (isset($sqlstring) != "") {
                $query = "SELECT v.customlabel AS customlabel,v.id AS id,v.visitorid AS visitorid, MAX(v.ipnumber) AS ipnumber, count(*) AS hits, FROM_UNIXTIME(MIN(a.timestamp), '%d-%b-%Y %a') AS day, MAX(a.country) AS country, CONCAT(b.name, ' ', b.version) AS useragent FROM {$this->profile->tablename} as a, {$this->profile->tablename_useragents} as b, {$this->profile->tablename_visitorids} as v {$addtables} WHERE a.visitorid = v.id AND a.useragentid = b.id AND a.timestamp BETWEEN " . $db->quote(
                        $this->from
                    ) . " AND " . $db->quote(
                        $this->to
                    ) . " {$joincond} AND ({$sqlstring}) GROUP BY a.visitorid ORDER BY a.timestamp DESC limit {$this->limit}";

                $query = subsetDataToSourceID($query, $this->trafficsource);

                $logfile = $db->Execute($query);
                $num_matches = $logfile->NumRows();
            }
            $i = 0;


            # maak effe een random id Jonguh!
            $md5_time = md5(time());
            $menu_id = 'dg' . $md5_time . rand(1, 1000);

            ?>
            <div class="btn-group">
                <button data-toggle="dropdown" class="btn btn-default dropdown-toggle" type="button">
                    Matching Visitors (<?php
                    echo $num_matches; ?>) <i class='fa fa-angle-down'></i>
                </button>
                <ul id='<?php
                echo $menu_id; ?>' class="dropdown-menu" style="height:300px; overflow-y:auto">
                    <?php

                    while ($loglines = $logfile->FetchRow()) {
                        # If a visitor ID wasn't passed in, then select the first one as the one we want to highlight.
                        $this->customlabel = $loglines["customlabel"];
                        $this->custom_id = $loglines["id"];
                        if (!isset($this->visitorid)) {
                            $this->visitorid = $loglines["visitorid"];
                        }
                        $s = "";
                        if ($loglines["visitorid"] == $this->visitorid) {
                            $s = "bg-green";
                        }
                        if ($loglines["country"]) {
                            $cparts = explode(", ", $loglines["country"]);
                            $ccode = strtolower(((count($cparts) > 1) && ($cparts[1] > "")) ? $cparts[1] : $cparts[0]);
                        } else {
                            $ccode = "";
                        }

                        if (isset($gi)) {
                            try {
                                $area = $gi->city($loglines["ipnumber"]);
                            } catch (Exception $e) {
                                $area = [];
                            }
                            if (!empty($area)) {
                                if (!empty($area->raw['city'])) {
                                    $city = $area->country->name . ", " . $area->city->name;
                                } else {
                                    $city = _UNKNOWN_CITY;
                                }
                            }

                            if (!empty($ccode)) {
                                $image = "<img width=14  height=11 src=\"images/flags/$ccode.png\" style=\"margin-left:-3px;margin-right:6px;\">";
                            } else {
                                $image = "<img width=14  height=11 src=\"images/flags/com.png\" style=\"margin-left:-3px;margin-right:6px;\">";
                            }
                        } else {
                            $image = "";
                            $city = "";
                            $area = "";
                        }


                        $additional_params = "";
                        foreach ($this->options as $optionkey => $optionvalue) {
                            if ($optionkey == "visitorid" || $optionkey == "conf") {
                                continue;
                            }
                            $additional_params .= "&" . urlencode($optionkey) . "=" . urlencode($optionvalue);
                        }

                        $additional_params .= "&" . "visitorid" . "=" . urlencode($loglines["visitorid"]);
                        echo "<li class='$s'><a href=\"reports.php?conf={$this->profile->profilename}&$additional_params\" class=\"open_in_this_dialog\">$image " . $loglines["ipnumber"] . "  " . isset($loglines["day"]);

                        echo "</a></li>\n";
                        $i++;
                    }
                    ?>

                </ul>
            </div>
            <script>
                $(".<?php echo $menu_id ?>.prev_visitor").on("click", function () {
                    console.log("prev");
                    $("#<?php echo $menu_id ?> li.bg-green").prev("li").find("a").click();

                });
                $(".<?php echo $menu_id ?>.next_visitor").on("click", function () {

                    $("#<?php echo $menu_id ?> li.bg-green").next("li").find("a").click();
                });

            </script>

            <?php
            echo "<div class='btn-group pull-right'>";
            echo "<button class='$menu_id btn btn-default prev_visitor'><i class='fa fa-angle-left'></i> " . _PREVIOUS_VISITOR . " </button> ";
            echo "<button class='$menu_id btn btn-default next_visitor'>" . _NEXT_VISITOR . " <i class='fa fa-angle-right'></i></button>";
            echo "</div><br><br>";


            if ($i == 0) {
                $stop = 1;
            }
        }

    if (!empty($this->visitorid) || !empty($this->ip)) {
        $lasttimestamp = 0;
        if ($this->visitorid) {
            $selector = "v.visitorid = " . $db->quote($this->visitorid);
        } else {
            $selector = "v.ipnumber = " . $db->quote($this->ip) . "";
        }

        if (isset($this->dhistory) == "daterange") {
            $selector .= " and a.timestamp >=" . $db->quote($this->from) . " and a.timestamp <=" . $db->quote(
                    $this->to
                );
        }

        $query = $db->Execute(
            "SELECT a.timestamp, v.ipnumber, u.url, up.params, r.referrer, rp.params AS refparams, b.name AS useragent, v.visitorid, a.status, a.crawl, b.useragent as ua, a.country FROM " . $this->profile->tablename_merge . " AS a, {$this->profile->tablename_useragents} AS b, {$this->profile->tablename_urls} AS u, {$this->profile->tablename_urlparams} AS up, {$this->profile->tablename_referrers} AS r,{$this->profile->tablename_refparams} AS rp,{$this->profile->tablename_visitorids} AS v WHERE a.visitorid = v.id AND {$selector} AND a.url = u.id AND a.params = up.id AND a.referrer = r.id AND a.refparams = rp.id and b.id = a.useragentid ORDER BY a.timestamp"
        );

        $i = 0;
        $gr = 1;
        $last_time_user_left = false;
    while ($loglines = $query->FetchRow()) {
        $ipnumber = $loglines["ipnumber"];
        $logtimestamp = $loglines["timestamp"];
        $logtime = date("D, d-m-Y H:i:s", $logtimestamp);
        $geturl = $loglines["url"];
        if ($loglines["params"] != "") {
            $geturl = $loglines["url"] . $loglines["params"];
        }
        $refurl = $loglines["referrer"];
        if ($loglines["refparams"] != "?") {
            $refurl = $loglines["referrer"] . $loglines["refparams"];
        }
        if (strlen($refurl) > 35) {
            $refurln = substr($refurl, 0, 35) . "...";
        } else {
            $refurln = $refurl;
        }
        $timespent = $logtimestamp - $lasttimestamp;
        $min = number_format(($timespent / 60), 1);
        if (($logtimestamp - $lasttimestamp) > 72000) {
            $logtime = "<b>$logtime</b>";
            $newday = 1;
        } else {
            $newday = 0;
        }

        $lasttimestamp = $logtimestamp;


        # Put in the header row...
    if ($i == 0) {
        $this->ip = $loglines['ipnumber'];
        if (isset($gi)) {
            try {
                $area = $gi->city($loglines["ipnumber"]);
            } catch (Exception $e) {
                $area = [];
            }
            if (!empty($area)) {
                if (!empty($area->raw['city'])) {
                    $city = $area->country->name . ", " . $area->city->name;
                } else {
                    $city = _UNKNOWN_CITY;
                }
            }
        }


        ?>
        <div>
            <ul class="timeline">
                <li class="time-label">
						<span class="bg-navy">
							<?php
                            echo _CLICK_TRAIL_FOR_V_FROM; ?>
                            <?php
                            if (isset($cnames[$loglines['country']])) {
                                $loc = $cnames[$loglines['country']] . " ($city)";
                            } else {
                                $loc = " " . _AN_UNKOWN_LOCATION;
                            }

                            echo "$loc " . str_replace(
                                    "%X%",
                                    "<a target=_blank href=\"\" onclick=\"popupActionMenu(event, '" . $this->ip . ";" . isset($this->visitorid) . "', 'ipnumber');\">{$this->ip}</a>",
                                    _WITH_IP_X_USING
                                ) . " " . $loglines["useragent"] . " ";

                            if ($loglines["crawl"] != 0) {
                                echo " [Bot/Crawler]";
                            }
                            ?>
						</span>
                </li>
                <!-- /.timeline-label -->
                <?php
                }

                if ($newday == 0) {
                    $last_time_user_left = false;
                    if ($min > 60) {
                        $hours = number_format(($min / 60), 1);
                        $msg = str_replace("2", $hours, X_HOURS_LATER);
                        $spentcolor = "red";
                    } else {
                        if ($timespent > 60) {
                            $msg = str_replace("2", $min, X_MINUTES_LATER);
                            $spentcolor = "yellow";
                        } else {
                            $msg = str_replace("2", $timespent, X_SECONDS_LATER);
                            $spentcolor = "aqua";
                        }
                    }
                    ?>
                    <li class="time-label">
                        <span class="bg-<?php
                        echo $spentcolor; ?>"> <?php
                            echo $msg; ?> </span>
                    </li>
                    <?php
                } else {
                    if ($i != 0) {
                        $last_time_user_left = true;
                        ?>
                        <li>
                            <i class="fa fa-sign-out bg-red"></i>
                            <div class="timeline-item">
                                <h3 class="timeline-header">
                                    <?php
                                    echo _USER_LEFT; ?><br/>
                                </h3>
                            </div>
                        </li>
                        <?php
                    }
                }

                if (empty($this->profile->confdomain) || strpos($refurl, $this->profile->confdomain) == false) {
                    if (strpos($refurl, "G]") != false) {
                        $gsyn = substr($refurl, 3);
                        $refurln = $gsyn;
                        $gsyn = "<img src=images/google.png border=0 alt='Via Google Ads: $refurl'>&nbsp;";
                        $refurl = $refurln;
                    } else {
                        $gsyn = "";
                    }
                    $refurln = "$gsyn<a class=greenlink2 href=\"\" onclick=\"popupMenu(event, '" . urlencode(
                            $refurl
                        ) . "', 'clicktrailreferrer');\">$refurln</a>";
                }
                if ($gr == 3) {
                    $gr = 1;
                    $bgcol = "bgcolor=#F8F8F8";
                } else {
                    $gr++;
                    $bgcol = "";
                }
                # this is to make the searched element stick out, but it ned work (all the other cvalues should be check, maybe load in array and do array search)
                if ($geturl == isset($_REQUEST["cvalue1"]) || $refurl == isset($_REQUEST["cvalue1"])) {
                    $bgcol = "bgcolor=yellow";
                }

                if ($last_time_user_left == true) {
                    ?>
                    <li class="time-label">
						<span class="bg-blue">
							<?php
                            $hours = number_format(($timespent / 60 / 60), 1);
                            if ($hours > 24) {
                                $days = number_format(($timespent / 60 / 60 / 24), 1);
                                echo str_replace("2", $hours, _USER_RETURNED_AFTER_X_DAYS);
                            } else {
                                echo str_replace("2", $hours, _USER_RETURNED_AFTER_X_HOURS);
                            }
                            ?>
						</span>
                    </li>
                    <?php
                }


                if ($loglines['status'] != 200) {
                    $timeline_color = "maroon";
                } else {
                    $timeline_color = "green";
                }
                ?>
                <!-- timeline item -->
                <li>
                    <i class="fa fa-sign-in bg-<?php
                    echo $timeline_color; ?>"></i>
                    <div class="timeline-item">
                        <span class="time"><i class="fa fa-clock-o"></i> <?php
                            echo $logtime; ?></span>
                        <h3 class="timeline-header"><?php
                            echo "<a href=\"\" class=\"cuturl\" onclick=\"popupActionMenu(event, '" . urlencode(
                                    $geturl
                                ) . "', 'clicktrailpage');\">$geturl</a>"; ?></h3>
                        <div class="timeline-body">
                            <?php
                            echo _REFERRING_PAGE; ?>: <?php
                            echo $refurl; ?><br/>
                            <?php
                            echo _STATUS; ?>: <?php
                            echo $loglines['status']; ?>
                        </div>
                    </div>
                </li>

                <?php


                $i++;
                }
                echo "</ul></div>";
                $stop = 1;
                }

                if (!$stop) {
                    echoNotice(
                        $this->SettingsButton() . _NO_OPTIONS_FOUND . "<br><br><span>" . _CLICK_TRAILS_HELP . "</span>"
                    );
                }
                ?>
                </td>
                </tr>
                </table>
        <?php
    }

    function GetMatchingItemID($field, $condition, $cvalue)
    {
        $table = getTable($field);
        if ($table === false) {
            return false;
        }
        $tfield = getField($table);
        if ($tfield === false) {
            return false;
        }
        return getID($cvalue, $table);
    }

    function UpdateStats($from = '', $to = '', $print = 2)
    {
        return false;
    }
}