<?php

/**
 * @desc This report displays a visitors per day table
 */
if (!defined('APP_INCLUDE')) {
    die('invalid inclusion');
}

class FacebookCore extends Report
{
    # This array must define for each facebook report which accounts are useable.. app , page or all
    var $metric_restriction = "page";

    function Settings()
    {
        global $reports;


        if ($reports[$this->label_constant]["ReportVersion"] < 4) {
            if (file_exists("reports/{$reports[$this->label_constant]["Filename"]}.php")) {
                echoWarning(
                    "This report is outdated. Please remove <b>{$reports[$this->label_constant]["Filename"]}.php</b> from the reports directory."
                );
                exit;
            }
        }

        $this->DefaultDisplay = "linechart";
        $this->displayHelp = true;
        $this->appName = "";
        $this->displayReportButtons = false;
        $this->graphID = "LGFBC" . md5(time() + rand(0, 11000));
    }

    function DisplayCustomForm()
    {
        global $template;
        $optionsID = "O" . md5(time() + rand(0, 11000));

        ?>
        <script type="text/javascript">
            function lg_fb_<?php echo $optionsID; ?>_Showpages(data) {
                if (data.Status != undefined && data.Status == "Success") {
                    let lg_fb_options = "";
                    const c_app_id = "<?php echo $this->appID; ?>";
                    const restriction = "<?php echo $this->metric_restriction; ?>";

                    if (restriction == "page" && data.Data.pages.length == 0) {
                        $("#<?php echo $optionsID; ?>").html("We have not found any Facebook pages associated with your user.");
                        return false;
                    } else if (restriction == "app" && data.Data.apps.length == 0) {
                        $("#<?php echo $optionsID; ?>").html("We have not found any Facebook applications associated with your user.");
                        return false;
                    } else if (data.Data.pages.length == 0 && data.Data.apps.length == 0) {
                        $("#<?php echo $optionsID; ?>").html("We have not found any Facebook pages/applications associated with your user.");
                        return false;
                    }

                    if (restriction == "page" || restriction == "all") {
                        $.each(data.Data.pages, function (k, v) {
                            if (c_app_id == v.id) {
                                lg_fb_options += "<option value='" + v.id + "[S]" + v.name + "' selected='selected'>" + v.name + "</option>";
                            } else {
                                lg_fb_options += "<option value='" + v.id + "[S]" + v.name + "'>" + v.name + "</option>";
                            }
                        });
                    }

                    if (restriction == "app" || restriction == "all") {
                        $.each(data.Data.apps, function (k, v) {
                            if (c_app_id == v.id) {
                                lg_fb_options += "<option value='" + v.id + "[S]" + v.name + "' selected='selected'>" + v.name + "</option>";
                            } else {
                                lg_fb_options += "<option value='" + v.id + "[S]" + v.name + "'>" + v.name + "</option>";
                            }
                        });
                    }

                    if (data.Data.length === 0) {
                        $("#<?php echo $optionsID; ?>").html("We have not found any Facebook pages associated with your user.");
                    } else if (lg_fb_options != "") {
                        $("#<?php echo $optionsID; ?>").html("<label>Please choose your account:</label><select id='appID' class='report_option_field form-control' name='app_select'>" + lg_fb_options + "</select>");
                    }
                }
            }

            function lg_fb_<?php echo $optionsID; ?>_ShowLogin() {
                $("#<?php echo $optionsID; ?>").html("<?php echo _FACEBOOK_LOGIN_SETTINGS_WARNING; ?>");
            }
        </script>
        <script type="text/javascript" src="//facebook.logaholic.com/authorization/stats/?json&id=<?php
        echo $optionsID; ?>"></script>
        <?php
        echo "<div id='{$optionsID}' class='form-group'>Loading your Facebook details...<br/><br/></div>";
        $r = logaholic_url(true);
        if (substr($r, -1) != "/") {
            $r .= "/";
        }
        $r .= "dashboard.php?conf={$this->profile->profilename}&dashboard=Autosaved Workspace";

        $url = "//facebook.logaholic.com/authorization/stats/?iframe&return=" . urlencode($r);
        echo "<div class='form-group'>";
        echo "<label>&nbsp;</label>";
        echo "<a class='btn btn-success form-control open_iframe_window' href='{$url}'>" . _EDIT_FACEBOOK_CONF . "</a>";
        echo "</div>";
    }

    function DisplayReport()
    {
        # Set default appID if we have it stored in a COOKIE
        if (!empty($this->appID)) {
            $this->SaveAppID();
        } else {
            if (!empty($_COOKIE['lg_fb_appID'])) {
                $this->SetAppID();
            }
        }

        if (!empty($this->appID)) {
            $parts = explode("[S]", $this->appID);
            $this->appID = $parts[0];
            $this->appName = $parts[1];
            $this->addlabel = $this->appName . " | " . $this->addlabel;
        }


        $this->reportHeader();

        if (empty($this->appID)) {
            echoNotice($this->SettingsButton() . _FACEBOOK_SELECT_APP_PAGE_WARNING);
            return false;
        }

        if ($this->displaymode == "table") {
            echo "<table id='{$this->graphID}' class='dataTable js_filled_datatable report_table' cellspacing=0 cellpadding=2 border=0 width='100%'></table>";
            $this->DisplayTable();
        } else {
            if ($this->displaymode == "pie") {
                echo "<div id='{$this->graphID}' coldefs='{}' limit='{$this->limit}' data-ticks='{}' data-coldefs='[]' data-chartoptions='{}'><svg><text dy='31' dx='20'>Loading Graph...</text></svg></div>";
                $this->DisplayPie();
            } else {
                echo "<div id='{$this->graphID}' coldefs='{}' limit='{$this->limit}' data-ticks='{}' data-coldefs='[]' data-chartoptions='{}'><svg><text dy='31' dx='20'>Loading Graph...</text></svg></div>";
                $this->DisplayGraph();
            }
        }

        echo "<script type='text/javascript' src='//facebook.logaholic.com/authorization/stats/?page={$this->appID}&m={$this->metric}&from={$this->from}&to={$this->to}&id=$this->graphID'></script>";
    }

    function SaveAppID()
    {
        # Save the last used ID for reports.
        if ($this->metric_restriction == "page") {
            setcookie('lg_fb_pageID', $this->appID, (time() + 3600), "/");
            setcookie('lg_fb_allID', $this->appID, (time() + 3600), "/");
        } else {
            if ($this->metric_restriction == "app") {
                setcookie('lg_fb_appID', $this->appID, (time() + 3600), "/");
                setcookie('lg_fb_allID', $this->appID, (time() + 3600), "/");
            } else {
                setcookie('lg_fb_allID', $this->appID, (time() + 3600), "/");
            }
        }
    }

    # Dummy function this is overwriten in the report(s)

    function SetAppID()
    {
        # Get the last used ID based on the report restriction
        if ($this->metric_restriction == "page" && !empty($_COOKIE['lg_fb_pageID'])) {
            $this->appID = $_COOKIE['lg_fb_pageID'];
        } else {
            if ($this->metric_restriction == "app" && !empty($_COOKIE['lg_fb_appID'])) {
                $this->appID = $_COOKIE['lg_fb_appID'];
            } else {
                if ($this->metric_restriction == "all" && !empty($_COOKIE['lg_fb_allID'])) {
                    $this->appID = $_COOKIE['lg_fb_allID'];
                }
            }
        }
    }

    # Dummy function this is overwriten in the report(s)

    function DisplayTable()
    {
    }

    # Dummy function this is overwriten in the report(s)

    function DisplayPie()
    {
    }

    function DisplayGraph()
    {
    }

    function UpdateStats($from = '', $to = '', $print = 2)
    {
        return false;
    }
}

?>
